#! /bin/ksh

export LIBTOOL_TEST_PKG_SYS="$PWD"

print "removing lib* files from any previous runs in"
print "$LIBTOOL_TEST_PKG_SYS/pkgbuild/opt/foss/lib"
if [ -d $LIBTOOL_TEST_PKG_SYS/pkgbuild/opt/foss/lib ]
then
    rm -f $LIBTOOL_TEST_PKG_SYS/pkgbuild/opt/foss/lib/lib*.*
fi

print "running autoreconf --install --force for old library"
cd old
autoreconf --install --force

print "running configure --prefix $LIBTOOL_TEST_PKG_SYS/usr for old library"
./configure --prefix $LIBTOOL_TEST_PKG_SYS/usr

print "building old library"
make

print "installing old library in $LIBTOOL_TEST_PKG_SYS/usr"
make install
cd ..

print "Setting LDFLAGS for building current library."
print "The current library is being built as a package, in the pkgbuild"
print "subdirectory.  In the real situation, it will be installed later"
print "in the opt/foss subdirectory.  So this is why the LDFLAGS is"
print "is set first find libraries in opt/foss/lib, and then to look"
print "in the usr/lib subdirectory."

export LDFLAGS="-L$LIBTOOL_TEST_PKG_SYS/opt/foss/lib -L$LIBTOOL_TEST_PKG_SYS/usr/lib -R$LIBTOOL_TEST_PKG_SYS/opt/foss/lib -R$LIBTOOL_TEST_PKG_SYS/usr/lib"

print "LDFLAGS set to $LDFLAGS"

print "running autoreconf --install --force for current library"
cd current
autoreconf --install --force

print "running configure --prefix $LIBTOOL_TEST_PKG_SYS/pkgbuild/opt/foss for current library"
./configure --prefix $LIBTOOL_TEST_PKG_SYS/pkgbuild/opt/foss

print "building current library"
make clean
make

print "installing current library in $LIBTOOL_TEST_PKG_SYS/pkgbuild/opt/foss"
make install
cd ..
