require 'libxml'

class XML::Node::Set
	def empty?
		self.length <= 0
	end
	
	def first
		self.each { |n| return n }
	end
end

class XML::Node( *args )
	def first
		arr = self.find( args )
		return arr.first if arr and not arr.empty?
		nil
	end
end

class XML::Document
  include Enumerable

  # maybe, maybe not...
  def each(&blk)
    find('//*').each(&blk)
  end
end

class XML::XPath
  include Enumerable
end

class XML::Node::Set
  include Enumerable

  # inefficient, but maybe can find a way to cache the
  # ary and dump on change?
  def [](i, count = nil)
    if count
      to_a[i,count]
    else
      to_a[i]
    end
  end

  def to_s
    to_a.to_s
  end
end

# :nodoc: all
module XML::SiblingEnum
  private 
  
  # Iterates nodes and attributes
  def siblings(node, &blk)
    if n = node
      loop do
        blk.call(n)
        break unless n = n.next
      end
    end 
  end
end

class XML::Node
  include XML::SiblingEnum
  include Enumerable
  include Comparable
  
  # maybe these don't belong on all nodes...
  def each_child(&blk)
    siblings(child, &blk)   
  end

  def each_attr(&blk)
    siblings(properties, &blk)
  end

  # all siblings INCLUDING self
  def each_sibling(&blk)
    siblings(self, &blk)
  end
  
  # I guess this is what you'd expect?
  alias :each :each_child

  def to_a
    inject([]) { |ary,n| ary << n }
  end
  
  def <=>(other)
    raise TypeError, %|Cannot convert #{other.class} to Node| unless other.is_a? XML::Node 
    name <=> other.name
  end
  
end

class XML::Attr
  include XML::SiblingEnum
  include Enumerable

  def each_sibling(&blk)
    siblings(self,&blk)
  end

  alias :each_attr :each_sibling
  alias :each :each_sibling
  
  def to_h
    inject({}) do |h,a| h[a.name] = a.value end
  end

  def to_a
    inject([]) do |ary,a| ary << [a.name, a.value] end
  end
  
  def to_s
    "#{name} = #{value}"
  end
end

if $0 == __FILE__ 
  xp = XML::Parser.string(DATA.read)
  d = xp.parse
  p d

  puts "Doc collect   : #{(d.collect do |n| n.name end).join(', ')}\n"

  n = d.root
  xpath = n.pointer 'xpointer(id("two"))'
  puts "XPath.collect : #{xpath.collect do |n| n.name end}\n"

  foos = d.find '//foo'
  puts "Nodeset.to_a  : #{foos.to_a.inspect}"
  puts "Nodeset.to_s  : #{foos}"

  nodeset = d.find '//foo|bar'
  puts "Nodeset inject: #{(nodeset.inject([]) do |ary, n| ary << n.name end).inspect}"
  puts "Nodeset select: #{(nodeset.select {|n| n['id'] == 'one' || n['id'] == 'five'}).inspect}"
  puts "Nodeset [2]   : #{(d.find('//foo')[2]).inspect}"
  puts "Nodeset [0,2] : #{(d.find('//*')[1,2]).inspect}" 
  puts "Splat         : #{[*d.find('//foo')].inspect}\n"

  # These all work through each child
  puts "Node collect  : #{(d.root.collect do |n| n.name end).join(', ')}"
  puts "ra < foo?     : #{d.root < d.root.child}"
  puts "ra > foo?     : #{d.root > d.root.child}"
  puts "to_a.sort     : #{(d.root.to_a.sort).join(%|\n              : |)}\n"

  # This DOESNT cause a segfault
  d.root.each_attr do |n| puts "Each attr     : #{n}" end

  # alternatively
  # THIS LINE TRIGGERS THE SEGFAULT AT EXIT BUG
  # d.root.properties.each do |n| puts "Each attr        : #{n}" end

  # AS DO THESE
  #puts "Attr.to_h     : #{d.root.properties.to_h.inspect}"
  #puts "Attr.to_a     : #{d.root.properties.to_a.inspect}"
end

__END__
<!DOCTYPE ra [<!ELEMENT ra (foo+, bar+)><!ATTLIST ra id ID #IMPLIED><!ELEMENT foo (#PCDATA)><!ATTLIST foo id ID #IMPLIED><!ELEMENT bar (#PCDATA)><!ATTLIST bar id ID #IMPLIED>]><ra id="start"><foo id="one">one</foo><bar id='six'>barone</bar><foo id="two">two</foo><foo id="three">three</foo><bar id='five'/></ra>
