\version "2.6.0"

\include "drumpitch-init.ly"
\include "impro.inc.ly"

#(define mydrums '(
    (hihat       cross   #f         4)
    (snare       ()      #f         1)
    (bassdrum    ()      #f         -5)
    (lowtom      ()      #f         -1)
    (himidtom    ()      #f         2)
    (ridecymbal  cross   #f         5)
    (crashcymbal cross   #f         6)))

firstBreak = \drummode {
    \improOn
    sn4\mp sn
    \improOff
}

firstThemeUp = \drummode {
    hh8 hh hh hh hh hh hh hh
    hh hh hh hh hh hh hh hh |
}

firstThemeDown = \drummode {
    bd4 sn8. sn16 bd8 bd sn bd
    bd4 sn8 bd4 bd sn8 |
}

impro = \drummode {
    \once\override TextScript #'padding = #2.0
    \improOn
    sn4\ff^"Solo" sn sn sn
    sn sn sn sn |
    sn4 sn sn sn
    sn sn sn sn |
    \improOff
}

secondThemeUp = \drummode {
    cymr8 cymr cymr cymr cymr cymr cymr cymr |
}

secondThemeDown = \drummode {
    bd4. bd8 bd4 sn |
}

thirdThemeUp = \drummode {
    \times 2/3 { cymr4 cymr cymr } hh8 s s4 |
}
thirdThemeDown = \drummode {
    \times 2/3 { bd4 bd bd } sn8 \improOn sn sn4 \improOff |
}

fourthThemeUp = \drummode {
    \firstThemeUp
}

fourthThemeDown = \drummode {
    bd8. bd16 sn8. bd16 bd8. bd16 sn8. bd16 |
    bd8. bd16 sn8. bd16 bd sn8 bd16 sn8. bd16 |
}

fifthThemeUpFirstPart = \drummode {
    \times 2/3 { hh4 hh hh } hh8 hh cymc hh |
}
fifthThemeUpSecondPart = \drummode {
    hh hh hh hh hh hh hh hh |
}

fifthThemeDownFirstPart = \drummode {
    \times 2/3 { bd4 bd sn } bd4 sn |
}
fifthThemeDownSecondPart = \drummode {
    bd8. bd16 sn8 bd bd4 sn |
}

sixthThemeUp = \drummode {
    hh8 hh hh hh hh hh hh cymc |
}

sixthThemeDown = \drummode {
    bd8 bd <bd sn> bd bd bd <bd sn> bd |
}

secondBreakUp = \drummode {
    hh8 hh hh hh hh hh hh hh |
    s1 |
}

secondBreakDown = \drummode {
    \override TextScript #'padding = #3.0
    bd4 sn8. sn16_\markup{ \italic "accel." } bd8 bd sn s |
    \improOn
    sn4 sn sn sn |
    \improOff
}

seventhThemeUp = \drummode {
    hh8 hh hh hh hh hh hh hh |
}

seventhThemeDown = \drummode {
    bd8. bd16 sn8. bd16 bd8. bd16 sn8. bd16 |
}

eighthThemeUp = \drummode {
    hh8 hh hh hh hh16 cymc8. cymr8 cymc |
}
eighthThemeDown = \drummode {
    bd8. bd16 sn8. bd16 bd sn8. sn8 sn |
}

ninthThemeUp = \drummode {
    cymc8 cymc hh hh hh hh hh hh |
}
ninthThemeDown = \drummode {
    bd8 bd sn8. bd16 bd8. bd16 sn8. bd16 |
}

firstTempoUp = \drummode {
    s1*8/4*7 |
%
    s1 s1 |
%
    \repeat percent 8 {
	\firstThemeUp
    }
%
    \firstThemeUp
    \firstThemeUp
    hh8 hh hh hh hh hh hh hh |
%
    s1*17 |
%
    \repeat volta 2 {
	\repeat percent 4 {
	    \secondThemeUp
	}
    }
    hh8 hh hh hh hh2 cymc8-. s8 s4 cymc8 cymr cymc4 |
%
    \repeat percent 4 {
	\thirdThemeUp
    }
    \repeat percent 8 {
	\thirdThemeUp
    }
    \repeat percent 4 {
	\thirdThemeUp
    }
    cymr8-. s s4 s2 s1 |
%
    s1*8/4*5 |
%
    \fourthThemeUp
    \fourthThemeUp
    \repeat percent 2 {
	\fourthThemeUp
    }
    \repeat volta 2 {
	\repeat percent 5 {
	    \fourthThemeUp
	}
    }
    \repeat percent 2 {
	\fourthThemeUp
    }
%
    \repeat percent 2 {
	\fifthThemeUpFirstPart
	\fifthThemeUpSecondPart
    }
    \fifthThemeUpFirstPart
%
    \sixthThemeUp
    \sixthThemeUp
    \sixthThemeUp
    \sixthThemeUp
    \improOn
    sn4 sn sn sn |
    \improOff
%
    \secondBreakUp
}

firstTempoDown = \drummode {
    \revert MultiMeasureRest #'staff-position
    \override Voice.Rest #'staff-position = #0
    R1*4/4*14 |
%
    r1 |
    r2 \firstBreak |
%
    \repeat percent 8 {
	\firstThemeDown
    }
%
    \firstThemeDown
    bd4 sn8. sn16 bd8 bd sn bd
    bd4 sn8 bd bd\p\< <bd sn> <bd sn> <bd sn> |
    <bd sn> <bd sn> <bd sn> <bd sn>
    <bd sn> <bd sn> <bd sn> <bd sn>
    \improOn
    sn4 sn sn sn\ff |
    \improOff
%
    \impro
%
    \repeat percent 4 {
	bd4 bd bd bd |
	bd bd bd bd |
    }
%
    \impro
%
    \repeat volta 2 {
	\repeat percent 4 {
	    \secondThemeDown
	}
    }
    <bd sn>8\< <bd sn> <bd sn> <bd sn> <bd sn>
    \times 2/3 { toml16 tommh sn } sn4 <bd sn>8-.\!\sfz r8 r4 <bd sn>8\f <bd sn> <bd sn>4 |
%
    \repeat percent 4 {
	\thirdThemeDown
    }
    \repeat percent 8 {
	<< { \thirdThemeDown }
	   { \once\override DynamicLineSpanner #'padding = #2.0
	     s8\mf } >>
    }
    \repeat percent 4 {
	<< { \thirdThemeDown }
	   { \once\override DynamicLineSpanner #'padding = #2.0
	     s8\f } >>
    }
    bd8-. r r4 r2 r1 |
%
    R1*8/4*5 |
%
   << { \fourthThemeDown } { s4\ff } >>
   << { \fourthThemeDown } { s4\f } >>
   \repeat percent 2 {
       << { \fourthThemeDown } { s4\mf } >>
   }
   \repeat volta 2 {
       \repeat percent 5 {
	   \fourthThemeDown
       }
   }
   \repeat percent 2 {
	\fourthThemeDown
   }
%
    \repeat percent 2 {
	\fifthThemeDownFirstPart
	\fifthThemeDownSecondPart
    }
    \fifthThemeDownFirstPart
%
    bd8. bd16 sn8 bd bd4 sn8 bd |
    \sixthThemeDown
    \sixthThemeDown
    \sixthThemeDown
    bd8 bd bd bd bd bd bd bd |
%
    \secondBreakDown
}

secondTempoUp = \drummode {
    \repeat percent 11 {
	\seventhThemeUp
    }
%
    \eighthThemeUp
    \seventhThemeUp
    \eighthThemeUp
    \repeat percent 3 {
	\ninthThemeUp
	\seventhThemeUp
    }
    \ninthThemeUp
    \eighthThemeUp
}

secondTempoDown = \drummode {
    \revert MultiMeasureRest #'staff-position
    \override Voice.Rest #'staff-position = #0
%
    \repeat percent 11 {
	<< { \seventhThemeDown } { s8.\mf } >>
    }
%
    \eighthThemeDown
    \seventhThemeDown
    \eighthThemeDown
    \repeat percent 3 {
	\ninthThemeDown
	\seventhThemeDown
    }
    \ninthThemeDown
    \eighthThemeDown
}

batterieNotes = {
    \set DrumStaff.drumStyleTable = #(alist->hash-table mydrums)
    \time 4/4
%
    \set Score.skipBars = ##t
%
    \override Score.MetronomeMark   #'padding = #4.0
    \tempo 4 = 100
    <<
	\new DrumVoice { \voiceOne \firstTempoUp }
	\new DrumVoice { \voiceTwo \firstTempoDown }
    >>
    \bar "||"
%
    \tempo 4 = 120
    <<
	\new DrumVoice { \voiceOne \secondTempoUp }
	\new DrumVoice { \voiceTwo \secondTempoDown }
    >>
%
    \bar "|."
%
}
