/*
 * Decompiled with CFR 0.152.
 */
package midiinput;

import java.awt.Component;
import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import javax.swing.JOptionPane;
import midiinput.NamedNote;
import midiinput.ProcessChords;
import midiinput.ReceiveChords;
import midiinput.SetTonality;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.jEdit;

public class MidiInputPlugin
extends EditPlugin {
    public static String[] languages = new String[]{"nederlands", "arabic", "catalan", "deutsch", "english", "espa\u00f1ol", "italiano", "norsk", "portugues", "suomi", "svenska", "vlaams"};
    private static MidiDevice device = null;
    private static Transmitter trans = null;
    private static Receiver r = null;
    private static ProcessChords processor = null;
    private static ArrayList<MidiDevice.Info> MidiDevices = new ArrayList();
    private static MidiDevice.Info currentMidiInfo = null;

    public void start() {
        MidiInputPlugin.buildDeviceList();
        processor = new ProcessChords(jEdit.getIntegerProperty((String)"midiinput.language", (int)0), new NamedNote(0, 0), 0);
        r = new ReceiveChords(processor);
        MidiInputPlugin.connectToMidi(MidiDevices.get(0));
    }

    private static void buildDeviceList() {
        MidiDevices.clear();
        boolean noError = true;
        if (device != null) {
            device.close();
        }
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            noError = true;
            System.out.println(infos[i]);
            try {
                device = MidiSystem.getMidiDevice(infos[i]);
            }
            catch (MidiUnavailableException e) {
                noError = false;
            }
            if (!device.isOpen() && noError) {
                try {
                    device.open();
                }
                catch (MidiUnavailableException e) {
                    noError = false;
                }
            }
            if (noError) {
                try {
                    trans = device.getTransmitter();
                }
                catch (MidiUnavailableException e) {
                    noError = false;
                }
            }
            device.close();
            if (noError) {
                MidiDevices.add(infos[i]);
            }
            ++i;
        }
    }

    private static void connectToMidi(MidiDevice.Info info) {
        boolean noError = true;
        currentMidiInfo = info;
        if (device != null) {
            device.close();
        }
        try {
            device = MidiSystem.getMidiDevice(info);
        }
        catch (MidiUnavailableException e) {
            JOptionPane.showMessageDialog((Component)jEdit.getActiveView(), e, "MIDI Error", 0);
            noError = false;
        }
        if (!device.isOpen() && noError) {
            try {
                device.open();
            }
            catch (MidiUnavailableException e) {
                JOptionPane.showMessageDialog((Component)jEdit.getActiveView(), e, "MIDI Error", 0);
                noError = false;
            }
        }
        if (noError) {
            try {
                trans = device.getTransmitter();
            }
            catch (MidiUnavailableException e) {
                JOptionPane.showMessageDialog((Component)jEdit.getActiveView(), e, "MIDI Error", 0);
                noError = false;
            }
        }
        if (noError) {
            trans.setReceiver(r);
        }
    }

    public static void setNewTonality() {
        SetTonality dialog = new SetTonality();
        dialog.getTonalityDialog(processor).setVisible(true);
    }

    public static void setMidiSource() {
        MidiInputPlugin.buildDeviceList();
        MidiDevice.Info newInfo = (MidiDevice.Info)JOptionPane.showInputDialog((Component)jEdit.getActiveView(), "Select MIDI input source:", "Set MIDI Source", -1, null, MidiDevices.toArray(), currentMidiInfo);
        if (newInfo == null) {
            MidiInputPlugin.connectToMidi(currentMidiInfo);
        } else {
            MidiInputPlugin.connectToMidi(newInfo);
        }
    }

    public static void setLanguage(int newLanguage) {
        processor.setLanguage(newLanguage);
    }

    public void stop() {
        device.close();
    }
}

