/*
 * Decompiled with CFR 0.152.
 */
package midiinput;

public class NamedNote {
    private int letterName;
    private int alteration;
    private int octave;
    private boolean hasOctave;
    private static final String[][] nameStrings = new String[][]{{"ceses", "ces", "c", "cis", "cisis", "deses", "des", "d", "dis", "disis", "eses", "es", "e", "eis", "eisis", "feses", "fes", "f", "fis", "fisis", "geses", "ges", "g", "gis", "gisis", "ases", "as", "a", "ais", "aisis", "beses", "bes", "b", "bis", "bisis"}, {"dobb", "dob", "do", "dod", "dodd", "rebb", "reb", "re", "red", "redd", "mibb", "mib", "mi", "mid", "midd", "fabb", "fab", "fa", "fad", "fadd", "solbb", "solb", "sol", "sold", "soldd", "labb", "lab", "la", "lad", "ladd", "sibb", "sib", "si", "sid", "sidd"}, {"dobb", "dob", "do", "dod", "dodd", "rebb", "reb", "re", "red", "redd", "mibb", "mib", "mi", "mid", "midd", "fabb", "fab", "fa", "fad", "fadd", "solbb", "solb", "sol", "sold", "soldd", "labb", "lab", "la", "lad", "ladd", "sibb", "sib", "si", "sid", "sidd"}, {"ceses", "ces", "c", "cis", "cisis", "deses", "des", "d", "dis", "disis", "eses", "es", "e", "eis", "eisis", "feses", "fes", "f", "fis", "fisis", "geses", "ges", "g", "gis", "gisis", "asas", "as", "a", "ais", "aisis", "heses", "b", "h", "his", "hisis"}, {"cff", "cf", "c", "cs", "css", "dff", "df", "d", "ds", "dss", "eff", "ef", "e", "es", "ess", "fff", "ff", "f", "fs", "fss", "gff", "gf", "g", "gs", "gss", "aff", "af", "a", "as", "ass", "bff", "bf", "b", "bs", "bss"}, {"dobb", "dob", "do", "dos", "doss", "rebb", "reb", "re", "res", "ress", "mibb", "mib", "mi", "mis", "miss", "fabb", "fab", "fa", "fas", "fass", "solbb", "solb", "sol", "sols", "solss", "labb", "lab", "la", "las", "lass", "sibb", "sib", "si", "sis", "siss"}, {"dobb", "dob", "do", "dod", "dodd", "rebb", "reb", "re", "red", "redd", "mibb", "mib", "mi", "mid", "midd", "fabb", "fab", "fa", "fad", "fadd", "solbb", "solb", "sol", "sold", "soldd", "labb", "lab", "la", "lad", "ladd", "sibb", "sib", "si", "sid", "sidd"}, {"cessess", "cess", "c", "ciss", "cississ", "dessess", "dess", "d", "diss", "dississ", "essess", "ess", "e", "eiss", "eississ", "fessess", "fess", "f", "fiss", "fississ", "gessess", "gess", "g", "giss", "gississ", "aessess", "aess", "a", "aiss", "aississ", "bess", "b", "h", "hiss", "hississ"}, {"dobb", "dob", "do", "dos", "doss", "rebb", "reb", "re", "res", "ress", "mibb", "mib", "mi", "mis", "miss", "fabb", "fab", "fa", "fas", "fass", "solbb", "solb", "sol", "sols", "solss", "labb", "lab", "la", "las", "lass", "sibb", "sib", "si", "sis", "siss"}, {"ceses", "ces", "c", "cis", "cisis", "deses", "des", "d", "dis", "disis", "eses", "es", "e", "eis", "eisis", "feses", "fes", "f", "fis", "fisis", "geses", "ges", "g", "gis", "gisis", "asas", "as", "a", "ais", "aisis", "bes", "b", "h", "his", "hisis"}, {"cessess", "cess", "c", "ciss", "cississ", "dessess", "dess", "d", "diss", "dississ", "essess", "ess", "e", "eiss", "eississ", "fessess", "fess", "f", "fiss", "fississ", "gessess", "gess", "g", "giss", "gississ", "assess", "ass", "a", "aiss", "aississ", "hessess", "b", "h", "hiss", "hississ"}, {"dobb", "dob", "do", "dok", "dokk", "rebb", "reb", "re", "rek", "rekk", "mibb", "mib", "mi", "mik", "mikk", "fabb", "fab", "fa", "fak", "fakk", "solbb", "solb", "sol", "solk", "solkk", "labb", "lab", "la", "lak", "lakk", "sibb", "sib", "si", "sik", "sikk"}};

    public NamedNote(int l, int a, int o) {
        if (l < 0 || l > 6) {
            throw new IllegalArgumentException("letterName must be an integer from 0 to 6.");
        }
        this.letterName = l;
        this.alteration = a;
        this.octave = o;
        this.hasOctave = true;
    }

    public NamedNote(int l, int a) {
        if (l < 0 || l > 6) {
            throw new IllegalArgumentException("letterName must be an integer from 0 to 6.");
        }
        this.letterName = l;
        this.alteration = a;
        this.octave = 0;
        this.hasOctave = false;
    }

    public NamedNote(NamedNote old) {
        this.letterName = old.letterName;
        this.alteration = old.alteration;
        this.octave = old.octave;
        this.hasOctave = old.hasOctave;
    }

    public int getLetterName() {
        return this.letterName;
    }

    public int getAlteration() {
        return this.alteration;
    }

    public int getChromatic() {
        int result = 0;
        switch (this.letterName) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 2;
                break;
            }
            case 2: {
                result = 4;
                break;
            }
            case 3: {
                result = 5;
                break;
            }
            case 4: {
                result = 7;
                break;
            }
            case 5: {
                result = 9;
                break;
            }
            case 6: {
                result = 11;
            }
        }
        return result += this.alteration;
    }

    public void setOctave(int newOctave) {
        this.hasOctave = true;
        this.octave = newOctave;
    }

    public void alter(int additionalAlteration) {
        this.alteration += additionalAlteration;
    }

    public NamedNote addInterval(int majorInterval, int intervalAlteration) {
        NamedNote output = this.majorScaleDegree(majorInterval);
        output.alter(intervalAlteration);
        return output;
    }

    public NamedNote majorScaleDegree(int degree) {
        int outputAlteration = this.alteration;
        if (degree == 3) {
            if (this.letterName == 3) {
                --outputAlteration;
            }
        } else {
            int sharpsInKey = (this.letterName * 2 + 1) % 7 - 1;
            int sharpsOnDegree = 2 * degree % 7;
            if (sharpsInKey > 5 - sharpsOnDegree) {
                ++outputAlteration;
            }
        }
        return new NamedNote((this.letterName + degree) % 7, outputAlteration);
    }

    public void shiftLetterUp() {
        int extraAlteration = 2;
        switch (this.letterName) {
            case 2: 
            case 6: {
                extraAlteration = 1;
            }
        }
        this.letterName = (this.letterName + 1) % 7;
        this.alteration -= extraAlteration;
    }

    public void shiftLetterDown() {
        int extraAlteration = 2;
        switch (this.letterName) {
            case 0: 
            case 3: {
                extraAlteration = 1;
            }
        }
        this.letterName = (this.letterName + 6) % 7;
        this.alteration += extraAlteration;
    }

    public StringBuilder getLilyPondNote(int lang) {
        if (Math.abs(this.alteration) > 2) {
            throw new IllegalArgumentException("NamedNote.getLilyPondNote can only accept alterations from -2 to +2.");
        }
        StringBuilder output = new StringBuilder(nameStrings[lang][this.letterName * 5 + this.alteration + 2]);
        if (this.hasOctave) {
            char octaveChar = this.octave > 0 ? (char)'\'' : ',';
            int i = 0;
            while (i < Math.abs(this.octave)) {
                output.append(octaveChar);
                ++i;
            }
        }
        return output;
    }

    public StringBuilder getLilyPondNote(int lang, NamedNote ref) {
        if (!this.hasOctave || ref != null && !ref.hasOctave) {
            return this.getLilyPondNote(lang);
        }
        if (Math.abs(this.alteration) > 2) {
            throw new IllegalArgumentException("NamedNote.getLilyPondNote can only accept alterations from -2 to +2.");
        }
        StringBuilder output = new StringBuilder(nameStrings[lang][this.letterName * 5 + this.alteration + 2]);
        if (ref != null) {
            int relOctave = this.letterName - ref.letterName + 7 * (this.octave - ref.octave);
            relOctave = relOctave > 0 ? (relOctave += 3) : (relOctave -= 3);
            char octaveChar = (relOctave /= 7) > 0 ? (char)'\'' : ',';
            int i = 0;
            while (i < Math.abs(relOctave)) {
                output.append(octaveChar);
                ++i;
            }
        }
        return output;
    }
}

