/*
 * Decompiled with CFR 0.152.
 */
package midiinput;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import midiinput.MidiKeyStroke;
import midiinput.NamedNote;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessChords {
    private int language;
    private NamedNote tonic;
    private NamedNote actingTonic;
    private int mode;
    private int[] chromaticNames;
    private int[] chromaticAlterations;
    private NamedNote[] scale;
    LinkedList<MidiKeyStroke> notesPending = new LinkedList();
    private NamedNote reference = null;

    public ProcessChords(int initialLanguage, NamedNote initialTonic, int initialMode) {
        this.language = initialLanguage;
        this.tonic = initialTonic;
        this.mode = initialMode;
        this.createKey();
    }

    public void changeKey(int newLanguage, NamedNote newTonic, int newMode) {
        this.language = newLanguage;
        this.tonic = newTonic;
        this.mode = newMode;
        this.createKey();
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int newLanguage) {
        this.language = newLanguage;
    }

    public NamedNote getTonic() {
        return new NamedNote(this.tonic);
    }

    public int getMode() {
        return this.mode;
    }

    private void createKey() {
        this.chromaticNames = new int[12];
        this.chromaticNames[0] = 0;
        this.chromaticNames[1] = 0;
        this.chromaticNames[2] = 1;
        this.chromaticNames[3] = 2;
        this.chromaticNames[4] = 2;
        this.chromaticNames[5] = 3;
        this.chromaticNames[6] = 3;
        this.chromaticNames[7] = 4;
        this.chromaticNames[8] = 5;
        this.chromaticNames[9] = 5;
        this.chromaticNames[10] = 6;
        this.chromaticNames[11] = 6;
        this.chromaticAlterations = new int[12];
        this.chromaticAlterations[0] = 0;
        this.chromaticAlterations[1] = 1;
        this.chromaticAlterations[2] = 0;
        this.chromaticAlterations[3] = -1;
        this.chromaticAlterations[4] = 0;
        this.chromaticAlterations[5] = 0;
        this.chromaticAlterations[6] = 1;
        this.chromaticAlterations[7] = 0;
        this.chromaticAlterations[8] = -1;
        this.chromaticAlterations[9] = 0;
        this.chromaticAlterations[10] = -1;
        this.chromaticAlterations[11] = 0;
        if (this.mode == 1) {
            this.chromaticNames[1] = 1;
            this.chromaticAlterations[1] = -1;
        }
        int interval = 0;
        int alteration = 0;
        if (this.mode == 3) {
            interval = 6;
            alteration = -1;
        }
        if (this.mode == 4) {
            interval = 5;
            alteration = -1;
        }
        if (this.mode == 5) {
            interval = 4;
            alteration = 0;
        }
        if (this.mode == 6) {
            interval = 3;
            alteration = 0;
        }
        if (this.mode == 7) {
            interval = 2;
            alteration = -1;
        }
        if (this.mode == 8) {
            interval = 1;
            alteration = -1;
        }
        this.actingTonic = this.tonic.addInterval(interval, alteration);
        this.scale = new NamedNote[12];
        int i = 0;
        while (i < 12) {
            this.scale[i] = this.actingTonic.majorScaleDegree(this.chromaticNames[i]);
            this.scale[i].alter(this.chromaticAlterations[i]);
            ++i;
        }
    }

    private NamedNote convertMidi(int midiNote) {
        int chromaticPitch = (midiNote - this.actingTonic.getChromatic()) % 12;
        NamedNote result = this.scale[chromaticPitch];
        int octave = (midiNote - result.getAlteration()) / 12 - 4;
        result.setOctave(octave);
        return result;
    }

    public void processChord(List<MidiKeyStroke> midiStrokes) {
        StringBuilder output = new StringBuilder();
        Collections.sort(midiStrokes, new Comparator<MidiKeyStroke>(){

            @Override
            public int compare(MidiKeyStroke one, MidiKeyStroke two) {
                return one.getMidiPitch() - two.getMidiPitch();
            }
        });
        NamedNote localRef = this.reference;
        if (midiStrokes.size() > 1) {
            output.append("<");
        }
        int i = 0;
        for (MidiKeyStroke stroke : midiStrokes) {
            NamedNote note = this.convertMidi(stroke.getMidiPitch());
            output.append(note.getLilyPondNote(this.language, localRef).toString());
            if (++i < midiStrokes.size()) {
                output.append(" ");
            }
            if (i == 1) {
                this.reference = new NamedNote(note);
            }
            localRef = new NamedNote(note);
        }
        if (midiStrokes.size() > 1) {
            output.append(">");
        }
        this.outputNotes(output.toString());
    }

    private void outputNotes(String codeString) {
        char lastChar;
        Buffer buffer = jEdit.getActiveView().getBuffer();
        buffer.writeLock();
        int position = jEdit.getActiveView().getTextArea().getCaretPosition();
        if (position > 0 && (lastChar = buffer.getText(position - 1, 1).charAt(0)) != ' ' && lastChar != '<') {
            buffer.insert(position, " ");
            ++position;
        }
        buffer.insert(position, codeString);
        buffer.writeUnlock();
    }
}

