/*
 * Decompiled with CFR 0.152.
 */
package midiinput;

import java.util.LinkedList;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import midiinput.MidiKeyStroke;
import midiinput.ProcessChords;

public class ReceiveChords
implements Receiver {
    private ProcessChords processor = null;
    private LinkedList<MidiKeyStroke> notesPending = new LinkedList();

    public ReceiveChords(ProcessChords processor) {
        this.processor = processor;
    }

    public void send(MidiMessage message, long now) {
        int status;
        if (message instanceof ShortMessage && (status = message.getStatus()) >= 128 && status < 160) {
            byte[] data = message.getMessage();
            byte pitch = data[1];
            if (status < 144 || data[2] == 0) {
                int i = -1;
                int index = -1;
                for (MidiKeyStroke stroke : this.notesPending) {
                    ++i;
                    if (stroke.getMidiPitch() != pitch) continue;
                    index = i;
                }
                if (index > -1) {
                    long cutOffTime = Math.max(this.notesPending.get(index).getArrival(), (now + 2L * this.notesPending.getFirst().getArrival()) / 3L);
                    index = -1;
                    for (MidiKeyStroke stroke : this.notesPending) {
                        if (stroke.getArrival() > cutOffTime) continue;
                        ++index;
                    }
                    this.processor.processChord(this.notesPending.subList(0, index + 1));
                    this.notesPending.subList(0, index + 1).clear();
                }
            } else {
                if (this.notesPending.size() > 0 && now - this.notesPending.getLast().getArrival() > 500000L) {
                    this.processor.processChord(this.notesPending);
                    this.notesPending.clear();
                }
                this.notesPending.add(new MidiKeyStroke(pitch, now));
            }
        }
    }

    public void close() {
    }
}

