/*
 * Decompiled with CFR 0.152.
 */
package midiinput;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import midiinput.MidiInputPlugin;
import midiinput.NamedNote;
import midiinput.ProcessChords;
import org.gjt.sp.jedit.jEdit;

public class SetTonality {
    private ProcessChords processor = null;
    private NamedNote tonic = null;
    private int language;
    private JDialog tonalityDialog = null;
    private JPanel jContentPane = null;
    private JLabel languageLabel = null;
    private JComboBox languageComboBox = null;
    private JLabel tonicLabel = null;
    private JLabel tonicDisplayLabel = null;
    private JLabel modeLabel = null;
    private JComboBox modeComboBox = null;
    private JButton jButtonOK = null;
    private JButton jButtonDown = null;
    private JButton jButtonUp = null;
    private JButton jButtonFlat = null;
    private JButton jButtonSharp = null;

    public JDialog getTonalityDialog(ProcessChords getProcessor) {
        this.processor = getProcessor;
        this.tonic = this.processor.getTonic();
        this.language = this.processor.getLanguage();
        if (this.tonalityDialog == null) {
            this.tonalityDialog = new JDialog();
            this.tonalityDialog.setSize(new Dimension(324, 212));
            this.tonalityDialog.setLocationRelativeTo((Component)jEdit.getActiveView());
            this.tonalityDialog.setTitle("Set MIDI tonality");
            this.tonalityDialog.setContentPane(this.getJContentPane());
            this.tonalityDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        }
        return this.tonalityDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 4;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.gridy = 2;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 3;
            gridBagConstraints9.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 3;
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 3;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridy = 5;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 3;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridy = 4;
            this.modeLabel = new JLabel();
            this.modeLabel.setText("Mode:");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            this.tonicDisplayLabel = new JLabel();
            this.updateTonicLabel();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridy = 2;
            this.tonicLabel = new JLabel();
            this.tonicLabel.setText("Tonic:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 3;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridy = 0;
            this.languageLabel = new JLabel();
            this.languageLabel.setText("Language:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.languageLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.getLanguageComboBox(), gridBagConstraints1);
            this.jContentPane.add((Component)this.tonicLabel, gridBagConstraints2);
            this.jContentPane.add((Component)this.tonicDisplayLabel, gridBagConstraints3);
            this.jContentPane.add((Component)this.modeLabel, gridBagConstraints4);
            this.jContentPane.add((Component)this.getModeComboBox(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getJButtonOK(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getJButtonDown(), gridBagConstraints8);
            this.jContentPane.add((Component)this.getJButtonUp(), gridBagConstraints9);
            this.jContentPane.add((Component)this.getJButtonFlat(), gridBagConstraints10);
            this.jContentPane.add((Component)this.getJButtonSharp(), gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private void updateTonicLabel() {
        this.tonicDisplayLabel.setText(this.tonic.getLilyPondNote(this.language).toString());
    }

    private JComboBox getLanguageComboBox() {
        if (this.languageComboBox == null) {
            this.languageComboBox = new JComboBox<String>(MidiInputPlugin.languages);
        }
        this.languageComboBox.setSelectedIndex(this.processor.getLanguage());
        this.languageComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SetTonality.this.language = SetTonality.this.languageComboBox.getSelectedIndex();
                SetTonality.this.updateTonicLabel();
            }
        });
        return this.languageComboBox;
    }

    private JComboBox getModeComboBox() {
        String[] modes = new String[]{"major", "minor", "ionian", "dorian", "phrygian", "lydian", "mixolydian", "aeolian", "locrian"};
        if (this.modeComboBox == null) {
            this.modeComboBox = new JComboBox<String>(modes);
        }
        this.modeComboBox.setSelectedIndex(this.processor.getMode());
        return this.modeComboBox;
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new JButton();
            this.jButtonOK.setText("OK");
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SetTonality.this.processor.changeKey(SetTonality.this.language, SetTonality.this.tonic, SetTonality.this.modeComboBox.getSelectedIndex());
                    SetTonality.this.tonalityDialog.setVisible(false);
                }
            });
        }
        return this.jButtonOK;
    }

    private JButton getJButtonDown() {
        if (this.jButtonDown == null) {
            this.jButtonDown = new JButton();
            this.jButtonDown.setText("\u2193");
            this.jButtonDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SetTonality.this.tonic = new NamedNote((SetTonality.this.tonic.getLetterName() + 6) % 7, SetTonality.this.tonic.getAlteration());
                    SetTonality.this.updateTonicLabel();
                }
            });
        }
        return this.jButtonDown;
    }

    private JButton getJButtonUp() {
        if (this.jButtonUp == null) {
            this.jButtonUp = new JButton();
            this.jButtonUp.setText("\u2191");
            this.jButtonUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SetTonality.this.tonic = new NamedNote((SetTonality.this.tonic.getLetterName() + 1) % 7, SetTonality.this.tonic.getAlteration());
                    SetTonality.this.updateTonicLabel();
                }
            });
        }
        return this.jButtonUp;
    }

    private JButton getJButtonFlat() {
        if (this.jButtonFlat == null) {
            this.jButtonFlat = new JButton();
            this.jButtonFlat.setText("\u266d");
            this.jButtonFlat.setPreferredSize(new Dimension(47, 25));
            this.jButtonFlat.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SetTonality.this.tonic.getAlteration() > -1) {
                        SetTonality.this.tonic.alter(-1);
                        SetTonality.this.updateTonicLabel();
                    }
                }
            });
        }
        return this.jButtonFlat;
    }

    private JButton getJButtonSharp() {
        if (this.jButtonSharp == null) {
            this.jButtonSharp = new JButton();
            this.jButtonSharp.setText("\u266f");
            this.jButtonSharp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SetTonality.this.tonic.getAlteration() < 1) {
                        SetTonality.this.tonic.alter(1);
                        SetTonality.this.updateTonicLabel();
                    }
                }
            });
        }
        return this.jButtonSharp;
    }
}

