#!/bin/sh
#
# Makefile installation helper

if [ "$1" == "" ]; then ACTION="-i";else ACTION=$1;fi
if [ "$2" == "" ]; then CONFDIR="/etc";else CONFDIR=$2;fi
if [ "$3" == "" ]; then BINDIR="/usr/bin";else BINDIR=$3;fi
if [ "$4" == "" ]; then SHAREDIR="/usr/share/snarelinux";else SHAREDIR=$4;fi

if [ "$ACTION" == "-i" ]; then
	# Install
	$CONFDIR/init.d/auditd stop
	if [ ! -f $CONFDIR/auditd.conf-snarebackup ]; then
        	cp $CONFDIR/auditd.conf $CONFDIR/auditd.conf-snarebackup
	fi
	grep "^dispatcher" $CONFDIR/auditd.conf
        if [ $? -eq 0 ]; then
                cat $CONFDIR/auditd.conf-snarebackup | sed 's/^dispatcher.*//' | egrep -v "^$" > $CONFDIR/auditd.conf
                echo "dispatcher = $BINDIR/SnareDispatcher" >> $CONFDIR/auditd.conf;
        else
                echo "dispatcher = $BINDIR/SnareDispatcher" >> $CONFDIR/auditd.conf;
        fi
	$CONFDIR/init.d/auditd start
	exit
fi

if [ $1 == "-u" ]; then
	# Uninstall
	$CONFDIR/init.d/auditd stop
	if [ -f $CONFDIR/auditd.conf-snarebackup ]; then
                cat $CONFDIR/auditd.conf-snarebackup | egrep -v "^dispatcher = .*SnareDispatcher.*" > $CONFDIR/auditd.conf
		rm -f $CONFDIR/auditd.conf-snarebackup
        else
                cp $CONFDIR/auditd.conf $CONFDIR/auditd.conf-snarebackup
                cat $CONFDIR/auditd.conf-snarebackup | egrep -v "^dispatcher" > $CONFDIR/auditd.conf
                rm -f $CONFDIR/auditd.conf-snarebackup
        fi
	$CONFDIR/init.d/auditd start
	exit
fi
