#include <stdio.h>
#include <pthread.h>
#include <signal.h>
#include <stdlib.h>
#include <sched.h>

extern void large_exec(void);
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

#define MAX_THREADS	16

void *runs(void *arg)
{
	cpu_set_t mask;
	long id = *(long*)arg;
	__CPU_ZERO(&mask);
	__CPU_SET(id, &mask);
	sched_setaffinity(0, sizeof(cpu_set_t), &mask);
	/* wait for start */
	pthread_mutex_lock(&mutex);
	pthread_mutex_unlock(&mutex);
	large_exec();
}

void sigill_handler(int sig)
{
	fprintf(stderr, "SIGILL received !!");
	exit(1);
}

int main(int argc, char *argv[])
{
	int i;
	pthread_t thr[MAX_THREADS];
	long id[MAX_THREADS];
	char *c;
	int cpus = atoi(argv[1]);

	signal(SIGILL, sigill_handler);
	pthread_mutex_lock(&mutex);
	
	for (i = 0; i < cpus; i++) {
		id[i] = i;
		pthread_create(&thr[i], NULL, runs, &id[i]);
	}
	sleep(1);
	pthread_mutex_unlock(&mutex);
	for (i = 0; i < cpus; i++)
		pthread_join(thr[i], NULL);

	return 0;
}
