/*
 * module.c, Copyright (c) 2004 Aurema, Pty Ltd.  All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/init.h>

extern int __init pagg_init(void);
extern void __exit pagg_deinit(void);
extern int __init exec_init(void);
extern void __exit exec_deinit(void);


/* 
 * This function is called when a module is inserted into a kernel. This
 * function allocates any necessary structures and sets initial values for
 * module data.
 */
static int __init init(void) 
{
	int result;

	if ((result = exec_init()) < 0)
		return result;
	if ((result = pagg_init()) < 0)
		goto bailout;

	printk(KERN_INFO "Exec Notifier loaded\n");
	return 0;

 bailout:
	exec_deinit();
	return result;
}

/*
 * This function is called to cleanup after a module when it is removed.
 * All memory allocated for this module will be freed.
 */
static void __exit deinit(void)
{
	pagg_deinit();
	exec_deinit();

	printk(KERN_INFO "Exec Notifier unloaded\n");	
}

module_init(init);
module_exit(deinit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Aurema Pty Ltd");
MODULE_DESCRIPTION("Exec Notifier Module");
MODULE_VERSION("1.0");
