/* gcc -g -Wall -o click click.c -L /usr/X11R6/lib/ -lX11 -lXtst */

#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#include <stdio.h>
#include <stdlib.h>

int main( int argc, char *argv[] ) {
    Display *dpy = XOpenDisplay( NULL );
	int butnum;
	int click;
	butnum=1;
	click=0;
	if (argc > 2) {
		butnum = atoi(argv[1]);
		click = atoi(argv[2]);
	} else if (argc > 1) {
		butnum = atoi(argv[1]);
	}
	if ((click == 0) || (click == 1)) {
		printf ("Faking button %d down\n", butnum);
	    XTestFakeButtonEvent( dpy, butnum, True, CurrentTime );
	}
	if ((click == 0) || (click == 2)) {
		printf ("Faking button %d up\n", butnum);
	    XTestFakeButtonEvent( dpy, butnum, False, CurrentTime );
	}
	
    XCloseDisplay( dpy );
    return 0;
}
