#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kthread.h>
#include <linux/delay.h>

static int just_spin(void *data)
{
        while(!kthread_should_stop()) {
                msleep(1);
        }

        return 0;
}


static struct task_struct *nodeadlock_thread;

static int __init nodeadlock_init(void)
{
        printk(KERN_INFO "Hello from the kernel!\n");
        nodeadlock_thread = kthread_create(just_spin,0,"nodeadlock_spin");
	if (IS_ERR(nodeadlock_thread))
		return -1;
	wake_up_process(nodeadlock_thread);
        return 0;
}

static void __exit nodeadlock_exit(void)
{
	kthread_stop(nodeadlock_thread);
}

module_init(nodeadlock_init);
module_exit(nodeadlock_exit);

MODULE_AUTHOR("My name here");
MODULE_DESCRIPTION("Simple driver");
MODULE_LICENSE("GPL");

