//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//  Copyright(c)  2005  Analogic Corporation
//
//  This program may be distributed under the GNU Public License
//  version 2, as published by the Free Software Foundation, Inc.,
//  59 Temple Place, Suite 330 Boston, MA, 02111.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

#ifndef _CONFIG_H_
#define _CONFIG_H_
#include "kver.h"


#define ARRAYSIZE(a)    (sizeof(a) / sizeof(a[0]))
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//  Below are macros to handle different kernel versions.
//
#ifndef IRQ_HANDLED
#define IRQ_HANDLED
typedef void irqreturn_t;
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//  Variable KVER is generated by `chkver` and written to file kver.h.
//  Kernel version of 2.6.9 becomes 269., version 2.6.10 becomes 2610,
//  etc. Something with a '-' ends with the dash. In other words,
//  2.6.9-22  is 269.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#if (KVER==2610||KVER==2611||KVER==26119||KVER==2612||KVER==26125||KVER==2613)
#define NEED_EXTRA_MODULE_JUNK
#define ROUTE_IRQ(a) (void)pci_enable_device(a);(void)pci_disable_device(a)
#define REMAP(a,b,c,d,e) remap_pfn_range((a), (b), (c) >> PAGE_SHIFT, (d), (e))
#define __io_virt(p) ((void *)(p))
#define SET_PRIORITY(p) set_user_nice(current, (p))
#define DAEMONIZE             \
    daemonize("%s", devname); \
    allow_signal(SIGTERM)
#define PCI_FIND_DEVICE(a,b,c) pci_get_device((a),(b),(c))
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#elif (KVER==269 || KVER==268)
#define NEED_EXTRA_MODULE_JUNK
#define ROUTE_IRQ(a)
#define REMAP(a,b,c,d,e) remap_page_range((a), (b), (c), (d), (e))
#define __io_virt(p) ((void *)(p))
#define SET_PRIORITY(p) set_user_nice(current, (p))
#define DAEMONIZE             \
    daemonize("%s", devname); \
    allow_signal(SIGTERM)
#define PCI_FIND_DEVICE(a,b,c) pci_get_device((a),(b),(c))
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#elif (KVER==267 || KVER==266 || KVER==265)
#define NEED_EXTRA_MODULE_JUNK
#define ROUTE_IRQ(a)
#define REMAP(a,b,c,d,e) remap_page_range((a), (b), (c), (d), (e))
#define __io_virt(p) ((void *)(p))
#define SET_PRIORITY(p) set_user_nice(current, (p))
#define DAEMONIZE             \
    daemonize("%s", devname); \
    allow_signal(SIGTERM)
#define PCI_FIND_DEVICE(a,b,c) pci_get_device((a),(b),(c))
#define kernel_locked() 0
#define lock_kernel()
#define unlock_kernel()
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#else
#define ROUTE_IRQ(a)
#define kernel_locked() 0
#define lock_kernel()
#define unlock_kernel()
#define pci_set_mwi(x) TRUE
#define REMAP(a,b,c,d,e) remap_page_range((b), (c), (d), (e))
#define SET_PRIORITY(p) \
   task_lock(current);  \
   current->nice = (p); \
   task_unlock(current)
#define DAEMONIZE                          \
    exit_files(current);                   \
    daemonize();                           \
    spin_lock_irq(&current->sigmask_lock); \
    sigemptyset(&current->blocked);        \
    sigdelset(&current->blocked, SIGTERM); \
    recalc_sigpending(current);            \
    spin_unlock_irq(&current->sigmask_lock)
#define PCI_FIND_DEVICE(a,b,c) pci_find_device((a),(b),(c))
#endif
#endif
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

