//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//  Copyright(c)  2004, 2005,  Analogic Corporation
//
//
//  This program may be distributed under the GNU Public License
//  version 2, as published by the Free Software Foundation, Inc.,
//  59 Temple Place, Suite 330 Boston, MA, 02111.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//   File: module.c     Created 13-JAN-2005     Richard B. Johnson
//
//   This is the junk that needs to be linked with module code so
//   it can be loaded by the new in-kernel module loader. It has no
//   purpose except to make the kernel loader happy.
//
//   This is a totally artificial mechanism used to prevent one
//   from making a module that can work over several different
//   kernel versions. But, since I am able to read 'C' code, I
//   was able to decipher the obfuscation and make this work-
//   around.
//
//
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/compiler.h>
#include "config.h"
#define DEREF(x) (#x)
#define MKSTR(x) DEREF(x)
#ifdef NEED_EXTRA_MODULE_JUNK
#include <linux/vermagic.h>
MODULE_INFO(vermagic, VERMAGIC_STRING);
struct module __attribute__((section(".gnu.linkonce.this_module")))
 __this_module = {
 .name = MKSTR(MODNAME),
 .init = init_module,
 .exit = cleanup_module,
};
#ifdef GLOBAL_MEM
static const char __attribute_used__ __attribute__((section(".modinfo")))
__module_depends[]="depends=alog_mem";
#else
static const char __attribute_used__ __attribute__((section(".modinfo")))
__module_depends[]="depends=";
#endif
#else
const char __peek[]=MKSTR(MODNAME);
#endif
