/*
 *   Copyright(c)   2004   Analogic Corporation
 *
 *   This program may be distributed under the GNU Public License
 *   version 2, as published by the Free Software Foundation, Inc.,
 *   59 Temple Place, Suite 330 Boston, MA, 02111.
 *
 *   File chkhdrs.c             Created 12-MAY-2004     Richard B. Johnson
 *
 *   This just checks that the correct kernel headers are available
 *   so the kernel may be properly compiled.
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>

int main(int args, char *argv[])
{
    char buf[0x100];
    struct utsname uts;
    (void)uname(&uts);
    sprintf(buf, "/usr/src/linux-%s/include/linux", uts.release);
    if(access(buf, F_OK))
    {
        fprintf(stderr, "No current kernel header files, %s,\n", buf);
        fprintf(stderr, "for kernel version %s.\n", uts.release);
        fprintf(stderr, "Please create a sym-link of the following form:\n");
        fprintf(stderr, "ln -s (where the kernel sources are) "\
                        "/usr/src/linux-%s\n", uts.release);
        (void)unlink(argv[0]);  // Yes, delete the executable!
        exit(EXIT_FAILURE);
    }
    return 0;
}

