/*
 *   Copyright(c)   2004   Analogic Corporation
 *
 *   This program may be distributed under the GNU Public License
 *   version 2, as published by the Free Software Foundation, Inc.,
 *   59 Temple Place, Suite 330 Boston, MA, 02111.
 *
 *   File chkver.c              Created 04-JAN-2005     Richard B. Johnson
 *
 *   Trivial program used to obtain the numerical value of
 *   the kernel version at compile-time.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/utsname.h>

static const char fname[]="kver.h";

int main(int args, char *argv[])
{
    struct utsname inf;
    char buf[0x10];
    char *ip, *op;
    FILE *file;
    int i;
    (void)unlink(fname);                // Fix broken kernel
    if((file = fopen(fname, "w")))
    {
        (void)uname(&inf);              // Get `uname -r`
        ip = inf.release;               // General case
        if(args > 1)                    // May be additional
            ip = argv[1];               // Use this instead
        op = buf;
        while(*ip)
        {
            if(*ip == (char) '-')
                break;
            if(*ip != (char)'.') 
                *op++ = *ip++;
            else
                ip++;
        }
        *op = (char) 0x00;
        i = atoi(buf);
        fprintf(file, "//\n// Created by %s\n", argv[0]);
        fprintf(file, "// All edits will be lost\n//\n");
        fprintf(file, "#ifndef _KVER_H_\n");
        fprintf(file, "#define _KVER_H_\n");
        fprintf(file, "#define KVER %u\n", i);
        fprintf(file, "#endif\n");
        fclose(file);
    }
    else
    {
        fprintf(stderr, "Can't create file, %s\n", fname);
        exit(EXIT_FAILURE);
    } 
    return 0; 
}
