#!/usr/bin/perl -w

use English;

$runs = 10;
$tiny_compress = 0;
$tiny_decompress = 0;
$tiny_combined = 0;
$tiny_comp = 0;
$tiny_decomp = 0;
$full_compress = 0;
$full_decompress = 0;
$full_combined = 0;
$full_comp = 0;
$full_decomp = 0;

for $i (1..$runs) {
    $run = `./tinytest`;
    @lines = split( /\n/, $run );
    $lines[0] =~ /\[.*::.* \(\d+\)\] run took (\d*) microseconds.*/;
    $tiny_compress += $1;
    $lines[1] =~ /\[.*::.* \(\d+\)\] run took (\d*) microseconds.*/;
    $tiny_decompress += $1;
}

for $i (1..$runs) {
    $run = `./fulltest`;
    @lines = split( /\n/, $run );
    $lines[0] =~ /\[.*::.* \(\d+\)\] run took (\d*) microseconds.*/;
    $full_compress += $1;
    $lines[1] =~ /\[.*::.* \(\d+\)\] run took (\d*) microseconds.*/;
    $full_decompress += $1;
}

$tiny_combined = ( $tiny_compress + $tiny_decompress ) / $runs;
$tiny_comp = $tiny_compress / $runs;
$tiny_decomp = $tiny_decompress / $runs;

$full_combined = ( $full_compress + $full_decompress ) / $runs;
$full_comp = $full_compress / $runs;
$full_decomp = $full_decompress / $runs;

print "$runs run averages:\n";
print "\'Tiny LZO\':\n";
print "\tCombined: $tiny_combined usec\n";
print "\tCompression: $tiny_comp usec\n";
print "\tDecompression: $tiny_decomp usec\n";
print "\'liblzo2\':\n";
print "\tCombined: $full_combined usec\n";
print "\tCompression: $full_comp usec\n";
print "\tDecompression: $full_decomp usec\n";
