/* lzo1x.h -- public interface of the LZO1X compression algorithm

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996-2005 Markus Franz Xaver Johannes Oberhumer
   All Rights Reserved.

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License,
   version 2, as published by the Free Software Foundation.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the LZO library; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

   Markus F.X.J. Oberhumer
   <markus@oberhumer.com>
   http://www.oberhumer.com/opensource/lzo/


   This file is modified version of lzo1x.h found in original LZO 2.02
   code. Some additional changes have also been made to make it work
   in kernel space.

   Nitin Gupta
   <nitingupta910@gmail.com>
 */

#ifndef __LZO1X_H
#define __LZO1X_H

/* LZO return codes */
#define LZO_E_OK                       0
#define LZO_E_ERROR                    (-1)
#define LZO_E_OUT_OF_MEMORY            (-2)    /* [not used right now] */
#define LZO_E_NOT_COMPRESSIBLE         (-3)    /* [not used right now] */
#define LZO_E_INPUT_OVERRUN            (-4)
#define LZO_E_OUTPUT_OVERRUN           (-5)
#define LZO_E_LOOKBEHIND_OVERRUN       (-6)
#define LZO_E_EOF_NOT_FOUND            (-7)
#define LZO_E_INPUT_NOT_CONSUMED       (-8)
#define LZO_E_NOT_YET_IMPLEMENTED      (-9)    /* [not used right now] */

/* Size of temp buffer (workmem) required by lzo1x_compress */
#define LZO1X_WORKMEM_SIZE     ((size_t) (16384L * sizeof(unsigned char *)))

/*
 * This requires 'workmem' of size LZO1X_WORKMEM_SIZE
 */
int lzo1x_compress(const unsigned char *src, size_t src_len,
               unsigned char *dst, size_t *dst_len,
               void *workmem);

/*
 * This decompressor will catch all compressed data violations and
 * return an error code in this case.
 */
int lzo1x_decompress(const unsigned char *src, size_t src_len,
               unsigned char *dst, size_t *dst_len);
#endif
