/* lzo1x_int.h -- to be used internally by LZO de/compression algorithms

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996-2005 Markus Franz Xaver Johannes Oberhumer
   All Rights Reserved.

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License,
   version 2, as published by the Free Software Foundation.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the LZO library; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

   Markus F.X.J. Oberhumer
   <markus@oberhumer.com>
   http://www.oberhumer.com/opensource/lzo/


   This file was derived from several header files found in original
   LZO 2.02 code. Some additional changes have also been made to make
   it work in kernel space.

   Nitin Gupta
   <nitingupta910@gmail.com>
 */

#ifndef __LZO1X_INT_H
#define __LZO1X_INT_H

#define D_BITS         14
#define D_SIZE         (1u << D_BITS)
#define D_MASK         (D_SIZE - 1)
#define D_HIGH         ((D_MASK >> 1) + 1)

#define DX2(p,s1,s2) \
       (((((size_t)((p)[2]) << (s2)) ^ (p)[1]) << (s1)) ^ (p)[0])
#define DX3(p,s1,s2,s3) \
       ((DX2((p) + 1, s2, s3) << (s1)) ^ (p)[0])
#define DINDEX1(d,p) \
       d = ((size_t)(0x21 * DX3(p, 5, 5, 6)) >> 5) & D_MASK
#define DINDEX2(d,p) \
       d = (d & (D_MASK & 0x7ff)) ^ (D_HIGH | 0x1f)

#define COPY4(dst,src) *(uint32_t *)(dst) = *(uint32_t *)(src)

/* LZO1X Specific constants */
#define M1_MAX_OFFSET  0x0400
#define M2_MAX_OFFSET  0x0800
#define M3_MAX_OFFSET  0x4000
#define M4_MAX_OFFSET  0xbfff

#define M1_MIN_LEN     2
#define M1_MAX_LEN     2
#define M2_MIN_LEN     3
#define M2_MAX_LEN     8
#define M3_MIN_LEN     3
#define M3_MAX_LEN     33
#define M4_MIN_LEN     3
#define M4_MAX_LEN     9

#define M1_MARKER      0
#define M2_MARKER      64
#define M3_MARKER      32
#define M4_MARKER      16

/* Bounds checking */
#define TEST_IP        (ip < ip_end)
#define NEED_IP(x) \
       if ((size_t)(ip_end - ip) < (size_t)(x)) goto input_overrun
#define NEED_OP(x) \
       if ((size_t)(op_end - op) < (size_t)(x)) goto output_overrun
#define TEST_LB(m_pos) \
       if (m_pos < out || m_pos >= op) goto lookbehind_overrun

#endif
