# prepare-uapi.mk
# vi:ts=4
# currently resides in tools/uapi/
#
# steps for usage:
# 1. run (from top of kernel tree): make ARCH=arch O=dir headers_check
#	so that the UAPI headers will be installed.
# 2. run 'make -f prepare-uapi.mk', which prepares many .c files (one per
#	UAPI header), and updates the 'buildall-uapi.mk' file.
# 3. run 'make -f buildall-uapi.mk' to build all of the targets

srctree=../..
CC=gcc

all: prepare-uapi.mk hdr-prepare-src.pl
	cp -a template/buildall-uapi.mk.empty buildall-uapi.mk
	rm -f buildall-uapi.allfiles
	touch buildall-uapi.allfiles
	cp -a template/uapi-base.c .
#	Test only; drop /misc below after testing.
#	find $(srctree)/xx64/usr/include/misc -type f -name \*\.h |
	find $(srctree)/xx64/usr/include -type f -name \*\.h | \
		./hdr-prepare-src.pl

clean:
	rm -f buildall-uapi.mk buildall-uapi.allfiles
	rm -f *.o *.c
