#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/kprobes.h>

static void set_bsp(void *obj)
{
	u32 l, h;

	rdmsr(MSR_IA32_APICBASE, l, h);
	l |= MSR_IA32_APICBASE_BSP;
	wrmsr(MSR_IA32_APICBASE, l, h);
}

enum {
	DEFAULT_TARGET_CPU = 0
};

static int target_cpu = DEFAULT_TARGET_CPU;
module_param(target_cpu, int, 0644);
MODULE_PARM_DESC(target_cpu, " Target cpu to be set BSP flag, default is 0");

static int __init gci_init(void)
{
	smp_call_function_single(target_cpu, set_bsp, NULL, true);

	return 0;
}

static void __exit gci_exit(void)
{
}

module_init(gci_init)
module_exit(gci_exit)
MODULE_LICENSE("GPL");
