#include <linux/config.h>
#include <linux/module.h>
#include <linux/mm.h>
#include <linux/kernel.h>
#include <linux/unistd.h>
#include <linux/vmalloc.h>
#include <asm/uaccess.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/kbd_kern.h>

#if CONFIG_MODVERSIONS==1
#define MODVERSIONS
#include <linux/modversions.h>
#endif        

#define OUR_SYSRQ_HOOK         31  // just unused syscall stty
#define ANOTHER_UNUSED_SYSCALL 17  // unused syscall break

EXPORT_NO_SYMBOLS;


extern int sys_call_table[];
extern int sysrq_enabled;

extern void handle_sysrq(int key, struct pt_regs *pt_regs,
               		  struct kbd_struct *kbd, struct tty_struct *tty);


asmlinkage int sys_handle_sysrq( int key)
{
   int save_sysrq_enabled;
   
   if ( !capable( CAP_SYS_BOOT) || !capable( CAP_SYS_ADMIN))
     return -EPERM;

#ifdef DEBUG
  printk(KERN_DEBUG "\nSysrq system call invoked : %c\n", key);
#endif

  switch( key)
  {
    case 'b':
    case 'o':
    case 's':
    case 'u':
    case 't':
    case 'm':
              save_sysrq_enabled = sysrq_enabled;
	      sysrq_enabled = 1;
	      handle_sysrq( key, NULL, NULL, NULL);
	      sysrq_enabled = save_sysrq_enabled;
	      break;

   default:
              return -EINVAL;
  };	      	      
  

  return 0;
};


int init_module(void)
{
  sys_call_table[ OUR_SYSRQ_HOOK] = (int) sys_handle_sysrq;
  printk(KERN_INFO "\nSysrq handling module loaded\n");
  return 0;
};


void cleanup_module(void)
{ 
  // restore back to undefined syscall
  sys_call_table[ OUR_SYSRQ_HOOK] = (int) sys_call_table[ ANOTHER_UNUSED_SYSCALL];
  printk(KERN_INFO "\nSysrq handling module unloaded\n");
};

