// jack_test.cpp
//

#include <jack/jack.h>
#include <iostream>
#include <sstream>
#include <unistd.h>

jack_client_t *client;
jack_port_t **iports;
jack_port_t **oports;

unsigned int seconds_to_run = 60;
unsigned int num_of_ports   = 4;

int process(jack_nframes_t frames, void *arg) 
{
	// std::cout << "process callback" << std::endl;
	jack_default_audio_sample_t *ibuf;
	jack_default_audio_sample_t *obuf;
	for (int i = 0; i < num_of_ports; i++) {
		obuf = (jack_default_audio_sample_t*) jack_port_get_buffer(oports[i], frames);
		for (int j = 0; j < num_of_ports; j++) {
			ibuf = (jack_default_audio_sample_t*) jack_port_get_buffer(iports[j], frames);
			for (jack_nframes_t frame = 0; frame < frames; frame++) {
				if (j == 0)
					obuf[frame] = 0.0; 
				if (ibuf[frame] < -1E-6 || ibuf[frame] > +1E-6)
					obuf[frame] += ibuf[frame] / (float) num_of_ports;
			}
		}
	}
	return 1;
}

int main(int argc, char *argv[]) 
{
	// seconds_to_run: default = 60 seconds
	if (argc > 1) {
		std::stringstream sec_stream;
		sec_stream << argv[1];
		sec_stream >> seconds_to_run;
	}
	std::cout << "seconds to run: " << seconds_to_run << std::endl;

	// num_of_ports: default = 4 ports
	if (argc > 2) {
		std::stringstream num_stream;
		num_stream << argv[2];
		num_stream >> num_of_ports;
	}
	std::cout << "num.of ports: " << num_of_ports << std::endl;

	std::stringstream pid_stream;
	pid_stream << "jack_test3-" << getpid();

	std::cout << "client_new: " << pid_stream.str() << std::endl;
	client = jack_client_new(pid_stream.str().c_str());
	if (!client) {
		std::cerr << "jackd not running?" << std::endl;
		return 1;
	}

	iports = new jack_port_t * [num_of_ports];  
	oports = new jack_port_t * [num_of_ports];

	std::cout << "port_register" << std::endl;
	for (int i = 0; i < num_of_ports; i++) {
		std::stringstream iport_name;
		iport_name << "in_" << i;
		iports[i] = jack_port_register(client,  iport_name.str().c_str(), JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput|JackPortIsTerminal, 0);
		std::stringstream oport_name;
		oport_name << "out_" << i;
		oports[i] = jack_port_register(client, oport_name.str().c_str(), JACK_DEFAULT_AUDIO_TYPE, JackPortIsTerminal|JackPortIsOutput, 0);
	}
	std::cout << "set_process_callback" << std::endl;
	jack_set_process_callback(client, process, 0);

	std::cout << "activate" << std::endl;
	jack_activate(client);

	std::cout << "running" << std::endl;

	// while(1) {sleep(1);};
	sleep(seconds_to_run);

	jack_deactivate(client);
	jack_client_close(client);
	
	delete [] iports;
	delete [] oports;
	
	return 0;
}

// end of jack_test.cpp
