#!/bin/awk
#

BEGIN {
    SECS        = 0;
    PORTS       = 0;
    CLIENTS     = 0;
    PERIOD      = 0;
    C           = 0;
    N           = 0;
    V           = 0;
    ToutSum     = 0;
    XrunSum     = 0;
    DelaySum    = 0;
    Delay2Sum   = 0;
    MaxDelaySum = 0;
    MaxCycleSum = 0;
    DspSum      = 0;
    SysSum      = 0;
    UsrSum      = 0;
    NiceSum     = 0;
    IOWaitSum   = 0;
    IrqSum      = 0;
    SoftIrqSum  = 0;
    IntSum      = 0;
    CtxSum      = 0;
}


/^Seconds to run        \(SECS\) =/ { SECS    += $6; C++; }
/^Number of clients  \(CLIENTS\) =/ { CLIENTS += $6; }
/^Ports per client     \(PORTS\) =/ { PORTS   += $6; }
/^Frames per buffer   \(PERIOD\) =/ { PERIOD  += $6; }

/^Timeout Count . . . . . . . . :/ { 
	x = int($12); 
	ToutSum += x; 
	V = (x < 1); 
	if (V) N++; 
}

/^XRUN Count  . . . . . . . . . :/    { if (V) XrunSum     += $13; }
/^Delay Count \(>spare time\) . . :/  { if (V) DelaySum    += $8;  }
/^Delay Count \(>1000 usecs\) . . :/  { if (V) Delay2Sum   += $8;  }
/^Delay Maximum . . . . . . . . :/    { if (V) MaxDelaySum += $12; }
/^Cycle Maximum . . . . . . . . :/    { if (V) MaxCycleSum += $12; }
/^Average DSP Load. . . . . . . :/    { if (V) DspSum      += $11; }
/^Average CPU System Load . . . :/    { if (V) SysSum      += $9;  }
/^Average CPU User Load . . . . :/    { if (V) UsrSum      += $10; }
/^Average CPU Nice Load . . . . :/    { if (V) NiceSum     += $10; }
/^Average CPU I\/O Wait Load . . :/   { if (V) IOWaitSum   += $9;  }
/^Average CPU IRQ Load  . . . . :/    { if (V) IrqSum      += $10; }
/^Average CPU Soft-IRQ Load . . :/    { if (V) SoftIrqSum  += $8;  }
/^Average Interrupt Rate  . . . :/    { if (V) IntSum      += $8;  }
/^Average Context-Switch Rate . :/    { if (V) CtxSum      += $6;  }


END {
    H = 3600 / (N * SECS);
    printf("*********** CONSOLIDATED RESULTS ************\n");
    printf("Total seconds ran . . . . . . : %5d\n", SECS);
    printf("Number of clients . . . . . . : %5d\n", CLIENTS / C);
    printf("Ports per client  . . . . . . : %5d\n", PORTS / C);
    printf("Frames per buffer . . . . . . : %5d\n", PERIOD / C);
    printf("*********************************************\n"); 
    printf("Summary Result Count  . . . . : %5d / %5d\n", N, C);
    printf("*********************************************\n"); 
    printf("Timeout Rate  . . . . . . . . :(%7.1f)/hour\n", ToutSum * H);
    printf("XRUN Rate . . . . . . . . . . : %7.1f /hour\n", XrunSum * H);
    printf("Delay Rate (>spare time)  . . : %7.1f /hour\n", DelaySum * H);
    printf("Delay Rate (>1000 usecs)  . . : %7.1f /hour\n", Delay2Sum * H);
    printf("Delay Maximum . . . . . . . . : %5d   usecs\n", MaxDelaySum / N);
    printf("Cycle Maximum . . . . . . . . : %5d   usecs\n", MaxCycleSum / N);
    printf("Average DSP Load. . . . . . . : %7.1f %%\n", DspSum / N);
    printf("Average CPU System Load . . . : %7.1f %%\n", SysSum / N);
    printf("Average CPU User Load . . . . : %7.1f %%\n", UsrSum / N);
    printf("Average CPU Nice Load . . . . : %7.1f %%\n", NiceSum / N);
    printf("Average CPU I/O Wait Load . . : %7.1f %%\n", IOWaitSum / N);
    printf("Average CPU IRQ Load  . . . . : %7.1f %%\n", IrqSum / N);
    printf("Average CPU Soft-IRQ Load . . : %7.1f %%\n", SoftIrqSum / N);
    printf("Average Interrupt Rate  . . . : %7.1f /sec\n", IntSum / N);
    printf("Average Context-Switch Rate . : %7.1f /sec\n", CtxSum / N);
    printf("*********************************************\n"); 
}

