#!/bin/awk
#

BEGIN { 
    
    SECS    = 0;
    PORTS   = 0;
    CLIENTS = 0;
    PERIOD  = 0;
    
    DataRow = 0; 

    CycleUsecs = 0;
    SpareUsecs = 0;

    DspLoad = 0;
    SysLoad = 0;
    NceLoad = 0;
    IowLoad = 0;
    IrqLoad = 0;
    SftLoad = 0;
    IntRate = 0;
    CtxRate = 0;
    BioRate = 0;

    ToutCount   = 0;
    XrunCount   = 0;
    XrunSum     = 0;
    DelayCount  = 0;
    DelaySum    = 0;
}

/^Seconds to run        \(SECS\) =/ { SECS    = $6; }
/^Number of clients  \(CLIENTS\) =/ { CLIENTS = $6; }
/^Ports per client     \(PORTS\) =/ { PORTS   = $6; }
/^Frames per buffer   \(PERIOD\) =/ { PERIOD  = $6; }

/timed out/ { 
    ToutCount++; 
}  

/^delay of/ {
    DelayCount++; 
    DelaySum += $3 * 0.001;
}  

/pcm: xrun of at least/ { 
    XrunCount++; 
    XrunSum += $7;
}  

/^load = / { 
    DspLoad    = $3;
    CycleUsecs = $6;
    SpareUsecs = $9;
}

/^[0-9|:]+ cpu / { 

    if (DataRow == 0) {    
        printf("#SECS=%d CLIENTS=%d PORTS=%d PERIOD=%d\n", SECS, CLIENTS, PORTS, PERIOD);
        print("#DATA  CYCLE  SPARE DSP SYS USR NCE IOW IRQ SFT  INT   CTX    BIO  XRUN DELAY TO");
        print("#---- ------ ------ --- --- --- --- --- --- --- ----- ----- ----- ----- ----- --");
    }

    DataRow++;

    SysLoad = $3; 
    UsrLoad = $4; 
    NceLoad = $5; 
    IowLoad = $6; 
    IrqLoad = $7; 
    SftLoad = $8;
 
    IntRate = $10; if (match(IntRate, "k")) IntRate *= 1000;
    CtxRate = $12; if (match(CtxRate, "k")) CtxRate *= 1000;
    BiRate  = $13; if (match(BiRate,  "k")) BiRate  *= 1000;
    BoRate  = $14; if (match(BoRate,  "k")) BoRate  *= 1000;
    BioRate = BiRate + BoRate;

    Xrun  = 0; if (XrunCount  > 0) Xrun  = (XrunSum  / XrunCount);
    Delay = 0; if (DelayCount > 0) Delay = (DelaySum / DelayCount);

    printf("%5d %6.1f %6.1f %3d %3d %3d %3d %3d %3d %3d %5.1f %5.1f %5.1f %5.3f %5.3f %2d\n",
        DataRow, CycleUsecs, SpareUsecs, 
        DspLoad, SysLoad, UsrLoad, NceLoad, IowLoad, IrqLoad, SftLoad,
        IntRate * 0.001, CtxRate * 0.001, BioRate * 0.001,
        Xrun, Delay, Tout);
    
    ToutCount   = 0;
    XrunCount   = 0;
    XrunSum     = 0;
    DelayCount  = 0;
    DelaySum    = 0;
}
