#!/bin/sh
#

LOGS="$*"

# Local tools must be on same directory...
BASEDIR=`dirname $0`

for LOG in ${LOGS}; do
  EXT=`echo ${LOG} | sed 's/^.*\.log/\.log/'`
  case ${EXT} in
    .log.bz2)
      CAT="bzip2 -dc"  
      ;;
    .log.gz)
      CAT="gzip -dc"  
      ;;
    *)
      CAT="cat"  
      ;;
  esac
  NAME=`basename ${LOG} ${EXT}`
  ${CAT} ${LOG}| awk -f ${BASEDIR}/jack_test3_data.awk > ${NAME}.dat
  SUBTITLE=`cat ${NAME}.dat | grep '#SECS=' | sed 's/#//'`
  gnuplot << ____EndOfPlot
    set title "${NAME}\n${SUBTITLE}"
    set grid
    set style data lines
  # unset border
  # unset key
    set xlabel "Elapsed Time (secs)"
  # set xtics 60
    set ylabel "CPU Load (%), CTX (x1000/sec)"
    set y2label "XRUN, DELAY (msecs)"
    set yrange [0:100]
    set y2range [0:*]
    set y2tics 0.2
    set terminal png transparent small size 640,320
    set output "${NAME}.png"
    plot \
      "${NAME}.dat" using 0:4  title "DSP" lt 3,\
      "${NAME}.dat" using 0:5  title "SYS" lt 6,\
      "${NAME}.dat" using 0:6  title "USR" lt 2,\
      "${NAME}.dat" using 0:12 title "CTX" lt 9,\
      "${NAME}.dat" using 0:14 title "XRUN"  axis x1y2 with impulses lw 3 lt 1,\
      "${NAME}.dat" using 0:15 title "DELAY" axis x1y2 with impulses lw 3 lt 4
____EndOfPlot
    rm -f ${NAME}.dat
done
