#!/bin/awk
#

BEGIN {
    SECS        = 0;
    PORTS       = 0;
    CLIENTS     = 0;
    PERIOD      = 0;
    C           = 0;
    ToutCount   = 0;
    XrunCount   = 0;
    DelayCount  = 0;
    DelayCount2 = 0;
    MaxDelay    = 0;
    MaxCycle    = 0;
    DspLoadSum  = 0;
    DspCount    = 0;
    SysSum      = 0;
    UsrSum      = 0;
    NiceSum     = 0;
    IOwaitSum   = 0;
    IrqSum      = 0;
    SoftIrqSum  = 0;
    IntSum      = 0;    
    CtxSum      = 0;    
    NCount      = 0;    
}

/^Seconds to run        \(SECS\) =/ { SECS    += $6; C++; }
/^Number of clients  \(CLIENTS\) =/ { CLIENTS += $6; }
/^Ports per client     \(PORTS\) =/ { PORTS   += $6; }
/^Frames per buffer   \(PERIOD\) =/ { PERIOD  += $6; }

/timed out/         { ToutCount++; }  
/alsa_pcm: xrun/    { XrunCount++; }  
/^delay of/         { DelayCount++; }  
/^>1000/            { DelayCount2 += $2; }
/^max usecs/        { x = $3; if (x > MaxCycle) MaxCycle = x; }
/^max delay/        { x = $6; if (x > MaxDelay) MaxDelay = x; }
/^load = /          { DspSum += $3; DspCount++; }

/^[0-9|:]+ cpu / { 
    SysSum     += $3; 
    UsrSum     += $4; 
    NiceSum    += $5; 
    IOWaitSum  += $6; 
    IrqSum     += $7; 
    SoftIrqSum += $8; 
    x = $10; if (match(x, "k")) x *= 1000; IntSum += x;
    x = $12; if (match(x, "k")) x *= 1000; CtxSum += x;
    NCount++;
}

END {
    printf("************* SUMMARY RESULT ****************\n"); 
    printf("Total seconds ran . . . . . . : %5d\n", SECS);
    printf("Number of clients . . . . . . : %5d\n", CLIENTS / C);
    printf("Ports per client  . . . . . . : %5d\n", PORTS / C);
    printf("Frames per buffer . . . . . . : %5d\n", PERIOD / C);
    printf("*********************************************\n"); 
    printf("Timeout Count . . . . . . . . :(%5d)\n", ToutCount); 
    printf("XRUN Count  . . . . . . . . . : %5d\n", XrunCount); 
    printf("Delay Count (>spare time) . . : %5d\n", DelayCount);
    printf("Delay Count (>1000 usecs) . . : %5d\n", DelayCount2);
    printf("Delay Maximum . . . . . . . . : %5d   usecs\n", MaxDelay);
    printf("Cycle Maximum . . . . . . . . : %5d   usecs\n", MaxCycle);
    printf("Average DSP Load. . . . . . . : %7.1f %%\n", DspSum / DspCount);
    printf("Average CPU System Load . . . : %7.1f %%\n", SysSum / NCount);
    printf("Average CPU User Load . . . . : %7.1f %%\n", UsrSum / NCount);
    printf("Average CPU Nice Load . . . . : %7.1f %%\n", NiceSum / NCount);
    printf("Average CPU I/O Wait Load . . : %7.1f %%\n", IOWaitSum / NCount);
    printf("Average CPU IRQ Load  . . . . : %7.1f %%\n", IrqSum / NCount);
    printf("Average CPU Soft-IRQ Load . . : %7.1f %%\n", SoftIrqSum / NCount);
    printf("Average Interrupt Rate  . . . : %7.1f /sec\n", IntSum / NCount);
    printf("Average Context-Switch Rate . : %7.1f /sec\n", CtxSum / NCount);
    printf("*********************************************\n"); 
}


