#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kthread.h>

static int just_spin(void *data)
{
        while(!kthread_should_stop()) {
                schedule();
        }

        return 0;
}


static struct task_struct *deadlock_thread;

static int __init deadlock_init(void)
{
        printk(KERN_INFO "Hello from the kernel!\n");
        deadlock_thread = kthread_create(just_spin,0,"deadlock_spin");
	if (IS_ERR(deadlock_thread))
		return -1;
	wake_up_process(deadlock_thread);
        return 0;
}

static void __exit deadlock_exit(void)
{
	kthread_stop(deadlock_thread);
}

module_init(deadlock_init);
module_exit(deadlock_exit);

MODULE_AUTHOR("My name here");
MODULE_DESCRIPTION("Simple driver");
MODULE_LICENSE("GPL");

