#!/bin/sh

mount -t cpuset none $MNTPOINT 2> /dev/null
cd $MNTPOINT

# sd-1: Set exclusive on with no cpus
echo "sd-1: Set exclusive on with no cpus"
mkdir -p $TEMPDIR1
cd $TEMPDIR1
/bin/echo 0 > mems
/bin/echo 1 > cpu_exclusive
echo
read

# sd-2: Set exclusive off with no CPUs [exclusive previously on]
echo "sd-2: Set exclusive off with no CPUs [exclusive previously on]"
/bin/echo 0 > cpu_exclusive
echo
read

# sd-3: Add CPUs to a exclusive cpuset
echo "sd-3: Add CPUs to a exclusive cpuset"
/bin/echo 1 > cpu_exclusive
/bin/echo $CPUS > cpus
echo
read

# sd-4: Set exclusive on with exclusive already on
echo "sd-4: Set exclusive on with exclusive already on"
/bin/echo 1 > cpu_exclusive
echo
read

# sd-5: Add same set of CPUs as existing ones [exclusive on]
echo "sd-5: Add same set of CPUs as existing ones [exclusive on]"
/bin/echo $CPUS > cpus
echo
read

# sd-6: Set exclusive off with exclusive on
echo "sd-6: Set exclusive off with exclusive on"
/bin/echo 0 > cpu_exclusive
echo
read

# sd-7: Set exclusive off with exclusive already off
echo "sd-7: Set exclusive off with exclusive already off"
/bin/echo 0 > cpu_exclusive
echo
read

# sd-8: Remove CPUs from a exclusive cpuset
echo "sd-8: Remove CPUs from a exclusive cpuset"
/bin/echo 1 > cpu_exclusive
/bin/echo $CPUSH1 > cpus
echo
read

# sd-9: Add CPUs to an exclusive cpuset
echo "sd-9: Add CPUs to an exclusive cpuset"
/bin/echo $CPUS > cpus
echo
read

# sd-10: rmdir exclusive cpuset
echo "sd-10: rmdir exclusive cpuset"
cd $MNTPOINT
rmdir $TEMPDIR1
echo
read

# sd-11: Set exclusive on to a cpuset with some CPUs
echo "sd-11: Set exclusive on to a cpuset with some CPUs"
mkdir -p $TEMPDIR1
cd $TEMPDIR1
/bin/echo $CPUS > cpus
/bin/echo 0 > mems
/bin/echo 1 > cpu_exclusive
echo
read

# sd-12: Set exclusive on with parent exclusive off
echo "sd-12: Set exclusive on with parent exclusive off"
/bin/echo 0 > cpu_exclusive
mkdir -p $TEMPDIR2
cd $TEMPDIR2
/bin/echo $CPUSH2 > cpus
/bin/echo 0 > mems
/bin/echo 1 > cpu_exclusive
echo
read

# sd-13: Set exclusive on with parent exclusive on
echo "sd-13: Set exclusive on with parent exclusive on"
cd $TEMPDIR1
/bin/echo 1 > cpu_exclusive
cd $TEMPDIR2
/bin/echo 1 > cpu_exclusive
echo
read

# sd-14: Add CPUs to cpuset with exclusive children
echo "sd-14: Add CPUs to cpuset with exclusive children"
cd $TEMPDIR1
/bin/echo $CPUSM > cpus
echo
read

# sd-15: Remove CPUs from cpuset with exclusive children (illegal)
echo "sd-15: Remove CPUs from cpuset with exclusive children (illegal)"
cd $TEMPDIR1
/bin/echo $CPUSH1 > cpus
echo
read

# sd-16: Remove CPUs from cpuset with exclusive children (legal)
echo "sd-16: Remove CPUs from cpuset with exclusive children (legal)"
cd $TEMPDIR1
/bin/echo $CPUS > cpus
echo
read

# cleanup
echo "cleanup"
cd $TEMPDIR1
rmdir $TEMPDIR2
cd $MNTPOINT
rmdir $TEMPDIR1
echo
read

echo "Enter to start stress test"
read
while [ true ];
do
	cd $MNTPOINT
	rmdir $WVS 2> /dev/null

	mkdir -p $WVS
	cd $WVS
	/bin/echo 0 > mems
	/bin/echo $CPUSWVS > cpus
	/bin/echo 1 > cpu_exclusive
	/bin/echo 1 > cpu_exclusive

	mkdir -p $TTS
	cd $TTS
	/bin/echo 0 > mems
	/bin/echo $CPUSTTS > cpus
	/bin/echo 1 > cpu_exclusive
	/bin/echo 1 > cpu_exclusive

	mkdir -p $LL
	cd $LL
	/bin/echo 0 > mems
	/bin/echo $CPUSLL > cpus
	/bin/echo 1 > cpu_exclusive
	/bin/echo 1 > cpu_exclusive

	mkdir -p $ENG1
	cd $ENG1
	/bin/echo 0 > mems
	/bin/echo $CPUSENG1 > cpus
	/bin/echo 1 > cpu_exclusive
	/bin/echo 1 > cpu_exclusive

	mkdir -p $ENG2
	cd $ENG2
	/bin/echo 0 > mems
	/bin/echo $CPUSENG2 > cpus
	/bin/echo 1 > cpu_exclusive
	/bin/echo 1 > cpu_exclusive

	cd $TTS
	rmdir $ENG1
	rmdir $ENG2

	cd $WVS
	rmdir $TTS
	rmdir $LL

	cd $MNTPOINT
	rmdir $WVS

	# temp tests

	cd $MNTPOINT
	mkdir -p $TEMPDIR1
	cd $TEMPDIR1
	/bin/echo 0 > mems
	/bin/echo 1 > cpu_exclusive

	/bin/echo 0 > cpu_exclusive

	/bin/echo 1 > cpu_exclusive
	/bin/echo $CPUS > cpus

	/bin/echo 1 > cpu_exclusive

	/bin/echo $CPUS > cpus

	/bin/echo 0 > cpu_exclusive

	/bin/echo 0 > cpu_exclusive

	/bin/echo 1 > cpu_exclusive
	/bin/echo $CPUSH1 > cpus

	/bin/echo $CPUS > cpus

	cd $MNTPOINT
	rmdir $TEMPDIR1

	mkdir -p $TEMPDIR1
	cd $TEMPDIR1
	/bin/echo $CPUS > cpus
	/bin/echo 0 > mems
	/bin/echo 1 > cpu_exclusive

	/bin/echo 0 > cpu_exclusive
	mkdir -p $TEMPDIR2
	cd $TEMPDIR2
	/bin/echo $CPUSH2 > cpus
	/bin/echo 0 > mems
#	/bin/echo 1 > cpu_exclusive

	cd $TEMPDIR1
	/bin/echo 1 > cpu_exclusive
	cd $TEMPDIR2
	/bin/echo 1 > cpu_exclusive

	cd $TEMPDIR1
	/bin/echo $CPUSM > cpus

#	cd $TEMPDIR1
#	/bin/echo $CPUSH1 > cpus

	cd $TEMPDIR1
	/bin/echo $CPUS > cpus

	cd $TEMPDIR1
	rmdir $TEMPDIR2
	cd $MNTPOINT
	rmdir $TEMPDIR1
done
