#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <sys/time.h>

uint64_t inline rd_tsc(void)
{
	volatile uint32_t low;
	volatile uint64_t high;

	__asm__ __volatile__("rdtsc" : "=a" (low), "=d" (high));
	return (uint64_t)((high << 32) + low);
}

void inline gtod(void)
{
	struct timeval tv;

	gettimeofday(&tv, NULL);
}

uint64_t inline gtod_us(void)
{
	struct timeval tv;

	gettimeofday(&tv, NULL);

	return ((uint64_t)tv.tv_sec * 1000000) + (uint64_t)tv.tv_usec;
}

int main(int argc, char *argv[])
{
	uint64_t s,e,r;
	int i;
	uint64_t sum_rdtsc = 0;
	uint64_t sum_gtod = 0;
	uint64_t sum_gtod_us = 0;
	uint64_t avg_rdtsc;
	uint64_t loops;
	volatile uint64_t cur;

	if (argc != 2) {
		printf("useage: rdtsc-pref <loops>\n");
		return 1;
	}

	loops = atoll(argv[1]);

	for (i = 0; i < loops; i++) {
		s = rd_tsc();
		e = rd_tsc();
		r = e - s;
		sum_rdtsc += r;

		s = rd_tsc();
		gtod();
		e = rd_tsc();
		r = e - s;
		sum_gtod += r;

		s = rd_tsc();
		cur = gtod_us();
		e = rd_tsc();
		r = e - s;
		sum_gtod_us += r;
	}

	avg_rdtsc = sum_rdtsc / loops;

	printf("rdtsc:   average ticks=%4ld\n", avg_rdtsc);
	printf("gtod:    average ticks=%4ld\n", (sum_gtod / loops) - avg_rdtsc);
	printf("gtod_us: average ticks=%4ld\n", (sum_gtod_us / loops) - avg_rdtsc);

	return 0;
}
