#! /bin/sh
### BEGIN INIT INFO
# Provides:          retuclock.sh
# Required-Start:    mountdevsubfs
# Required-Stop:     $local_fs
# Default-Start:     S
# Default-Stop:      0 6
# Short-Description: Copy time between Retu RTC and system clock
# Description:       This is kind of replacement for Debian hwclock.sh using
#                    Retu RTC driver. Retu RTC is not real RTC since it only
#                    has free running second, minute and hour counters and
#                    resetable day counter counting from 0 to 255.
### END INIT INFO

# Author: Jarkko Nikula <jhnikula@gmail.com>
#

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="Retu RTC clock"
NAME=retuclock.sh
SCRIPTNAME=/etc/init.d/$NAME

RETU=/sys/bus/platform/drivers/retu-rtc/retu-rtc/time
DIFF_FILE=/var/local/retu_diff

[ -r $RETU ] || exit 0

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

RETU_TIME=`cat $RETU`
dd=$((0x`echo $RETU_TIME | cut -b 3,4`))
hh=$((0x`echo $RETU_TIME | cut -b 5,6`))
mm=$((0x`echo $RETU_TIME | cut -b 7,8`))
ss=$((0x`echo $RETU_TIME | cut -b 9,10`))

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
	[ -r $DIFF_FILE ] || return 0
	# Add Retu dd:hh:mm:ss count to diff file and convert to system time
	RETU_SEC=$(($dd*86400 + `date +%s --date "1970-01-01 $hh:$mm:$ss"`))
	DATE_SEC=$((`cat $DIFF_FILE` + $RETU_SEC))
	DATE=`perl -e "print scalar localtime $DATE_SEC"`
	date --set "$DATE"
	return 0
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	# Store current system second count - Retu hh:mm:ss count
	RETU_DIFF=$((`date +%s` - `date +%s --date "1970-01-01 $hh:$mm:$ss"`))
	echo $RETU_DIFF >$DIFF_FILE || return 3
	# Clear Retu day counter
	echo 0 >$RETU
	return 0
}

#
# Function that sends a SIGHUP to the daemon/service
#
do_reload() {
	#
	# If the daemon can reload its configuration without
	# restarting (for example, when it is sent a SIGHUP),
	# then implement that here.
	#
	start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE --name $NAME
	return 0
}

case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  #reload|force-reload)
	#
	# If do_reload() is not implemented then leave this commented out
	# and leave 'force-reload' as an alias for 'restart'.
	#
	#log_daemon_msg "Reloading $DESC" "$NAME"
	#do_reload
	#log_end_msg $?
	#;;
  restart|force-reload)
	#
	# If the "reload" option is implemented then remove the
	# 'force-reload' alias
	#
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	#echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $SCRIPTNAME {start|stop|restart|force-reload}" >&2
	exit 3
	;;
esac

:
