
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/fcntl.h>
#include <linux/miscdevice.h>

#define SCULLC_MINOR  123

int dummy_open (struct inode *inode, struct file *filp)
{
	printk("%s\n", __FUNCTION__);
	return 0;          /* success */
}

int dummy_release (struct inode *inode, struct file *filp)
{
	printk("%s\n", __FUNCTION__);
	return 0;
}

/*
 * Data management: read and write
 */

static struct semaphore dummy;

ssize_t dummy_read (struct file *filp, char __user *buf, size_t count,
                loff_t *f_pos)
{
	printk("%s\n", __FUNCTION__);

	printk("First time decrement goes okay.\n");
	down_interruptible(&dummy);
	printk("Do 1 up.\n");
	up(&dummy);
	printk("Do 2 times down.\n");
	down_interruptible(&dummy);
	printk("We will block now, and if you press CTRL-C from here, we get an OOPS.\n");
	down_interruptible(&dummy);
	printk("We are returning from the read().\n");
	return count;
}

ssize_t dummy_write (struct file *filp, const char __user *buf, size_t count,
                loff_t *f_pos)
{
	printk("%s\n", __FUNCTION__);
	return count;
}

/*
 * The fops
 */

struct file_operations dummy_fops = {
	.owner =     THIS_MODULE,
	.read =	     dummy_read,
	.write =     dummy_write,
	.open =	     dummy_open,
	.release =   dummy_release,
};

/*
 * Finally, the module stuff
 */
static struct miscdevice dummy_dev = {
	.minor		= MICROCODE_MINOR,
	.name		= "dummy",
	.fops		= &dummy_fops,
};

static int __init dummy_init (void)
{
	int error;

	sema_init(&dummy, 1);

	error = misc_register(&dummy_dev);
	if (error) {
		printk(KERN_ERR
			"dummy: can't misc_register on minor=%d\n",
			MICROCODE_MINOR);
		return error;
	}

	return 0;
}

static void dummy_cleanup (void)
{
	misc_deregister(&dummy_dev);
}

MODULE_ALIAS_MISCDEV(SCULLC_MINOR);

module_init(dummy_init);
module_exit(dummy_cleanup);
