/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*
 * isp1161 USB HCD for Linux Version 0.9.5 (10/28/2001)
 *                         Version Tango (05/11/2004)
 *                         Version Bingo (09/17/2004)
 *
 * requires (includes) hc_simple.[hc] simple generic HCD frontend
 *
 * Roman Weissgaerber weissg@vienna.at (C) 2001
 *
 * Thanks to Benjamin Herrenschmidt for debugging and the removing of
 * some bugs.
 *
 * Thanks to adsynori, I based my driver on your version : )
 * Special thanks to jazzcat, zengyi, haomaomao, sky... 
 * 				cannot do without you (^V^)
 * This driver is compatible with Intel Sitsang Evaluation Platform 
 * with USB HC Controller ISP1161A1, It seems there are still some problem
 * with ISP1161, maybe you should consider changing your chip if you're 
 * working with ISP1161.
 *
 * See readme for more detailed changelogs : )
 * 				fixer: tingwang	
 * 					wangting@gmail.com 
 *-------------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *-------------------------------------------------------------------------*/
/* V Bingo 09/17/2004 perfect ISOC transfer even under severe system payload */
/* V Tango 05/11/2004 ISOC transmission may not stop.(DATA IN) */
/* V 0.9.5 10/28/2001 correct toggle on error */
/*         inw, outw macros; ISOC support */
/* V 0.9  remove some bugs, ISOC still missing */
/* V 0.8.1 9/5/2001 mv memcpy of in packet to hc */
/* V 0.8 initial release */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/errno.h>
#include <linux/init.h>
//#include <linux/smp_lock.h>
#include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/delay.h>
#include <linux/usb.h>
#include <linux/stringify.h>
#include <asm/system.h>

//#include "../core/hcd.h"
#include "hcd.h"
#include <asm/irq.h>
#undef HC_URB_TIMEOUT
#define HC_SWITCH_INT
#define HC_ENABLE_ISOC
#define OHCI_USE_NPS
#include "hc_isp116x.h"
#include "hc_simple_isp116x.h"
//#define DEBUG1
static int hc_verbose = 0;

#include <linux/time.h>
#include <linux/proc_fs.h>
#define USE_FAST_ACCESS
int actual_len = 0; 
int is_iso = 0;
int global_itl = 0;
int global_time = 0;
int global_bh_count = 0;
int last_i = 0;
int force_return_flag = 0;
int now_sequence = 0;
int itl_reset = 1; 	//this bit is cleared whenever an iso urb finishes
int itl_buffer_die = 2;
int itl_buffer_count0 = 0;
int itl_buffer_count1 = 0;
int single_itl = 0;
int print_flag = 0;
int global_atl_count = 0;
int ATLInt_save = 0;
int iso_list_map[3] = {-1,-1,-1};
int last_HcFmNumber = -1;
int last_HcBufferStatus = -1;
int miss_flag = 0;
int Buffer_History[10];
int Buffer_History_p = 0;
int ATL_quirk_flag = 0;
int ITL0_die_flag = 0;
int ITL1_die_flag = 0;
int force_return_count = 0;
int kernel_panic_count = 0;
int last_proc_time_sec = -1;
int last_proc_time_usec = -1;
int proc_itl_stream = 0;
int itl_list_error[5] = {0,0,0,0,0};
int work_flag = 0;
struct timer_list isp_timer;
int timer_switch = 0;
int timer_counter = 0;
int itl_bandwidth[10];
int itl_interval[10];
int itl_data_len = 0;
int cleanup = 0;
int chip_reset = 0;


#include "hc_simple_isp116x.c"
#include "hc_isp116x_rh.c"

#if defined(CONFIG_ARCH_SITSANG)
#define HC_DEFAULT_DATA_PORT 0xf4000290
#define HC_DEFAULT_CMD_PORT 0xf4000292
//#define HC_DEFAULT_WU_PORT 0
#define HC_DEFAULT_WU_PORT -1
//#define HC_HARDWARE_CONFIG 0
//#define HC_HARDWARE_CONFIG (DataBusWidth16 | DownstreamPort15KRSel)
#define HC_HARDWARE_CONFIG (DataBusWidth16 | AnalogOCEnable )
#else
#define HC_DEFAULT_IRQ 74
#define HC_DEFAULT_DATA_PORT 0xba00c000
#define HC_DEFAULT_CMD_PORT 0xba00c002
#define HC_DEFAULT_WU_PORT -1
#define HC_HARDWARE_CONFIG (DataBusWidth16 | DownstreamPort15KRSel)
#endif
#ifndef	SITSANG_USB_HC_IRQ
#define SITSANG_USB_HC_IRQ 29
#endif
static int irq = SITSANG_USB_HC_IRQ;
static int data_port = HC_DEFAULT_DATA_PORT;
static int cmd_port = HC_DEFAULT_CMD_PORT;
static int wu_port = HC_DEFAULT_WU_PORT; /* Not used. */

MODULE_PARM(hc_verbose,"i");
MODULE_PARM_DESC(hc_verbose,"verbose startup messages, default is 1 (yes)");

MODULE_PARM(irq,"i");
MODULE_PARM_DESC(irq,"IRQ. default " __stringify(HC_DEFAULT_IRQ));
MODULE_PARM(data_port,"i");
MODULE_PARM_DESC(data_port,"Data port. default " __stringify(HC_DEFAULT_DATA_PORT));
MODULE_PARM(cmd_port,"i");
MODULE_PARM_DESC(cmd_port,"Command port. default " __stringify(HC_DEFAULT_CMD_PORT));
MODULE_PARM(wu_port,"i");
MODULE_PARM_DESC(wu_port,"Wakeup port. default " __stringify(HC_DEFAULT_WU_PORT));


static int hc_reset (hci_t * );
int hc_isp_proc_info (char *, char **, off_t, int, int *, void *);
int hc_isp_proc_reset (char *, char **, off_t, int, int *, void *);
void hc_renew_chip (unsigned long );

static inline void ISP116x_OUTW (int val, int addr)
{
        outw (val, addr);

}

static inline int ISP116x_INW (int addr)
{
	return inw (addr);

}

static inline int READ_REG32 (hci_t * hci, int regindex)
{
	hcipriv_t * hp = &hci->hp;
	int val16, val;

	ISP116x_OUTW (regindex, hp->cmd_port);
	ndelay(600);
	val16 = ISP116x_INW (hp->data_port);
	val = val16 & 0xffff;
	ndelay(600);
	val16 = ISP116x_INW (hp->data_port);
	val += val16 << 16;
	return val;
}

static inline int READ_REG16 (hci_t * hci, int regindex)
{
	hcipriv_t * hp = &hci->hp;
	int val = 0;
	ISP116x_OUTW (regindex, hp->cmd_port);
	ndelay(600);
	val = ISP116x_INW (hp->data_port);
	ndelay(600);
	return val;
}

static inline void READ_REGn16 (hci_t * hci, int regindex, int length, __u8 * buffer)
{
	hcipriv_t * hp = &hci->hp;
	int i;
	int val = 0;
	ISP116x_OUTW (regindex, hp->cmd_port);
	ndelay(600);
	for (i = 0; i < length - 1; i += 2) {
		val = ISP116x_INW (hp->data_port);
		buffer [i] = val;
		buffer [i+1] = val >> 8;
	}
	if (length & 1) {
		val = ISP116x_INW (hp->data_port);
		buffer [length - 1] = val;
	}
/*	if (is_iso==1) {
		printk (" READ_REGn16: %d :", length);
		for (i = 0; i < 16; i++)
//		for (i = 0; i < 8; i++)
		printk (" %2x", buffer [i]);
		printk("\n");
	}  */
#ifdef DEBUG1
	printk (" READ_REGn16: %d :", length);
	for (i = 0; i < length; i++)
//	for (i = 0; i < 8; i++)
		printk (" %2x", buffer [i]);
	printk("\n");
#endif
}

static inline void WRITE_REG32 (hci_t * hci, unsigned int value, int regindex)
{
	hcipriv_t * hp = &hci->hp;
	ISP116x_OUTW (regindex | 0x80, hp->cmd_port);
	ndelay(600);
	ISP116x_OUTW (value & 0xffff, hp->data_port);
	ndelay(600);
	ISP116x_OUTW (value >> 16, hp->data_port);
	ndelay(600);
}

static inline void WRITE_REG16 (hci_t * hci, unsigned int value, int regindex)
{
	hcipriv_t * hp = &hci->hp;
	ISP116x_OUTW (regindex | 0x80, hp->cmd_port);
	ndelay(600);
	ISP116x_OUTW (value, hp->data_port);
	ndelay(600);
}

static inline void WRITE_REG0 (hci_t * hci, int regindex)
{
	hcipriv_t * hp = &hci->hp;
	ISP116x_OUTW (regindex | 0x80, hp->cmd_port);
	ndelay(600);
}

static inline void WRITE_REGn16 (hci_t * hci, int regindex, int length, __u8 * buffer)
{
	hcipriv_t * hp = &hci->hp;
	int i;
	ISP116x_OUTW (regindex | 0x80, hp->cmd_port);
	ndelay(600);
	for (i = 0; i < length - 1; i += 2) {
		ISP116x_OUTW (buffer [i] + (buffer [i+1] << 8), hp->data_port);
	}
	if (length & 1) {
		ISP116x_OUTW (buffer [length - 1], hp->data_port);
	}
/*	if (is_iso==1) {
		printk (" WRITE_REGn16: %d :", length);
		for (i = 0; i < length; i++)
//		for (i = 0; i < 2; i++)
			printk (" %2x", buffer [i]);
		printk("\n");
	} */
}

/*-------------------------------------------------------------------------*/
/* tl functions */

static inline void hc_mark_last_trans (hci_t * hci)
{
	hcipriv_t * hp = &hci->hp;
	__u8 * ptd = hp->tl;

	if (hp->tlp > 0)
		*(ptd + hp->tl_last) |= (1 << 3);
}

static inline void hc_flush_data_cache (hci_t * hci, void * data, int len)
{}

static inline int hc_add_trans (hci_t * hci, int len, void * data,
		int toggle, int maxps, int slow, int endpoint, int address, int pid, int format, int type)
{
	hcipriv_t * hp = &hci->hp;
	unsigned char last = 0;
	__u8 * ptd = hp->tl;
	
	if (hp->units_left < ((len + 8 + 3) & ~0x3)) {
		return -1;
       	} else {
		hp->units_left -= (len + 8 + 3) & ~0x3;
	}

	ptd += hp->tlp;
	hp->tl_last = hp->tlp + 3;
       	if (format == 1){
        	last = 1;
        }
	ptd [0] = 0;
	ptd [1] = (toggle << 2) | (1 << 3) | (0xf << 4);
	ptd [2] = maxps;
	ptd [3] = ((maxps >> 8) & 0x3) | (slow << 2) | (last << 3) | (endpoint << 4);
	ptd [4] = len;
	ptd [5] = ((len >> 8) & 0x3) | (pid << 2);
	ptd [6] = address | (format << 7);
	ptd [7] = 0;


    	if (pid != PID_IN && len) {
		if (type==0) {
			memcpy (ptd + 8, data, len);
		} else {
			/* do nothing, because iso packets contains no additional data */	
		}
	}

	hp->tlp += ((len + 8 + 3) & ~0x3);
	return len;
}

static inline int hc_parse_trans (hci_t * hci, int * actbytes, void * data,
			int * cc, int * toggle, int length)
{
	hcipriv_t * hp = &hci->hp;
	int last = 0;
	int totbytes;
	int pid;
	int cp_count;
	__u8 *ptd = hp->tl;

	*cc = (ptd [1] >> 4) & 0xf;
	last = (ptd [3] >> 3) & 0x1;
	*actbytes = ((ptd [1] & 0x3) << 8) | ptd [0];
	totbytes = ((ptd [5] & 0x3) << 8) | ptd [4];
	pid = (ptd [5] >> 2) & 0x3;

	if (*actbytes > length)
		*actbytes = length;
	cp_count = *actbytes;
	
	if (pid == PID_IN && cp_count)
		memcpy (data, ptd + 8, cp_count);
	*toggle = (ptd [1] >> 2 & 1);
	if (*cc > 0 && *cc < 0xE && *cc != 9)
		*toggle = !*toggle;

	hp->tlp += ((totbytes + 8 + 3) & ~0x3);
	return !last;
}


/*-------------------------------------------------------------------------*/

static void hc_start_int (hci_t * hci)
{
#ifdef HC_SWITCH_INT
	int mask = OHCI_INTR_MIE | OHCI_INTR_SO | OHCI_INTR_SF;
	WRITE_REG32 (hci, mask, HcInterruptEnable);
	WRITE_REG32 (hci, mask, HcInterruptStatus);

	mask = SOFITLInt | ATLInt | OPR_Reg;
	WRITE_REG16 (hci, mask, HcuPInterrupt);
	WRITE_REG16 (hci, mask, HcuPInterruptEnable);
	WRITE_REG16 (hci, InterruptPinEnable| InterruptPinTrigger| InterruptOutputPolarity| HC_HARDWARE_CONFIG, HcHardwareConfiguration);	//added by wt
#endif
}

static void hc_start_sof_int (hci_t* hci)
{
	int mask = SOFITLInt | ATLInt | OPR_Reg;
	WRITE_REG16 (hci, mask, HcuPInterruptEnable);
}
	
static void hc_stop_int (hci_t * hci)
{
#ifdef HC_SWITCH_INT
	int mask = OHCI_INTR_MIE | OHCI_INTR_SO;
	WRITE_REG32 (hci, mask, HcInterruptEnable);
	WRITE_REG32 (hci, mask, HcInterruptStatus);

	WRITE_REG16 (hci, 0, HcuPInterrupt); /* maybe need */
	WRITE_REG16 (hci, 0, HcuPInterruptEnable);
	WRITE_REG16 (hci, HC_HARDWARE_CONFIG, HcHardwareConfiguration);
#endif
}

/*
void isp_timeout (unsigned long time_p)
{
	int i;
	itl_interval[timer_counter] = (jiffies-time_p);
	itl_bandwidth[timer_counter] = itl_data_len;
	itl_data_len = 0;
	timer_switch = 0;
	timer_counter++;
	if (timer_counter==10) {
		timer_counter = 0;
		printk (KERN_DEBUG "itl_data: \n");
		for (i=0; i<10; i++) {
			printk ("%d\t", itl_bandwidth[i]);
		}
		printk (KERN_DEBUG "\n");
		printk (KERN_DEBUG "itl_interval: \n");
		for (i=0; i<10; i++) {
			printk ("%d\t", itl_interval[i]);
		}
		printk (KERN_DEBUG "\n\n");
	}
}
*/

/************************************************************************/
/*	interrupt handler, do the following work: read data from 	
 *	ITLBuffer and ATLBuffer and call on a tasklet to finish
 *	any future work!!
 */
/************************************************************************/
static void hc_interrupt (int irq, void * __hci, struct pt_regs * r)
{
#ifdef CONFIG_ARCH_SITSANG
        if (!(SITSANG_BIPR_RW & SITSANG_BIPR_USB_HC_IRQ))
            return ;
        SITSANG_BIMR_RW &= ~SITSANG_BIMR_USB_HC_IRQ;
        SITSANG_BIPR_RW = SITSANG_BIPR_USB_HC_IRQ;
#endif

	int time_tmp = 0;
	hci_t * hci = __hci;
	unsigned long flag;
	unsigned char* ptd_p;
	hci->iso_buffer_index = 0;
	hcipriv_t * hp = &hci->hp;
	itl_data_t* itl_data_p;
	int ints_uP;
	int ints = 0;
	int time_left = 0;
	if ((ints_uP = (READ_REG16 (hci, HcuPInterrupt) & READ_REG16 (hci, HcuPInterruptEnable))) == 0) {
 		printk ("int1 %x %x\n", ints_uP, ints);
		printk (KERN_DEBUG "register information:\n");
		printk (KERN_DEBUG "HcControl: %x HcCommandStatus: %x HcInterruptStatus: %x \n", READ_REG32(hci,HcControl),\
				READ_REG32(hci, HcCommandStatus), READ_REG32(hci, HcInterruptStatus)); 
		printk (KERN_DEBUG "HcInterruptEnable: %x HcFmInterval: %x HcFmRemaining: %x \n", READ_REG32(hci,HcInterruptEnable), READ_REG32(hci, HcFmInterval), READ_REG32(hci, HcFmRemaining)); 
		printk (KERN_DEBUG "HcRhDescriptorA: %x HcRhStatus: %x HcHardwareConfiguration: %x \n", READ_REG32(hci,HcRhDescriptorA), READ_REG32(hci, HcRhStatus), READ_REG32(hci, HcHardwareConfiguration)); 
		printk (KERN_DEBUG "HcuPInterruptEnable: %x HcITLBufferLength: %x HcATLBufferLength: %x \n", READ_REG32(hci,HcuPInterruptEnable), READ_REG32(hci, HcITLBufferLength), READ_REG32(hci, HcATLBufferLength)); 
		if ( (READ_REG32(hci, HcControl)==0) && (READ_REG32(hci, HcInterruptEnable)==0) ) {
			chip_reset = 1;
			goto int_reset_next;
		}
/*
		if (work_flag>40 && cleanup==0 && READ_REG32(hci,HcInterruptEnable)==0x00) {
			printk (KERN_EMERG "Chip reset happened, we will renew the module.\n");
			tasklet_schedule (&hci->ChipReset);
		}
		goto out;
*/
	}
	if (chip_reset==1) {
		chip_reset = 0;
	}
int_reset_next:
	WRITE_REG16 (hci, ints_uP, HcuPInterrupt);
	if ((ints_uP & OPR_Reg) &&
 		(ints = (READ_REG32 (hci, HcInterruptStatus)))) {

		if (ints & OHCI_INTR_SO) {
			printk("USB Schedule overrun\n");
			WRITE_REG32 (hci, OHCI_INTR_SO, HcInterruptEnable);
		}
		if (ints & OHCI_INTR_SF) {
			WRITE_REG32 (hci, OHCI_INTR_SF, HcInterruptEnable);
		}
		WRITE_REG32 (hci, ints, HcInterruptStatus);
		WRITE_REG32 (hci, OHCI_INTR_MIE, HcInterruptEnable);
	}

/*
	if (timer_switch==0) {
		init_timer(&isp_timer);
		isp_timer.function = isp_timeout;
		isp_timer.data = (unsigned long)jiffies;
		isp_timer.expires = jiffies + HZ;
		add_timer(&isp_timer);
		timer_switch = 1;
	}
*/

	hci->frame_number = GET_FRAME_NUMBER (hci);
	hci->buffer_status = READ_REG16 (hci, HcBufferStatus);
//	printk (KERN_DEBUG "in hc_interrupt: int: %x frame_num: %x \n", ints_uP, hci->frame_number);
	
	Buffer_History[Buffer_History_p] = hci->buffer_status;
	Buffer_History_p = (Buffer_History_p+1)%10;

	if ( ints_uP & SOFITLInt ) {
		if ( last_HcFmNumber==-1 ) {
			last_HcFmNumber = hci->frame_number;
		} else { 
			if ( hci->frame_number>last_HcFmNumber ) {
				if ( (hci->frame_number-last_HcFmNumber)>1 ) {
					if ((last_HcBufferStatus & ITL1BufferFull)||(last_HcBufferStatus & ITL0BufferFull)) {
						if ( itl_reset==0 ) {
							miss_flag = 1;
						} else {
							global_itl++;
							if (global_itl==10) {
								global_itl--;
								itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
								if (!itl_data_p) {
									printk (KERN_EMERG "error in kmalloc!!\n");
									goto do_atl;
								}
								itl_data_p->data_buf = (__u8 *)kmalloc (1000+8, GFP_ATOMIC);
								if (!(itl_data_p->data_buf)) {
									printk (KERN_EMERG "error in kmalloc!!\n");
									goto do_atl;
								}
								itl_data_p->len = 1000;
								itl_data_p->frame_number = hci->frame_number;
								if (itl_reset==0) {
									itl_data_p->sequence = 0;
									global_itl = 1;
									if ( miss_flag==1 ) {
										miss_flag = 0;
										itl_data_p->sequence = 1;
										global_itl = 2;
									}
									itl_reset = 1;
								} else {
									itl_data_p->sequence = global_itl++;
								}
								if (global_itl==10) {
									global_itl = 0;
								}
								itl_data_p->len = actual_len+8;
								itl_data_p->data_buf[0] = 0xc1;
								itl_data_p->data_buf[1] = 0x07;
								itl_data_p->data_buf[2] = 0xff;
								itl_data_p->data_buf[3] = 0x1b;
								itl_data_p->data_buf[4] = 0xc1;
								itl_data_p->data_buf[5] = 0x0b;
								itl_data_p->data_buf[6] = 0x82;
								itl_data_p->data_buf[7] = 0x00;
								list_add (&itl_data_p->list, &hci->itl_list);

							}

						}
					}
				}
			}
			last_HcFmNumber = hci->frame_number;
		}
		last_HcBufferStatus = hci->buffer_status;
	}
				 
/*******************************************************************************/
/*	read ITL1 first, if there is an buffer overflow HC will stop at ITL1
 *	There will be a quirk in sh_done_list if this happens!!!
 *	we will call sh_done_list in bottomhalf. 
 */
/******************************************************************************/
	if (ints_uP & SOFITLInt) {	//decide whether buffer dies
		if (itl_buffer_die!=0 && itl_buffer_die!=1) {	//once itl_buffer_die happens, it will never go here!!
			if (hci->buffer_status & ITL0BufferDone) {
				itl_buffer_count0 = 0;
			}
			if (hci->buffer_status & ITL1BufferDone) {
				itl_buffer_count1 = 0;
			}
			if (hci->buffer_status & ITL0BufferFull) {
				itl_buffer_count0++;
			}
			if (hci->buffer_status & ITL1BufferFull) {
				itl_buffer_count1++;
			}
			if (itl_buffer_count0 >= 5) {
				itl_buffer_die = 0;
				ITL0_die_flag = 1;
			}
			if (itl_buffer_count1 >= 5) {
				itl_buffer_die = 1;
				ITL1_die_flag = 1;
			}
		}
		if (hci->buffer_status & ITL1BufferDone) {
			time_left = READ_REG32(hci, HcFmRemaining);
			if (time_left<0x300) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (1000+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = 1000;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
				itl_data_p->len = actual_len+8;
				itl_data_p->data_buf[0] = 0xc1;
				itl_data_p->data_buf[1] = 0x07;
				itl_data_p->data_buf[2] = 0xff;
				itl_data_p->data_buf[3] = 0x1b;
				itl_data_p->data_buf[4] = 0xc1;
				itl_data_p->data_buf[5] = 0x0b;
				itl_data_p->data_buf[6] = 0x82;
				itl_data_p->data_buf[7] = 0x00;
				list_add (&itl_data_p->list, &hci->itl_list);

				if (ints_uP & ATLInt) {
					ATLInt_save = 1;
				}
				time_left = READ_REG32(hci, HcFmRemaining);
				if (time_left<0x150 || time_left>0x300) {	
					goto out;
				} else {
					hp->tlp = 0;
					sh_scan_iso_urb_list (hci, &hci->iso_list, hci->frame_number);
					if (hp->tlp >0) {	/* updated in hc_add_trans() */
						hp->units_left = hp->itl_buffer_len;
						char* hp_tmp = hp->tl;
						int num_tmp = 0;
						if (hp_tmp[5] && (1 << 3)) {
							num_tmp = hp->tlp;
							hp->tlp = 8;
						}	

						spin_lock_irqsave (&hci->hci_lock, flag); 
						WRITE_REG16 (hci, hp->tlp, HcTransferCounter);
						WRITE_REGn16 (hci, HcITLBufferPort, hp->tlp, hp->tl);
						spin_unlock_irqrestore (&hci->hci_lock, flag);

						if (hp_tmp[5] && (1 << 3)) {
							hp->tlp = num_tmp;
						}
					}
					goto out;
				}

			}
			if (time_left<0x500) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (1000+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = 1000;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, 8, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, 8, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);

				itl_data_p->len = actual_len+8;
				list_add (&itl_data_p->list, &hci->itl_list);

				hp->tlp = 0;
				sh_scan_iso_urb_list (hci, &hci->iso_list, hci->frame_number);
				if (hp->tlp >0) {       /* updated in hc_add_trans() */
					hp->units_left = hp->itl_buffer_len;
					char* hp_tmp = hp->tl;
					int num_tmp = 0;
					if (hp_tmp[5] && (1 << 3)) {
						num_tmp = hp->tlp;
						hp->tlp = 8;
					}

					spin_lock_irqsave (&hci->hci_lock, flag);
					WRITE_REG16 (hci, hp->tlp, HcTransferCounter);
					WRITE_REGn16 (hci, HcITLBufferPort, hp->tlp, hp->tl);
					spin_unlock_irqrestore (&hci->hci_lock, flag);

					if (hp_tmp[5] && (1 << 3)) {
						hp->tlp = num_tmp;
					}
				}

				if (ints_uP&ATLInt && (READ_REG32(hci, HcFmRemaining)<0x160)) {
					ATLInt_save = 1;
					goto out;
				} else {
					goto do_atl;
				}
			} else if (time_left<0x1500 && time_left>=0x500) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (hp->itl1_len+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = hp->itl1_len;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, 8, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, 8, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);

				list_add (&itl_data_p->list, &hci->itl_list);
				goto write_itl;
			}
			hp->itl1_len = READ_REG16 (hci, HcReadBackITL1Length);
			if (hp->itl1_len > 0) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (hp->itl1_len+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = hp->itl1_len;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
#ifdef USE_FAST_ACCESS
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, 8, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, 8, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);
				
				ptd_p = itl_data_p->data_buf;
				actual_len = ( ptd_p[0]|((ptd_p[1]& 0x03)<<8) );
				if ( actual_len!=0 ){
					
					actual_len = actual_len + 8;
					spin_lock_irqsave (&hci->hci_lock, flag); 
					WRITE_REG16 (hci, actual_len, HcTransferCounter);
					itl_data_p->data_buf = ptd_p+8;
					READ_REGn16 (hci, HcITLBufferPort, actual_len, itl_data_p->data_buf);
					spin_unlock_irqrestore (&hci->hci_lock, flag);
				
				} else {
					actual_len = 0;	
				}
				itl_data_p->len = actual_len+8;
				proc_itl_stream += actual_len;
				itl_data_len += actual_len;
#else				
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, hp->itl1_len, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, hp->itl1_len, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);
#endif				
				list_add (&itl_data_p->list, &hci->itl_list);
			}
		} else if (hci->buffer_status & ITL0BufferDone) {
			time_left = READ_REG32(hci, HcFmRemaining);
			if (time_left<0x300) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (1000+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = 1000;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
				itl_data_p->len = actual_len+8;
				itl_data_p->data_buf[0] = 0xc1;
				itl_data_p->data_buf[1] = 0x07;
				itl_data_p->data_buf[2] = 0xff;
				itl_data_p->data_buf[3] = 0x1b;
				itl_data_p->data_buf[4] = 0xc1;
				itl_data_p->data_buf[5] = 0x0b;
				itl_data_p->data_buf[6] = 0x82;
				itl_data_p->data_buf[7] = 0x00;
				list_add (&itl_data_p->list, &hci->itl_list);

				if (ints_uP & ATLInt) {
					ATLInt_save = 1;
				}

				time_left = READ_REG32(hci, HcFmRemaining);
                                if (time_left<0x150 || time_left>0x300) {
                                        goto out;
                                } else {
                                        hp->tlp = 0;
                                        sh_scan_iso_urb_list (hci, &hci->iso_list, hci->frame_number);
                                        if (hp->tlp >0) {       /* updated in hc_add_trans() */
                                                hp->units_left = hp->itl_buffer_len;
                                                char* hp_tmp = hp->tl;
                                                int num_tmp = 0;
                                                if (hp_tmp[5] && (1 << 3)) {
                                                        num_tmp = hp->tlp;
                                                        hp->tlp = 8;
                                                }
                                                                                                                             
                                                spin_lock_irqsave (&hci->hci_lock, flag);
                                                WRITE_REG16 (hci, hp->tlp, HcTransferCounter);
                                                WRITE_REGn16 (hci, HcITLBufferPort, hp->tlp, hp->tl);
                                                spin_unlock_irqrestore (&hci->hci_lock, flag);
                                                                                                                             
                                                if (hp_tmp[5] && (1 << 3)) {
                                                        hp->tlp = num_tmp;
                                                }
                                        }
                                        goto out;
                                }
			}
			if (time_left<0x500) {

				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (1000+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = 1000;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, 8, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, 8, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);

				itl_data_p->len = actual_len+8;
				list_add (&itl_data_p->list, &hci->itl_list);

				hp->tlp = 0;
				sh_scan_iso_urb_list (hci, &hci->iso_list, hci->frame_number);
				if (hp->tlp >0) {       /* updated in hc_add_trans() */
					hp->units_left = hp->itl_buffer_len;
					char* hp_tmp = hp->tl;
					int num_tmp = 0;
					if (hp_tmp[5] && (1 << 3)) {
						num_tmp = hp->tlp;
						hp->tlp = 8;
					}

					spin_lock_irqsave (&hci->hci_lock, flag);
					WRITE_REG16 (hci, hp->tlp, HcTransferCounter);
					WRITE_REGn16 (hci, HcITLBufferPort, hp->tlp, hp->tl);
					spin_unlock_irqrestore (&hci->hci_lock, flag);

					if (hp_tmp[5] && (1 << 3)) {
						hp->tlp = num_tmp;
					}
				}

				if (ints_uP&ATLInt && (READ_REG32(hci, HcFmRemaining)<0x160)) {
					ATLInt_save = 1;
					goto out;
				} else {
					goto do_atl;
				}
			} else if (time_left<0x1500 && time_left>=0x500) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (hp->itl1_len+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = hp->itl1_len;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, 8, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, 8, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);

				list_add (&itl_data_p->list, &hci->itl_list);
				goto write_itl;
			}
			hp->itl0_len = READ_REG16 (hci, HcReadBackITL0Length);
			if (hp->itl0_len > 0) {
				itl_data_p = (itl_data_t *)kmalloc(sizeof(itl_data_t),GFP_ATOMIC);
				if (!itl_data_p) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->data_buf = (__u8 *)kmalloc (hp->itl0_len+8, GFP_ATOMIC);
				if (!(itl_data_p->data_buf)) {
					printk (KERN_EMERG "error in kmalloc!!\n");
					goto do_atl;
				}
				itl_data_p->len = hp->itl0_len;
				itl_data_p->frame_number = hci->frame_number;
				if (itl_reset==0) {
					itl_data_p->sequence = 0;
					global_itl = 1;
					if ( miss_flag==1 ) {
						miss_flag = 0;
						itl_data_p->sequence = 1;
						global_itl = 2;
					}
					itl_reset = 1;
				} else {
					itl_data_p->sequence = global_itl++;
				}
				if (global_itl==10) {
					global_itl = 0;
				}
#ifdef USE_FAST_ACCESS
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, 8, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, 8, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);
				
				ptd_p = itl_data_p->data_buf;
				actual_len = ( ptd_p[0]|((ptd_p[1]& 0x03)<<8) );
				if ( actual_len!=0 ){
					
					actual_len = actual_len + 8;
					spin_lock_irqsave (&hci->hci_lock, flag); 
					WRITE_REG16 (hci, actual_len, HcTransferCounter);
					itl_data_p->data_buf = ptd_p+8;
					READ_REGn16 (hci, HcITLBufferPort, actual_len, itl_data_p->data_buf);
					spin_unlock_irqrestore (&hci->hci_lock, flag);
				
				} else {
					actual_len = 0;	
				}
				itl_data_p->len = actual_len+8;
				proc_itl_stream += actual_len;
				itl_data_len += actual_len;
#else				
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, hp->itl0_len, HcTransferCounter);
				READ_REGn16 (hci, HcITLBufferPort, hp->itl0_len, itl_data_p->data_buf);
				spin_unlock_irqrestore (&hci->hci_lock, flag);
#endif
				list_add (&itl_data_p->list, &hci->itl_list);
			}
             	}
write_itl:
		tasklet_schedule (&hci->bottomHalf);
		hp->tlp = 0;
     		sh_scan_iso_urb_list (hci, &hci->iso_list, hci->frame_number);
    		if (hp->tlp >0) {	/* updated in hc_add_trans() */
			hp->units_left = hp->itl_buffer_len;
			char* hp_tmp = hp->tl;
			int num_tmp = 0;
			if (hp_tmp[5] && (1 << 3)) {
				num_tmp = hp->tlp;
				hp->tlp = 8;
			}	

			spin_lock_irqsave (&hci->hci_lock, flag); 
			WRITE_REG16 (hci, hp->tlp, HcTransferCounter);
			WRITE_REGn16 (hci, HcITLBufferPort, hp->tlp, hp->tl);
			spin_unlock_irqrestore (&hci->hci_lock, flag);
		
			if (hp_tmp[5] && (1 << 3)) {
				hp->tlp = num_tmp;
			}
		}
	}
/***********************************************************************/
/*	we will handle ATL after Read ITL buffer!!
 *
 */
/***********************************************************************/
do_atl:
	time_left = READ_REG32(hci, HcFmRemaining);
	if (time_left<0x200) {
		if (ints_uP&ATLInt) {
			ATLInt_save = 1;
		}
		goto out;
	}
	
	if ( (ints_uP & ATLInt) && (!(ints_uP & SOFITLInt)) ) {
		ATLInt_save = 1;
		goto out;
	}
        if (ints_uP & ATLInt) {
		if ((hci->buffer_status & ATLBufferFull) && (hci->buffer_status & ATLBufferDone)) {
			if (hp->atl_len > 0) {
				
				spin_lock_irqsave (&hci->hci_lock, flag); 
				WRITE_REG16 (hci, hp->atl_len, HcTransferCounter);
				READ_REGn16 (hci, HcATLBufferPort, hp->atl_len, hp->tl);
				spin_unlock_irqrestore (&hci->hci_lock, flag);
				hp->tlp = 0;
				hci->td_array = &hci->a_td_array;
				sh_done_list (hci);
			}
			hp->tlp = 0;
			if ( READ_REG16(hci, HcuPInterrupt)&SOFITLInt ) {
				printk (KERN_DEBUG "warning : interrupt happened in atl \n");
			}
		} else { 
			ATL_quirk_flag = 1;
//			hc_reset (hci);
			goto out;
		} 
	} else if(ATLInt_save==1) {
			ATLInt_save = 0;
			if ((hci->buffer_status & ATLBufferFull) && (hci->buffer_status & ATLBufferDone)) {
				if (hp->atl_len > 0) {

					spin_lock_irqsave (&hci->hci_lock, flag); 
					WRITE_REG16 (hci, hp->atl_len, HcTransferCounter);
					READ_REGn16 (hci, HcATLBufferPort, hp->atl_len, hp->tl);
					spin_unlock_irqrestore (&hci->hci_lock, flag);
					hp->tlp = 0;
					hci->td_array = &hci->a_td_array;
					sh_done_list (hci);
				}
				hp->tlp = 0;
			}	
	}
	time_left = READ_REG32(hci, HcFmRemaining);
	if (time_left<0x100) {
		goto out;
	}
	if (!hci->td_array->len)
		sh_del_list (hci);
	hci->td_array = &hci->a_td_array;
	hci->buffer_status = READ_REG16 (hci, HcBufferStatus);
	if (hci->td_array->len == 0 && !(hci->buffer_status & ATLBufferFull)) {
		hp->units_left = hp->atl_buffer_len;
		hp->tlp = 0;
		sh_schedule_trans (hci);
		hc_mark_last_trans (hci);
		hp->atl_len = hp->tlp;
		if (hp->atl_len > 0) {
			
			if (work_flag<50) {
				work_flag++;
			}
			spin_lock_irqsave (&hci->hci_lock, flag); 
			WRITE_REG16 (hci, hp->atl_len, HcTransferCounter);
			WRITE_REGn16 (hci, HcATLBufferPort, hp->atl_len, hp->tl);
			spin_unlock_irqrestore (&hci->hci_lock, flag);
		}
	}
out:
#ifdef CONFIG_ARCH_SITSANG
        SITSANG_BIPR_RW = SITSANG_BIPR_USB_HC_IRQ;
        SITSANG_BIMR_RW |= SITSANG_BIMR_USB_HC_IRQ;
#endif

}

/***********************************************************************************/
/*	hc_interrupt_bh do the following job: parse the data read from isp1161A1
 *	and arrange future transactions, that is write new PTDs into isp1161A1
 *
 */
/***********************************************************************************/
void hc_interrupt_bh (unsigned long __hci)
{
	hci_t* hci = (hci_t *)__hci;
	hci->bh_in_progress = 1;
     	
	itl_done_list (hci);
	
	hci->bh_in_progress = 0;
//	printk (KERN_DEBUG "leave bh \n\n");
}


/*-------------------------------------------------------------------------*
 * HC functions
 *-------------------------------------------------------------------------*/

/* reset the HC and BUS */

static int hc_reset (hci_t * hci)
{
	int timeout = 30;
	/* Disable HC interrupts */
	printk (KERN_DEBUG "call hc_reset!!\n");
	WRITE_REG16 (hci, 0,HcuPInterruptEnable);
	WRITE_REG16 (hci, InterruptPinEnable | HC_HARDWARE_CONFIG, HcHardwareConfiguration);
	WRITE_REG16 (hci, InterruptOutputPolarity | HC_HARDWARE_CONFIG, HcHardwareConfiguration);

	dbg ("USB HC reset_hc usb-: ctrl = 0x%x ;",
		READ_REG32 (hci, HcControl));

  	/* Reset USB (needed by some controllers) */
//	WRITE_REG32 (hci, 0, HcControl);
//	WRITE_REG0 (hci, HcSoftwareReset);
       WRITE_REG16 (hci, 0xf6, HcSoftwareReset);
	/* HC Reset requires max 10 us delay */
	WRITE_REG32 (hci, OHCI_HCR, HcCommandStatus);
	while ((READ_REG32 (hci, HcCommandStatus) & OHCI_HCR) != 0) {
		if (--timeout == 0) {
			printk ("USB HC reset timed out!\n");
			return -1;
		}
		udelay (10);
	}
	return 0;
}

/*-------------------------------------------------------------------------*/

/* Start an host controller, set the BUS operational
 * enable interrupts
 * connect the virtual root hub */

static int hc_alloc_trans_buffer (hci_t * hci)
{
	hcipriv_t * hp = &hci->hp;
	int maxlen;

	hp->itl0_len = 0;
	hp->itl1_len = 0;
	hp->atl_len = 0;

//	hp->itl_buffer_len = 1024;
	hp->itl_buffer_len = 1024+256;
	hp->atl_buffer_len = 4096 - 2 * hp->itl_buffer_len; /* 2048 */

	WRITE_REG16 (hci, hp->itl_buffer_len, HcITLBufferLength);
	WRITE_REG16 (hci, hp->atl_buffer_len, HcATLBufferLength);

	/* Enable IRQ's */
	WRITE_REG16 (hci,
		     InterruptPinEnable | HC_HARDWARE_CONFIG,
		     HcHardwareConfiguration);

	WRITE_REG16 (hci, 0, HcDMAConfiguration);

	maxlen = (hp->itl_buffer_len > hp->atl_buffer_len) ? hp->itl_buffer_len : hp->atl_buffer_len;

	hp->tl = kmalloc (maxlen, GFP_ATOMIC);

	if (!hp->tl)
		return -ENOMEM;

	memset (hp->tl, 0, maxlen);
	return 0;
}

static int hc_start (hci_t * hci)
{
	hcipriv_t * hp = &hci->hp;
  	__u32 mask;
  	unsigned int fminterval;

  	fminterval = 0x2edf;
	fminterval |= ((((fminterval - 210) * 6) / 7) << 16);
	WRITE_REG32 (hci, fminterval, HcFmInterval);
	WRITE_REG32 (hci, 0x628, HcLSThreshold);

 	/* start controller operations */
 	hp->hc_control = OHCI_USB_OPER;
 	WRITE_REG32 (hci, hp->hc_control, HcControl);

	/* Choose the interrupts we care about now, others later on demand */
	mask = OHCI_INTR_MIE |
//	OHCI_INTR_ATD |
	OHCI_INTR_SO ;
//	OHCI_INTR_SF;
	WRITE_REG32 (hci, mask, HcInterruptEnable);
	WRITE_REG32 (hci, mask, HcInterruptStatus);

	mask = SOFITLInt | ATLInt | OPR_Reg;
#ifdef HC_SWITCH_INT
	mask = 0;
#endif
	WRITE_REG16 (hci, mask, HcuPInterrupt);
	WRITE_REG16 (hci, mask, HcuPInterruptEnable);


#ifdef	OHCI_USE_NPS
	WRITE_REG32 (hci,(READ_REG32 (hci, HcRhDescriptorA) | RH_A_NPS) & ~RH_A_PSM,
		HcRhDescriptorA);
	WRITE_REG32 (hci, RH_HS_LPSC, HcRhStatus);
#endif	/* OHCI_USE_NPS */

	// POTPGT delay is bits 24-31, in 2 ms units.
	mdelay ((READ_REG32 (hci, HcRhDescriptorA) >> 23) & 0x1fe);
	rh_connect_rh (hci);

	return 0;
}


/*-------------------------------------------------------------------------*/

/* allocate HCI */

static hci_t * __devinit hc_alloc_hci (void)
{
	hci_t * hci;
	hcipriv_t * hp;

	struct usb_bus * bus;

	hci = (hci_t *) kmalloc (sizeof (hci_t), GFP_ATOMIC);
	if (!hci)
		return NULL;

	memset (hci, 0, sizeof (hci_t));

	hp = &hci->hp;

	hp->irq = -1;
	hp->data_port = -1;
	hp->cmd_port = -1;
	hp->wu_port = -1;

 	hci->a_td_array.len = 0;
 	hci->i_td_array[0].len = 0;
 	hci->i_td_array[1].len = 0;
 	hci->td_array = &hci->a_td_array;
 	hci->active_urbs = 0;
	hci->bh_in_progress = 0;
	hci->iso_buffer_index = 0;

	INIT_LIST_HEAD (&hci->hci_hcd_list);
	list_add (&hci->hci_hcd_list, &hci_hcd_list);
	init_waitqueue_head (&hci->waitq);

	INIT_LIST_HEAD (&hci->ctrl_list);
	INIT_LIST_HEAD (&hci->bulk_list);
	INIT_LIST_HEAD (&hci->iso_list);
	INIT_LIST_HEAD (&hci->intr_list);
	INIT_LIST_HEAD (&hci->del_list);
	INIT_LIST_HEAD (&hci->itl_list);

	bus = usb_alloc_bus (&hci_device_operations);
	if (!bus) {
		kfree (hci);
		return NULL;
	}

	hci->bus = bus;
	bus->bus_name = "isp116x";
	bus->hcpriv = (void *) hci;
	hci->bottomHalf.func = hc_interrupt_bh;
	hci->bottomHalf.data = (unsigned long)hci;
	hci->ChipReset.func = hc_renew_chip;
	hci->ChipReset.data = (unsigned long)hci;

	return hci;
}


/*-------------------------------------------------------------------------*/

/* De-allocate all resources.. */

static void hc_release_hci (hci_t * hci)
{
	hcipriv_t * hp = &hci->hp;
	dbg ("USB HC release hci %d", hci->regs);

	/* disconnect all devices */
	if (hci->bus->root_hub)
		usb_disconnect (&hci->bus->root_hub);

	if (hp->data_port != -1) {
		WRITE_REG16 (hci, 0, HcHardwareConfiguration);
		WRITE_REG16 (hci, 0, HcDMAConfiguration);
		WRITE_REG16 (hci, 0, HcuPInterruptEnable);
	}

//	if (!hci->disabled)
		hc_reset (hci);

	if (hp->tl)
		kfree (hp->tl);

	if (hp->data_port != -1) {
		release_region (hp->data_port, 2);
		hp->data_port = -1;
	}

	if (hp->cmd_port != -1) {
		release_region (hp->cmd_port, 2);
		hp->cmd_port = -1;
	}

	if (hp->wu_port != -1) {
		release_region (hp->wu_port, 2);
		hp->wu_port = -1;
	}

	if (hp->irq >= 0) {
		free_irq (hp->irq, hci);
		hp->irq = -1;
	}

	usb_deregister_bus (hci->bus);
	usb_free_bus (hci->bus);

	list_del (&hci->hci_hcd_list);
	INIT_LIST_HEAD (&hci->hci_hcd_list);

	kfree (hci);
}

/*-------------------------------------------------------------------------*/

/* Increment the module usage count, start the control thread and
 * return success. */


static int __devinit hc_found_hci (int data_port, int cmd_port, int wu_addr, int irq, int dma)
{
	hci_t * hci;
	hcipriv_t * hp;

	hci = hc_alloc_hci ();
	if (!hci) {
		return -ENOMEM;
	}

	hp = &hci->hp;

	if (!request_region (data_port, 2, "ISP116x USB HOST")) {
		err ("request address %d-%d failed", data_port, data_port+4);
		hc_release_hci (hci);
		return -EBUSY;
	}
	hp->data_port = data_port;

	if (!request_region (cmd_port, 2, "ISP116x USB HOST")) {
		err ("request address %d-%d failed", data_port, data_port+4);
		hc_release_hci (hci);
		return -EBUSY;
	}
	hp->cmd_port = cmd_port;

	if ( wu_addr != -1 ) {
		if (!request_region (wu_addr, 2, "ISP116x USB HOST")) {
			err ("request address %d-%d failed", wu_addr, wu_addr+2);
			hc_release_hci (hci);
			return -EBUSY;
		}
	}
	hp->wu_port = wu_addr;

	if ((READ_REG16(hci, HcChipID) & 0xff00) != 0x6100) {
             printk("ISP116x Not Found. HcChipID = 0x%x\n",READ_REG16(hci, HcChipID));
             hc_release_hci (hci);
		return -ENODEV;
	}

	if (hc_reset (hci) < 0) {
		hc_release_hci (hci);
		return -ENODEV;
	}

	if (hc_alloc_trans_buffer (hci)) {
		hc_release_hci (hci);
		return -ENOMEM;
	}

	printk(KERN_INFO __FILE__ ": USB ISP116x at %x/%x,%x IRQ %d Rev. %x ChipID: %x\n",
		data_port, cmd_port, wu_addr, irq, READ_REG32(hci, HcRevision), READ_REG16(hci, HcChipID));

	/* FIXME this is a second HC reset; why?? */
//	WRITE_REG32 (hci, hp->hc_control = OHCI_USB_RESET, HcControl);
	wait_ms (1000);

	usb_register_bus (hci->bus);

	if (request_irq (irq, hc_interrupt, SA_SHIRQ,
			"ISP116x", hci) != 0) {
		err ("request interrupt %d failed", irq);
		hc_release_hci (hci);
		return -EBUSY;
	}
	hp->irq = irq;
	if (hc_start (hci) < 0) {
		err ("can't start usb-%x", data_port);
		hc_release_hci (hci);
		return -EBUSY;
	}
	SITSANG_BIPR_RW = SITSANG_BIPR_USB_HC_IRQ;
        SITSANG_BIMR_RW |= SITSANG_BIMR_USB_HC_IRQ;


	return 0;
}


/*-------------------------------------------------------------------------*/

static int __init hci_hcd_init (void)
{
	int ret;
#ifdef CONFIG_ARCH_SITSANG
        unsigned int irq_gpio_pin = 0;

        irq_gpio_pin = IRQ_TO_GPIO_2_80(SITSANG_USB_HC_IRQ);
        GPDR(irq_gpio_pin) &= ~GPIO_bit(irq_gpio_pin);
        set_GPIO_IRQ_edge(irq_gpio_pin, GPIO_RISING_EDGE);

        SITSANG_PCR_RW |= SITSANG_PCR_USB_HOST_ON | SITSANG_PCR_PER_ON;

        SITSANG_BCR_RW |= SITSANG_BCR_BUS_OPEN | SITSANG_BCR_USB_NDP;
        SITSANG_BCR_RW |= SITSANG_BCR_USB_HC_RESET;
        mdelay(500);

        /*Reset the CHIP*/
        SITSANG_BCR_RW &= ~(SITSANG_BCR_USB_HC_RESET);
        mdelay(500);

        MSC2 &= 0xffff0000;
        MSC2 |= 0x00009489;

#endif
	ret = hc_found_hci (data_port, cmd_port, wu_port, irq, 0);
	/* init these data */
	for (Buffer_History_p=0; Buffer_History_p<10; Buffer_History_p++) {
		Buffer_History[Buffer_History_p] = 0;
	}
	Buffer_History_p = 0;
	create_proc_read_entry ("isp_info", 0, NULL, hc_isp_proc_info, NULL);
	create_proc_read_entry ("isp_reset", 0, NULL, hc_isp_proc_reset, NULL);

	return ret;
}

/*-------------------------------------------------------------------------*/

static void __exit hci_hcd_cleanup (void)
{
	struct list_head *  hci_l;
	cleanup = 1;
	hci_t * hci;
	for (hci_l = hci_hcd_list.next; hci_l != &hci_hcd_list;) {
		hci = list_entry (hci_l, hci_t, hci_hcd_list);
		hci_l = hci_l->next;
		hc_release_hci(hci);
      	}
	remove_proc_entry("isp_info", NULL);
#ifdef CONFIG_ARCH_SITSANG
        SITSANG_BIMR_RW &= ~SITSANG_BIMR_USB_HC_IRQ;
        SITSANG_PCR_RW &= ~SITSANG_PCR_USB_HOST_ON;
#endif

}

int hc_isp_proc_info (char *buf, char **start, off_t offset, int count, int *eof, void *data)
{
	int i, j, len = 0;
	int usec_interval = 0;
	struct timeval timeVal;
	do_gettimeofday (&timeVal);
	j = Buffer_History_p;
	for (i=0; i<10; i++) {
		len += sprintf (buf+len,"in hc_interrupt HcBufferStatus: 0x%x	\n", Buffer_History[j]);
		j = (j+1)%10;
	}
	len += sprintf (buf+len,"some flags about Buffer: \n");
	len += sprintf (buf+len,"\tATL_quirk_flag : %d \n", ATL_quirk_flag);
	len += sprintf (buf+len,"\tITL0_die_flag  : %d \n", ITL0_die_flag);
	len += sprintf (buf+len,"\tITL1_die_flag  : %d \n", ITL1_die_flag);
	len += sprintf (buf+len,"\n");
	len += sprintf (buf+len,"go to force_return count : %d \n", force_return_count);
	len += sprintf (buf+len,"kernel panic count : %d \n", kernel_panic_count);
	len += sprintf (buf+len,"itl_list_map error : %d %d %d %d %d \n", itl_list_error[0], itl_list_error[1],	\
				 itl_list_error[2], itl_list_error[3], itl_list_error[4]);

	if (last_proc_time_sec==-1) {
		len += sprintf (buf+len,"now we will start to calculate bandwidth!!\n");
		last_proc_time_sec = timeVal.tv_sec;
		last_proc_time_usec = timeVal.tv_usec;
		proc_itl_stream = 0;
	} else {
		usec_interval = (timeVal.tv_sec-last_proc_time_sec)*1000000 + (timeVal.tv_usec-last_proc_time_usec);
		len += sprintf (buf+len,"USB ITL BandWidth : %dbyte/sec\n", (proc_itl_stream*1000000)/usec_interval);
		len += sprintf (buf+len,"test interval     : %dsec\n", usec_interval/1000000);	
		last_proc_time_sec = timeVal.tv_sec;
		last_proc_time_usec = timeVal.tv_usec;
		proc_itl_stream = 0;
	}		
	return len;
}

int hc_isp_proc_reset (char *buf, char **start, off_t offset, int count, int *eof, void *data)
{
	int len = 0;
	len += sprintf (buf+len,"%d", chip_reset);
	return len;
}

void hc_renew_chip (unsigned long __hci)
{
	hci_t* hci = (hci_t *)__hci;
	hcipriv_t * hp = &hci->hp;
	unsigned int fminterval;
	int mask;
	if (hc_reset (hci) < 0) {
		hc_release_hci (hci);
		printk (KERN_EMERG "Error in hc_reset, check code!!\n");
		return;
	}

	WRITE_REG16 (hci, hp->itl_buffer_len, HcITLBufferLength);
	WRITE_REG16 (hci, hp->atl_buffer_len, HcATLBufferLength);

	/* Enable IRQ's */
	WRITE_REG16 (hci,
		     InterruptPinEnable | HC_HARDWARE_CONFIG,
		     HcHardwareConfiguration);

	WRITE_REG16 (hci, 0, HcDMAConfiguration);

	wait_ms (1000);

	if (hc_start (hci) < 0) {
		err ("can't start usb-%x", data_port);
		hc_release_hci (hci);
		return;
	}

  	fminterval = 0x2edf;
	fminterval |= ((((fminterval - 210) * 6) / 7) << 16);
	WRITE_REG32 (hci, fminterval, HcFmInterval);
	WRITE_REG32 (hci, 0x628, HcLSThreshold);

 	/* start controller operations */
 	hp->hc_control = OHCI_USB_OPER;
 	WRITE_REG32 (hci, hp->hc_control, HcControl);

	/* Choose the interrupts we care about now, others later on demand */
	mask = OHCI_INTR_MIE |
//	OHCI_INTR_ATD |
	OHCI_INTR_SO ;
//	OHCI_INTR_SF;
	WRITE_REG32 (hci, mask, HcInterruptEnable);
	WRITE_REG32 (hci, mask, HcInterruptStatus);

	mask = SOFITLInt | ATLInt | OPR_Reg;
	WRITE_REG16 (hci, mask, HcuPInterrupt);
	WRITE_REG16 (hci, mask, HcuPInterruptEnable);


#ifdef	OHCI_USE_NPS
	WRITE_REG32 (hci,(READ_REG32 (hci, HcRhDescriptorA) | RH_A_NPS) & ~RH_A_PSM,
		HcRhDescriptorA);
	WRITE_REG32 (hci, RH_HS_LPSC, HcRhStatus);
#endif	/* OHCI_USE_NPS */

	// POTPGT delay is bits 24-31, in 2 ms units.
	mdelay ((READ_REG32 (hci, HcRhDescriptorA) >> 23) & 0x1fe);
	printk (KERN_EMERG "Succeed in renew chip!!\n");

	return;
}

	
	

module_init (hci_hcd_init);
module_exit (hci_hcd_cleanup);


MODULE_AUTHOR ("Roman Weissgaerber <weissg@vienna.at>");
MODULE_DESCRIPTION ("USB ISP116x Host Controller Driver");
MODULE_LICENSE("GPL");
