
#define _DMX_MRG (0<<2) /* merging commands */
#define _DMX_RC  (1<<2) /* receiver commands */
#define _DMX_TX  (2<<2) /* transmitter commands */

#define _DMX_MEM       0
#define _DMX_STARTCODE 1
#define _DMX_SLOTS     2
#define _DMX_FRAMES    3

#define SERIAL_MAGIC_NUMBER (0x5a5a)
#define VALUE_BLOCKING      (0x0001)

/* 
 * USBDMX-VendorRequests
 */
#define DMX_MRG_MEM      (_DMX_MRG | _DMX_MEM)
#define DMX_TX_MEM       (_DMX_TX | _DMX_MEM)
#define DMX_TX_SLOTS     (_DMX_TX | _DMX_SLOTS)
#define DMX_TX_STARTCODE (_DMX_TX | _DMX_STARTCODE)
#define DMX_TX_FRAMES    (_DMX_TX | _DMX_FRAMES)
#define DMX_RC_MEM       (_DMX_RC | _DMX_MEM)
#define DMX_RC_SLOTS     (_DMX_RC | _DMX_SLOTS)
#define DMX_RC_STARTCODE (_DMX_RC | _DMX_STARTCODE)
#define DMX_RC_FRAMES    (_DMX_RC | _DMX_FRAMES)
#define DMX_SERIAL       (0x0c)

#define DMX_ERROR	 2

/*
 * IOCTLs
 */
#define DMX_MEM_MAP_SET      1
#define DMX_MEM_MAP_GET      2
#define DMX_TX_SLOTS_GET     3
#define DMX_TX_SLOTS_SET     4
#define DMX_TX_STARTCODE_GET 5
#define DMX_TX_STARTCODE_SET 6
#define DMX_TX_FRAMES_GET    7
#define DMX_RC_SLOTS_GET     8
#define DMX_RC_STARTCODE_GET 9
#define DMX_RC_STARTCODE_SET 10
#define DMX_RC_FRAMES_GET    11
#define DMX_SERIAL_GET       14
#define DMX_BLOCKING_GET     16
#define DMX_BLOCKING_SET     17
#define CONFIG_SET           18
