/* coherent hypertransport initialization for AMD64 
 *
 * tyan 2885 mainboard specific setup code from lyh
 * 
 * This code is licensed under GPL.
 */

static void coherent_ht_mainboard(unsigned cpus)
{
       static const unsigned int register_values[] = {
           PCI_ADDR(0, 0x18, 0, 0x84), 0x88ff9c05, 0x11000020,
           PCI_ADDR(0, 0x18, 0, 0xa4), 0x88ff9c05, 0x11000020,
           PCI_ADDR(0, 0x18, 0, 0xc4), 0x88ff9c05, 0x11000020,
           PCI_ADDR(0, 0x19, 0, 0x84), 0x88ff9c05, 0x770000d0,
           PCI_ADDR(0, 0x19, 0, 0xa4), 0x88ff9c05, 0x11000020,
           PCI_ADDR(0, 0x19, 0, 0xc4), 0x88ff9c05, 0x770000d0,

           PCI_ADDR(0, 0x18, 0, 0x88), 0xfffff0ff, 0x00000400,
           PCI_ADDR(0, 0x18, 0, 0xa8), 0xfffff0ff, 0x00000500,
           PCI_ADDR(0, 0x18, 0, 0xc8), 0xfffff0ff, 0x00000400,
           PCI_ADDR(0, 0x19, 0, 0x88), 0xfffff0ff, 0x00000000,
           PCI_ADDR(0, 0x19, 0, 0xa8), 0xfffff0ff, 0x00000500,
           PCI_ADDR(0, 0x19, 0, 0xc8), 0xfffff0ff, 0x00000000,

           PCI_ADDR(0, 0x18, 0, 0x94), 0xff0000ff, 0x00060000,
           PCI_ADDR(0, 0x18, 0, 0xb4), 0xff0000ff, 0x00000000,
           PCI_ADDR(0, 0x18, 0, 0xd4), 0xff0000ff, 0x00040000,
           PCI_ADDR(0, 0x19, 0, 0x94), 0xff0000ff, 0x00000000,
           PCI_ADDR(0, 0x19, 0, 0xb4), 0xff0000ff, 0x00000000,
           PCI_ADDR(0, 0x19, 0, 0xd4), 0xff0000ff, 0x00000000,
       };

       int i;
       int max;

       device_t dev;
       unsigned where;
       unsigned long reg;
	
       print_debug("setting up ht links....\r\n");
       max = sizeof(register_values)/sizeof(register_values[0]);
       for(i = 0; i < max; i += 3) {
#if 0
               print_debug_hex32(i);
               print_debug(": ");
               print_debug_hex32(register_values[i]);
               print_debug(" <-");
               print_debug_hex32(register_values[i+2]);
               print_debug("\r\n");
#endif
               dev = register_values[i] & ~0xff;
               where = register_values[i] & 0xff;
               reg = pci_read_config32(dev, where);
               reg &= register_values[i+1];
               reg |= register_values[i+2];
               pci_write_config32(dev, where, reg);
        }
	print_debug("done\r\n");

}
