package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

/**
 * This TokenMatcher checks whether its position is at a boundary of
 * the word. The boundary is the limit of the String object described
 * in the TransducerBuffer, <b>not</b> the word boundary (ie. it
 * does not check for a blank space or a carriage return).
 * */

public class BoundaryMatcher implements TokenMatcher
{
    boolean m_beginning;

    /**
     * To distinguish between the beginning and the ending boundaries,
     * the constructor needs a parameter specifying whether it shall
     * check for the beginning or the end of the string.
     * */

    public BoundaryMatcher(boolean beginning)
    {
	m_beginning = beginning;
    }

    public boolean matches(TransducerBuffer buffer, int index)
    {
	if (m_beginning)
	    {
		return index < 0;
	    }
	else
	    {
		return index >= (buffer.getInput().length());
	    }
    }

    public String toString()
    {
	return "[BOUNDARY]";
    }
}
