package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

/**
 * A very simple, yet necessary TokenMatcher implementation that
 * checks for a specific char in the TransducerBuffer.
 * */

public class CharMatcher implements TokenMatcher
{
    private char m_value;

    /**
     * Public Constructor.
     *
     * @param val the character to check.
     */ 
    
    public CharMatcher(char val)
    {
	m_value = val;
    }

    public boolean matches(TransducerBuffer buffer, int index)
    {
	try {
	    return buffer.getChar(index) == m_value;
	} catch (TransducerBuffer.OutOfBoundException oobe)
	    {
		return false;
	    }
    }

    public String toString()
    {
	return "`"+m_value+"'";
    }

    public char getChar()
    {
	return m_value;
    }

}
