package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

/**
 * The NegativeMatcher is a TokenMatcher that decorates another one,
 * and changes its result : true becomes false, and false become true.
 * */

public class NegativeMatcher implements TokenMatcher
{
    private TokenMatcher m_inner;
    
    /**
     * Public contructor.
     *@param val the TokenMatcher object to decorate
     */

    public NegativeMatcher(TokenMatcher val)
    {
	m_inner = val;
    }

    public boolean matches(TransducerBuffer buffer, int index)
    {
	return m_inner.matches(buffer,index)?false:true;
    }

    public String toString()
    {
	return "[NEGATION-OF]";
    }
}
