package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

import java.util.*;
import java.io.*;
import net.charabia.normalizer.parser.*;

/**
 * The Processor is the main object that transforms a string using a
 * set of transducers objects.
 *
 *  <p> Typically, one would create such an object once, and then use
 *  it to normalize strings all the program's life.
 *
 *  <tt>
 *  Processor proc = new Processor(); <br>
 *  TransducerParser parser = new TransducerParser(proc, new FileReader("format.trans"); <br>
 *  result = proc.process("hello");
 * </tt>
 */

public class Processor
{
    private Vector m_transducers = new Vector();

    /**
     * Public contructor. This has no argument. To add transducers
     * into it, call getNewTransducer(), then add rules to the
     * transducers returned.
     * 
     */
    
    public Processor()
    {
    }

    /**
     * Creates a new Transducer object, adds it to the processor, and
     * returns it. The transducer returned is empty.
     */

    public Transducer getNewTransducer()
    {
	Transducer t = new Transducer();
	m_transducers.add(t);
	return t;
    }

    public String process(String word)
    {
	for (Iterator i = m_transducers.iterator(); i.hasNext(); )
	    {
		Transducer t = (Transducer)i.next();
		word = t.process(word);
	    }
	return word;
    }

    public static void main(String[] args) throws Exception
    {
	if (args.length < 1) 
	    return;
	FileInputStream fin = new FileInputStream(args[0]);
	
	Processor proc = new Processor();
	TransducerParser parser = new TransducerParser(proc, fin);

	System.out.println("parsing...");
	parser.parse();
	System.out.println("parsing... OK");
	BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

	if (args.length == 2)
	    {
		StreamTokenizer stok = new StreamTokenizer(new BufferedReader(new FileReader(args[1])));
		stok.resetSyntax();
		stok.wordChars(33, 255);
		while (stok.nextToken() != stok.TT_EOF)
		    {
			String word = stok.sval;
			if (word != null)
			    word = proc.process(word);
			System.out.println(word);
		    }
		return;
	    }


	while (true)
	    {
		System.out.print("Enter a word: ");
		String line = reader.readLine();
		System.out.println("read: <" + line + ">");

		String result = proc.process(line);
		System.out.println("result: <" + result + ">");
	    }
    }
}
