package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

/**
 * Check for a set of chars at a TransducerBuffer position.
 *
 */ 

public class RangeMatcher implements TokenMatcher
{
    private char[] m_values;
    private boolean m_negate;

    /**
     * Public constructor.
     *
     * @param val a string that contains all the char to check
     * @param negate if true, the check is a negative check that returns true only if none of the chars are at the transducer position.  
     */
    public RangeMatcher(String val, boolean negate)
    {
	m_negate = negate;
	m_values = val.toCharArray();
    }

    public boolean matches(TransducerBuffer buffer, int index)
    {
	try {
	    char val = buffer.getChar(index);
	    for (int i=0; i<m_values.length; i++)
		{
		    if (m_values[i] == val)
			return m_negate?false:true;
		}
	    return m_negate?true:false;
	} catch (TransducerBuffer.OutOfBoundException oobe)
	    {
		return m_negate?true:false;
	    }
    }

    public String toString()
    {
	return "[range:"+m_negate+"/";
    }

    public boolean isNegative()
    {
	return m_negate;
    }
    
    public char[] getChars()
    {
	return m_values;
    }

}
