package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

/**
 * The TokenMatcher interface represents a test on a TransducerBuffer
 * position. 
 * */

public interface TokenMatcher
{
    /**
     * Tests on a TransducerBuffer position.
     *
     * @param buffer the TransducerBuffer
     * @param index the position to check in the TransducerBuffer
     * @return true if the test matches, false otherwise.
     */
    public boolean matches(TransducerBuffer buffer, int index);
}
