package net.charabia.normalizer;

/* ====================================================================
 * Copyright (c) 2002 Rodrigo Reyes.  All rights reserved.
 * ====================================================================
 */

import java.util.*;

/**
 * A TransducerBuffer stores a string that is to be processed by a
 * Transducer object, but also its current position and the output
 * string of the transducer.
 * */

public class TransducerBuffer
{
    public class OutOfBoundException extends RuntimeException
    {
    }

    private String m_input;
    private StringBuffer m_output = new StringBuffer();
    private int m_index = 0;

    public TransducerBuffer(String input)
    {
	m_input = input;
    }

    public String getInput()
    {
	return m_input;
    }

    public char getChar() throws TransducerBuffer.OutOfBoundException
    {
	try {
	    return m_input.charAt(m_index);
	} catch (java.lang.StringIndexOutOfBoundsException outofb)
	    {
		throw new TransducerBuffer.OutOfBoundException();
	    }
    }

    public char getChar(int index) throws TransducerBuffer.OutOfBoundException
    {
	try {
	    return m_input.charAt(index);
	} catch (StringIndexOutOfBoundsException outofb)
	    {
		throw new TransducerBuffer.OutOfBoundException();
	    }
    }

    public int getIndex()
    {
	return m_index;
    }

    public void setIndex(int index)
    {
	m_index = index;
    }

    public void inject(char c)
    {
	m_output.append(c);
    }

    public void inject(String cars)
    {
	m_output.append(cars);
    }

    public boolean isComplete()
    {
	if (m_index < m_input.length())
	    return false;
	return true;
    }

    public String getOutput()
    {
	return m_output.toString();
    }

}
