#include <stdio.h>
#include <stdlib.h>
class Link
	{
	friend class Container;
	protected:
	int dataType;
	void *data;
	Link *next;
	Link *getNext(int count)
		{
		if (count == 0)
			return this;
		else
			return next->getNext(count-1);
		}
	};

class Container
	{
	private:
	int numberOfElements;
	Link *firstLink;
	public:
	Container()
		{
		numberOfElements=0;
		firstLink=new Link;
		}
	~Container()
		{
		while(numberOfElements>0)
			{
			delete firstLink->getNext(numberOfElements);
			numberOfElements--;
			}
		}
	int getNumberOfElements()
		{
		return numberOfElements;
		}
	void *getElement(int position)
		{
		if(position > numberOfElements)
			return NULL;
		else
			return firstLink->getNext(position)->data;
		}
	int insertElement(void *elem)
		{
		Link *last;
		if (numberOfElements > 0)
			last = (Link *) firstLink->getNext(numberOfElements);
		else
			last = firstLink;
		Link *newLink = new Link;
		last->next = newLink;
		newLink->data = elem;
		numberOfElements++;
		return numberOfElements;
		}
	int insertElement(void *elem, int position)
		{
		Link *oldLink;
		Link *newLink;
		int temp;
		if( numberOfElements < position-1 || position < 1)
			return -1;
		else
			{
			newLink = new Link;
			newLink->data=elem;
			oldLink = (Link *) firstLink->getNext(position-1);
			temp=getDataType(position);
			newLink->next = oldLink->next;
			oldLink->next = newLink;
			setDataType(position+1,temp);
			numberOfElements++;
			return position;

			}
		}
	int insertElement(int type, void *elem)
		{
		int position;
		position=insertElement(elem);
		setDataType(position, type);
		return position;
		}
	int insertElement(int type, void *elem, int position)
		{
		position=insertElement(elem, position);
		if (position>0)
			setDataType(position, type);
		return position;
		}
	int removeElement(int position)
		{
		Link *elem;
		Link *pre;
		Link *temp;
		if (position > numberOfElements || position < 1)
			return -1;
		else
			{
			pre=firstLink->getNext(position-1);
			elem=pre->next;
			temp=elem->next;
			pre->next=temp;
			delete elem;
			return --numberOfElements;
			}
		}
	int removeElement(void *data)
		{
		int count=0;
		while(count < numberOfElements)
			{
			count++;
			if(getElement(count) == data)
				{
				return removeElement(count);
				break;
				}
			}
		return -1;

		}
	int modifyElement(void *elem, int position)
		{
			if (position > numberOfElements || position < 1)
				return -1;
			else
				{
				firstLink->getNext(position)->data = elem;
				return numberOfElements;
				}

		}
	int getDataType(int position)
		{
		if(position > 0 && position <= numberOfElements)
			return firstLink->getNext(position-1)->dataType;
		else
			return -1;
		}
	int setDataType(int position, int dtt)
		{
		if(position > 0 && position <= numberOfElements)
			{
			firstLink->getNext(position-1)->dataType=dtt;
			return dtt;
			}
		else
			return -1;
		}
	void *getName()
		{
		return firstLink->data;
		}
		
	void setName(void *name)
		{
		firstLink->data=name;
		}
	};
