#include "keybinder_GUI.h"
#include "keybinder_signal_handlers.h"




/* ---METHODS FOR GUI_KeyboardDrawing--- */

GUI_KeyboardDrawing::GUI_KeyboardDrawing(Keyboard *keyboard_, GtkWidget *embedIn)
	{
	printf("[DEBUG] Create GUI_KeyboardDrawing %p. keyboard: %p. embedIn: %p\n", this, keyboard_, embedIn);
	GtkWidget *buttonsBox, *addButton, *applyButton, *clearButton, *internalFrame;

	/*Initialize class variables*/
	this->subKeyBindDrawings=new Container();
	this->keyboard=keyboard_;

	/*Create widgets*/
	this->mainVbox=gtk_vbox_new(FALSE, 0);
	buttonsBox=gtk_hbutton_box_new();
	addButton=gtk_button_new_from_stock(GTK_STOCK_ADD);
	applyButton=gtk_button_new_from_stock(GTK_STOCK_APPLY);
	clearButton=gtk_button_new_from_stock(GTK_STOCK_CLEAR);
	this->keybindsArea=gtk_scrolled_window_new(NULL, NULL);
	gtk_container_set_border_width(GTK_CONTAINER(this->keybindsArea), 2);
	internalFrame=gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(internalFrame), GTK_SHADOW_NONE);
	this->scrolledVbox=gtk_vbox_new(FALSE, 4);
	gtk_container_set_border_width(GTK_CONTAINER(this->scrolledVbox), 8);

	/*Pack the widgets*/
	gtk_box_pack_start(GTK_BOX(this->mainVbox), this->keybindsArea, TRUE, TRUE, 0 );
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(this->keybindsArea), internalFrame );
	gtk_container_add(GTK_CONTAINER(internalFrame), this->scrolledVbox);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(this->keybindsArea), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(this->mainVbox), buttonsBox, FALSE, FALSE, 6 );
	gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonsBox), GTK_BUTTONBOX_SPREAD);
	gtk_container_add(GTK_CONTAINER(buttonsBox), addButton);
	gtk_container_add(GTK_CONTAINER(buttonsBox), applyButton);
	gtk_container_add(GTK_CONTAINER(buttonsBox), clearButton);

	/*Connect the bunttons singal*/
	g_signal_connect(GTK_OBJECT(addButton), "clicked", G_CALLBACK(S_KB_addButton), this);
	g_signal_connect(GTK_OBJECT(applyButton), "clicked", G_CALLBACK(S_KB_applyButton), keyboard);
	g_signal_connect(GTK_OBJECT(clearButton), "clicked", G_CALLBACK(S_KB_clearButton), this);

	/*Create children*/
	int count=0;
	int NOE=keyboard->getNumberOfElements();
	while (count < NOE)
		{
		count++;
 		this->insertKeyBindDrawing(new GUI_KeyBindDrawing((KeyBind*)keyboard->getElement(count)));
		}

	/*Show the widgets*/
	gtk_widget_show_all(this->mainVbox);
	gtk_container_add(GTK_CONTAINER(embedIn), this->mainVbox);
	}

GUI_KeyboardDrawing::~GUI_KeyboardDrawing()
	{
	printf("[DEBUG] Delete GUI_KeyboardDrawing %p\n", this);

	/*Delete children KeyBinds*/
	int NOE=this->subKeyBindDrawings->getNumberOfElements();
	while(NOE>0)
		{
		delete (GUI_KeyBindDrawing*)(subKeyBindDrawings->getElement(NOE));
		NOE--;
		}
	delete this->subKeyBindDrawings;

	/*Delete children for free memory*/
	this->clear();

	/*Destroy the window*/
	gtk_widget_destroy(this->mainVbox);
	}

void GUI_KeyboardDrawing::insertKeyBindDrawing(GUI_KeyBindDrawing *drawing) //Insert a child GUI_KeyBindDrawing
	{
	gtk_box_pack_start(GTK_BOX(this->scrolledVbox), drawing->frame, FALSE, FALSE, 0);
	drawing->setParentDrawing(this);
	this->subKeyBindDrawings->insertElement((void*)drawing);
	}

void GUI_KeyboardDrawing::removeKeyBindDrawing(GUI_KeyBindDrawing *drawing) //Remove a child GUI_KeyBindDrawing. This doesn't destroy it.
	{
	this->subKeyBindDrawings->removeElement(drawing);
	}

void GUI_KeyboardDrawing::newKeyBind() //Create a child GUI_KeyBindDrawing
	{
	/*Create the new KeyBind and insert it*/
	KeyBind *keybind = new KeyBind(this->keyboard);
	keyboard->insertElement(KEYBIND, (void*)keybind);

	/*Create the drawing and insert it*/
	GUI_KeyBindDrawing *drawing = new GUI_KeyBindDrawing(keybind);
	this->insertKeyBindDrawing(drawing);

	/*Scroll the window to bottom*/
	GtkAdjustment *adjustment = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(this->keybindsArea));
	adjustment->value = adjustment->upper;

	/*Show the editor for the new KeyBind*/
	drawing->showEditor();
	}

void GUI_KeyboardDrawing::clear() //Delete all children keybinds
	{
	/*Delete children GUI_KeyBindDrawings*/
	int NOE=this->subKeyBindDrawings->getNumberOfElements();
	while(NOE>0)
		{
		delete (GUI_KeyBindDrawing*)(subKeyBindDrawings->getElement(NOE));
		subKeyBindDrawings->removeElement(NOE);
		NOE--;
		}

	/*Delete children KeyBinds*/
	this->keyboard->clear();
	}




/* ---METHODS FOR GUI_KeyBindDrawing--- */

GUI_KeyBindDrawing::GUI_KeyBindDrawing(KeyBind *keyBind_)
	{
	printf("[DEBUG] Create GUI_KeyBindDrawing %p. keybind: %p\n", this, keyBind_);
	GtkWidget *hseparator, *expander, *fixBox;

	/*Set class variable values*/
	this->keybind=keyBind_;
	this->labelHbox=NULL;
	this->editor=NULL;
	this->subKeyBindDrawings=new Container();
	this->subActionDrawings=new Container();
	this->parentDrawingType=CONTAINER_DATA_TYPE_UNDEFINED;
	this->frame=gtk_frame_new(NULL);

	/*Create the GUI widgets*/
	fixBox=gtk_hbox_new(FALSE, 0);
	keybindVbox=gtk_vbox_new(FALSE, 0);
	expander=gtk_expander_new(NULL);
	hseparator=gtk_hseparator_new();
	alignedBox=gtk_vbox_new(FALSE, 1);

	/*Set its properties*/
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
	gtk_expander_set_expanded(GTK_EXPANDER(expander), TRUE);

	/*Pack them*/
	gtk_container_add(GTK_CONTAINER(frame), keybindVbox);
	gtk_box_pack_end(GTK_BOX(keybindVbox), expander, FALSE, FALSE, 3);
	gtk_container_add(GTK_CONTAINER(expander), fixBox);
	gtk_box_pack_start(GTK_BOX(fixBox), gtk_label_new(NULL), FALSE, FALSE, 10 ); //This is a hack for put an identation
	gtk_box_pack_start(GTK_BOX(fixBox), alignedBox, TRUE, TRUE, 3 );

	/*Insert children*/
	int count=0;
	int NOE=keybind->getNumberOfElements();
	while (count < NOE)
		{
		count++;
		switch(keybind->getDataType(count))
			{
			case KEYBIND:
	 			this->insertKeyBindDrawing(new GUI_KeyBindDrawing((KeyBind*)keybind->getElement(count)));
				break;
			case ACTION:
	 			this->insertActionDrawing(new GUI_ActionDrawing((Action*)keybind->getElement(count)));
				break;
			}
		}

	/*Draw the buttons header*/
	drawHeader();

	/*Show the main widget*/
	gtk_widget_show_all(this->frame);
	}

GUI_KeyBindDrawing::~GUI_KeyBindDrawing()
	{
	printf("[DEBUG] Delete GUI_KeyBindDrawing %p\n", this);

	/*Delete the GUI_KeyBindEditor (if any)*/
	if(this->editor != NULL)
		{
		this->editor->disconnectDestroyHandler();
		delete this->editor;
		}

	/*Delete children GUI_KeyBindDrawings*/
	int NOE=this->subKeyBindDrawings->getNumberOfElements();
	while(NOE>0)
		{
		delete (GUI_KeyBindDrawing*)(subKeyBindDrawings->getElement(NOE));
		NOE--;
		}
	delete this->subKeyBindDrawings;

	/*Delete children GUI_ActionDrawings*/
	NOE=this->subActionDrawings->getNumberOfElements();
	while(NOE>0)
		{
		delete (GUI_ActionDrawing*)(this->subActionDrawings->getElement(NOE));
		NOE--;
		}
	delete this->subActionDrawings;

	/*Destroy main widget*/
	gtk_widget_destroy(this->frame);

	/*Remove itself from its parent*/
	switch(this->parentDrawingType)
		{
		case KEYBIND:
			((GUI_KeyBindDrawing*)(this->parentDrawing))->removeKeyBindDrawing(this);
			break;
		case KEYBOARD: 
			((GUI_KeyboardDrawing*)(this->parentDrawing))->removeKeyBindDrawing(this);
		default:
			break;
		}
	}

void GUI_KeyBindDrawing::drawHeader() //Draw or redraw the key combination buttons (eg: ctrl+alt+4)
	{
	GtkWidget *label;
	char *keys;

	/*Delete the previous header (if any)*/
	if(labelHbox != NULL)
		gtk_widget_destroy(labelHbox);

	/*Create new Hbox*/
	labelHbox=gtk_hbox_new(FALSE, 2);

	/*Create and insert the buttons*/
	if(keybind->getName() != NULL)
		{
		keys=(char*)keybind->getName();
		int count=0;
		while(keys[count] != '\0')
			{
			if(keys[count+1] == '-')
				{
				if( keys[count]=='C')
					label=gtk_button_new_with_label("Ctrl");
				else if( keys[count]=='S')
					label=gtk_button_new_with_label("Shift");
				else if( keys[count]=='A')
					label=gtk_button_new_with_label("Alt");
				else if( keys[count]=='W')
					label=gtk_button_new_with_label("Win");
				else if( keys[count]=='M')
					label=gtk_button_new_with_label("Meta");

 				g_signal_connect(GTK_OBJECT(label), "clicked", G_CALLBACK(S_KD_menuKeyBindButton), this);
				gtk_box_pack_start(GTK_BOX(labelHbox), label, FALSE, FALSE, 0);
				label=gtk_label_new("+");
				gtk_box_pack_start(GTK_BOX(labelHbox), label, FALSE, FALSE, 3);
				count=count+2;
				}
			else 
				{
				label=gtk_button_new_with_label(keys+count);
 				g_signal_connect(GTK_OBJECT(label), "clicked", G_CALLBACK(S_KD_menuKeyBindButton), this);
				gtk_box_pack_start(GTK_BOX(labelHbox), label, FALSE, FALSE, 0);
				break;
				}
			}
		}

	/*Show the widgets*/
	gtk_widget_show_all(labelHbox);
	gtk_box_pack_start(GTK_BOX(keybindVbox), labelHbox, FALSE, FALSE, 0);
	}

void GUI_KeyBindDrawing::showEditor() //Show a GUI_KeyBindEditor for editing the KeyBind
	{
	if(this->editor == NULL)
		this->editor=new GUI_KeyBindEditor(this);
	}

void GUI_KeyBindDrawing::showMenu() //Show an options menu
	{
	new GUI_KeyBindMenu(this);
	}

void GUI_KeyBindDrawing::insertKeyBindDrawing(GUI_KeyBindDrawing *drawing) //Insert a child GUI_KeyBindDrawing
	{
	this->subKeyBindDrawings->insertElement(drawing);
	drawing->setParentDrawing(this);
	gtk_box_pack_start(GTK_BOX(this->alignedBox), drawing->frame, TRUE, TRUE, 0);
	}

void GUI_KeyBindDrawing::insertActionDrawing(GUI_ActionDrawing *drawing) //Insert a child GUI_ActionDrawing
	{
	this->subActionDrawings->insertElement(drawing);
	drawing->setParentDrawing(this);
	gtk_box_pack_start(GTK_BOX(this->alignedBox), drawing->frame, FALSE, FALSE, 0);
	}

void GUI_KeyBindDrawing::removeKeyBindDrawing(GUI_KeyBindDrawing *drawing) //Remove a child GUI_KeyBindDrawing. This doesn't destroy it.
	{
	this->subKeyBindDrawings->removeElement(drawing);
	}

void GUI_KeyBindDrawing::removeActionDrawing(GUI_ActionDrawing *drawing) //Remove a child GUI_ActionDrawing. This doesn't destroy it.
	{
	this->subActionDrawings->removeElement(drawing);
	}

void GUI_KeyBindDrawing::unsetEditor(GUI_KeyBindEditor *_editor) //Set the editor pointer to NULL. (Call this when destroy the editor)
	{
	if(_editor == this->editor)
		this->editor=NULL;
	}

void GUI_KeyBindDrawing::setParentDrawing(GUI_KeyboardDrawing *keybinder) //Set the parent GUI_KeyboardDrawing
	{
	if(this->parentDrawingType != CONTAINER_DATA_TYPE_UNDEFINED)
		{
		this->parentDrawingType=KEYBOARD;
		this->parentDrawing=(void*)keybinder;
		}
	}

void GUI_KeyBindDrawing::setParentDrawing(GUI_KeyBindDrawing *keybind) //Set the parent GUI_KeyBindDrawing
	{
	if(this->parentDrawingType != CONTAINER_DATA_TYPE_UNDEFINED)
		{
		this->parentDrawingType=KEYBIND;
		this->parentDrawing=(void*)keybind;
		}
	}




/* ---METHODS FOR GUI_ActionDrawing--- */

GUI_ActionDrawing::GUI_ActionDrawing(Action *_action)
	{
	printf("[DEBUG] Create GUI_ActionDrawing %p. action: %p\n", this, _action);
	GtkWidget *actionButton, *buttonImage, *label;

	/*Set class variable values*/
	this->action=_action;
	this->editor=NULL;
	this->frame=gtk_hbox_new(FALSE, 0);

	/*Create the button*/
	actionButton=gtk_button_new();
	buttonImage=gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_container_add(GTK_CONTAINER(actionButton), buttonImage);
	g_signal_connect(GTK_OBJECT(actionButton), "clicked", G_CALLBACK(S_AD_menuActionButton), this );
	gtk_box_pack_start(GTK_BOX(this->frame), actionButton, FALSE, FALSE, 0);

	/*Create the description label*/
	char *labelText=NULL;
	if(action->type != 0) //Search for a description in actionModel[]
		labelText=(char*)actionModel[action->type][MODEL_DESCRIPTION];
	if(labelText == NULL)
		label=gtk_label_new((char*)action->getName()); //If not found, write the action name as description
	else
		label=gtk_label_new(labelText); //If found, write it
	gtk_box_pack_start(GTK_BOX(this->frame), label, FALSE, FALSE, 0);

	/*Show the main frame*/
	gtk_widget_show_all(this->frame);
	}

GUI_ActionDrawing::~GUI_ActionDrawing()
	{
	printf("[DEBUG] Delete GUI_ActionDrawing %p\n", this);

	/*Remove itself from its parent*/
	switch(this->parentDrawingType)
		{
		case KEYBIND:
			((GUI_KeyBindDrawing*)(this->parentDrawing))->removeActionDrawing(this);
			break;
		case FINALACTIONSLIST:
			((GUI_ActionEditor*)(this->parentDrawing))->removeActionDrawing(this);
			break;
		default:
			break;
		}

	/*Delete the GUI_ActionDrawing (if any)*/
	if(this->editor != NULL)
		{
		this->editor->disconnectDestroyHandler();
		delete this->editor;
		}

	/*Destroy the main frame*/
	gtk_widget_destroy(this->frame);
	}

void GUI_ActionDrawing::showMenu() //Show an options menu
	{
	new GUI_ActionMenu(this);
	}

void GUI_ActionDrawing::showEditor() //Show a GUI_KeyBindEditor for editing the KeyBind
	{
	if(this->editor == NULL)
		this->editor = new GUI_ActionEditor(this);
	}

void GUI_ActionDrawing::unsetEditor(GUI_ActionEditor *_editor) //Set the editor pointer to NULL. (Call this when destroy the editor)
	{
	if(_editor == this->editor)
		this->editor=NULL;
	}

void GUI_ActionDrawing::setParentDrawing(GUI_KeyBindDrawing *keybind) //Set the parent GUI_KeyBindDrawing
	{
	if(this->parentDrawingType != CONTAINER_DATA_TYPE_UNDEFINED)
		{
		this->parentDrawingType=KEYBIND;
		this->parentDrawing=(void*)keybind;
		}
	}

void GUI_ActionDrawing::setParentDrawing(GUI_ActionEditor *editor) //Set the parent GUI_ActionEditor (If the Action is inside a FinalActionsList)
	{
	if(this->parentDrawingType != CONTAINER_DATA_TYPE_UNDEFINED)
		{
		this->parentDrawingType=FINALACTIONSLIST;
		this->parentDrawing=(void*)editor;
		}
	}





/* ---METHODS FOR GUI_KeyBindEditor--- */

GUI_KeyBindEditor::GUI_KeyBindEditor(GUI_KeyBindDrawing *drawing_)
	{	
	printf("[DEBUG] Create GUI_KeyBindEditor %p. drawing: %p\n", this, drawing_);
	GtkWidget *mainVbox, *keysBox, *buttonsBox, *okButton;
	GList *comboList;
	char* keys;

	/*Set class variable values*/
	this->callerDrawing=drawing_;
	this->keybind=callerDrawing->keybind;

	/*Create the editor window*/
	this->window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(this->window), 5);
	gtk_window_set_position(GTK_WINDOW(this->window), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(this->window), "Edit Keybind");

	/*Create widgets*/
	mainVbox=gtk_vbox_new(FALSE, 10);
	keysBox=gtk_hbox_new(FALSE, 3);
	ctrl=gtk_toggle_button_new_with_label("Ctrl");
	shift=gtk_toggle_button_new_with_label("Shift");
	alt=gtk_toggle_button_new_with_label("Alt");
	super=gtk_toggle_button_new_with_label("Win");
	meta=gtk_toggle_button_new_with_label("Meta");
	buttonsBox=gtk_hbutton_box_new();
	okButton=gtk_button_new_from_stock(GTK_STOCK_OK);
	combo=gtk_combo_new();
	comboList=NULL;

	/*Create the keylist*/
	const char *keyList[] = { "q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "a", "s", "d", "f", "g", "h", "j", "k", "l", "z", "x", "c", "v", "b", "n", "m", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "Insert", "Home", "Prior", "Delete", "End", "Next", "Left", "Right", "Up", "Down", "Return", "Backspace", "KP_1", "KP_2", "KP_3", "KP_4", "KP_5", "KP_6", "KP_7", "KP_8", "KP_9", "KP_0", "KP_Decimal", "KP_Enter", "KP_Add", "KP_Substract","KP_Multiply", "KP_Divide", NULL };
	/*insert the keys from the list into the combobox*/
	int count=0;
	while(keyList[count] != NULL)
		{
		comboList=g_list_append(comboList, (void*)keyList[count]);
		count++;
		}
	/*Set the combo options*/
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), comboList);
	gtk_combo_set_use_arrows(GTK_COMBO (combo), TRUE);

	/*Pack the widgets*/
	gtk_container_add(GTK_CONTAINER(window), mainVbox);
	gtk_box_pack_start(GTK_BOX(mainVbox), combo, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mainVbox), keysBox, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(keysBox), ctrl, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(keysBox), shift, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(keysBox), alt, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(keysBox), super, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(keysBox), meta, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mainVbox), buttonsBox, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(buttonsBox), okButton, FALSE, FALSE, 0);

	/*Set the initial value for the widgets*/
	if(this->keybind->getName() != NULL && strlen((char*)this->keybind->getName()) > 0 )
		{
		keys=(char*)this->keybind->getName();
		int count=0;
		while(keys[count] != '\0')
			{
			if(keys[count+1] == '-')
				{
				/*Set the widget for the modifier keys*/
				if( keys[count]=='C')
					{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ctrl), TRUE);
					count=count+2;
					}
				else if( keys[count]=='S')
					{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(shift), TRUE);
					count=count+2;
					}
				else if( keys[count]=='A')
					{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(alt), TRUE);
					count=count+2;
					}
				else if( keys[count]=='W')
					{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(super), TRUE);
					count=count+2;
					}
				else if( keys[count]=='M')
					{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(meta), TRUE);
					count=count+2;
					}
				}
			else 
				{
				/*Set the combo entry value*/
				gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), keys+count );
				break;
				}
			}
		}

	/*Connect the signals for close the window*/
	this->destroyHandler=g_signal_connect(GTK_OBJECT(window), "destroy", G_CALLBACK(S_KE_okButton), this);
	g_signal_connect_swapped(GTK_OBJECT(okButton), "clicked", G_CALLBACK(gtk_widget_destroy), window);

	/*Show the editor window*/
	gtk_widget_show_all(window);
	}

GUI_KeyBindEditor::~GUI_KeyBindEditor()
	{
	/*NOTE: When the Editor is destroy, the KeyBind is updated*/
	printf("[DEBUG] Delete GUI_KeyBindEditor %p\n", this);

	/*Read the new KeyBind value from the widget status, and save it in tempString*/
	char* tempString=(char*)malloc(12+strlen(gtk_entry_get_text(GTK_ENTRY (GTK_COMBO(this->combo)->entry)))); //The twelve is for leave space for the modifiers
	tempString[0]='\0';
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(this->ctrl))) strcat(tempString, "C-");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(this->shift))) strcat(tempString, "S-");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(this->alt))) strcat(tempString, "A-");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(this->super))) strcat(tempString, "W-");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(this->meta))) strcat(tempString, "M-");
	if( gtk_entry_get_text(GTK_ENTRY (GTK_COMBO(this->combo)->entry))[0] == '\0' )
		strcat(tempString, "  ");
	else
		strcat(tempString, gtk_entry_get_text(GTK_ENTRY (GTK_COMBO(this->combo)->entry)));
	/*Update the KeyBind value*/
	free( this->keybind->getName() ); //Delete the previous keybind;
	this->keybind->setName(tempString);

	/*Update the GUI_KeyBind button header*/
	this->callerDrawing->drawHeader();

	/*Remove itself from the caller GUI_KeyBindDrawing*/
	this->callerDrawing->unsetEditor(this);

	/*Destroy the editor window*/
	gtk_widget_destroy(this->window);
	}

void GUI_KeyBindEditor::disconnectDestroyHandler() //Disconnect the window "destroy" singal
	{
	g_signal_handler_disconnect(GTK_OBJECT(this->window), this->destroyHandler);
	}




/* ---METHODS FOR GUI_ActionEditor--- */

GUI_ActionEditor::GUI_ActionEditor(GUI_ActionDrawing *drawing)
	{
	printf("[DEBUG] Create GUI_ActionEditor %p. drawing: %p\n", this, drawing);
	char *title2;
	int count;
	int NOE;
	Parameter *thisParameter;
	Container *descriptions;
	StartupNotify *thisStartupNotify;
	GtkWidget *mainVbox, *titleFrame, *settingsBox, *buttonsBox, *okButton, *tempWidget, *tempWidget2, *tempWidget3, *tempWidget4;
	GtkWidget *finalActionsListFrame, *finalActionsListAddButton;

	/*Set class variable values*/
	this->action=drawing->action;
	this->callerDrawing=drawing;
	this->parameterList = new Container();
	this->editableWidgets = new Container();
	this->st_Widgets = NULL;
	this->subActionDrawings=new Container();

	/*Create a container for store the descriptions*/
	descriptions = new Container();

	/*Set the window subtitle*/
 	if(action->type != 0)
 		title2 = (char*)actionModel[action->type][MODEL_DESCRIPTION];
	else
		title2  = (char*) action->getName();

	/*Create the editor window*/
	/*Create the editor widgets*/
	this->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(this->window), "Edit action settings" );
	gtk_container_set_border_width(GTK_CONTAINER(this->window), 5);
	mainVbox = gtk_vbox_new(FALSE, 0);
	titleFrame = gtk_frame_new(title2);
	settingsBox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(settingsBox), 5);
	buttonsBox = gtk_vbutton_box_new();
	okButton = gtk_button_new_from_stock(GTK_STOCK_OK);
	/*Pack them*/
	gtk_container_add(GTK_CONTAINER(window), mainVbox );
	gtk_box_pack_start(GTK_BOX(mainVbox), titleFrame, FALSE, FALSE, 10);
	gtk_container_add(GTK_CONTAINER(titleFrame), settingsBox );
	gtk_box_pack_end(GTK_BOX(mainVbox), buttonsBox, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(buttonsBox), okButton, TRUE, FALSE, 0);
	/*Connect its signals*/
	this->destroyHandler = g_signal_connect(GTK_OBJECT(window), "destroy", G_CALLBACK(S_AE_okButton), this);
	g_signal_connect_swapped(GTK_OBJECT(okButton), "clicked", G_CALLBACK(gtk_widget_destroy), window);

	/*Create the widgets for editing the Parameters*/
	count=0;
	NOE=action->getNumberOfElements();
	while(count < NOE)
		{
		count++;
		thisParameter=(Parameter*)action->getElement(count);
		parameterList->insertElement(thisParameter); //Insert this parameter in parameterList
		descriptions->insertElement(action->getParameterDescription(thisParameter->name)); //Set the description
		switch(thisParameter->type)
			{
			case BOOLEAN:
			/*If the parameter is boolean, create a checkbox to edit it*/
				/*Create the checkbox and pack it*/
				tempWidget=gtk_check_button_new_with_label((char*)descriptions->getElement(count));
				gtk_box_pack_start(GTK_BOX(settingsBox), GTK_WIDGET(tempWidget), FALSE, FALSE, 3);
				/*Add it to editableWidgets*/
				editableWidgets->insertElement((void*)tempWidget);
				/*Set its initial value*/
				if(thisParameter->value.asBoolean == DISABLED)
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tempWidget), FALSE);
				else
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tempWidget), TRUE);

				break;

			case STRING:
			/*If parameter is a string, create an entry widget to edit it*/
				/*Create an hbox*/
				tempWidget2=gtk_hbox_new(FALSE,0);
				gtk_box_pack_start(GTK_BOX(settingsBox), GTK_WIDGET(tempWidget2), FALSE, FALSE, 3);
				/*Create a description and insert it in the hbox*/
				tempWidget=gtk_label_new((char*)descriptions->getElement(count));
				gtk_label_set_line_wrap (GTK_LABEL(tempWidget),TRUE);
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), TRUE, FALSE, 5);
				/*Create the entry and insert it in the hbox*/
				tempWidget=gtk_entry_new();
				editableWidgets->insertElement(tempWidget);
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), FALSE, FALSE, 5);
				/*Set its initial value*/
				gtk_entry_set_text(GTK_ENTRY(tempWidget), thisParameter->value.asString );

				break;

			case NUMBER:
			/*If parameter is a numeric value, create a spinbox to edit it*/
				/*Create an hbox*/
				tempWidget2=gtk_hbox_new(FALSE,0);
				gtk_box_pack_start(GTK_BOX(settingsBox), GTK_WIDGET(tempWidget2), FALSE, FALSE, 3);
				/*Create a description and insert it in the hbox*/
				tempWidget=gtk_label_new((char*)descriptions->getElement(count));
				gtk_label_set_line_wrap (GTK_LABEL(tempWidget),TRUE);
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), TRUE, FALSE, 5);
				/*Create the spinbox and insert it in the hbox*/
				tempWidget=gtk_spin_button_new(NULL, (gdouble)1, (guint)0 );
				((GtkSpinButton*)tempWidget)->adjustment->upper = 99999;
				((GtkSpinButton*)tempWidget)->adjustment->lower = -99999;
				((GtkSpinButton*)tempWidget)->adjustment->step_increment = 1;
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), FALSE, FALSE, 5);
				/*Set its initial value*/
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(tempWidget), (gdouble)thisParameter->value.asInt );
				/*Insert it in editableWidgets*/
				editableWidgets->insertElement(tempWidget);
				break;

			case EDGE:
			/*If parameter is an edge, create a table with buttons*/
				/*Create an hbox*/
				tempWidget=gtk_hbox_new(FALSE, 20);
				gtk_box_pack_start(GTK_BOX(settingsBox), GTK_WIDGET(tempWidget), FALSE, FALSE, 3);
				/*Create a description and insert it in the hbox*/
				tempWidget2=gtk_label_new((char*)descriptions->getElement(count));
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget2), TRUE, FALSE, 0);
				/*Create the table*/
				tempWidget2=gtk_table_new(3,3,TRUE);
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget2), FALSE, FALSE, 0);
				/*Create a label for save the selected value*/
				tempWidget3=gtk_label_new(NULL); //This label is for save the selected value
				/*Set its initial value*/
				switch(thisParameter->value.asEdge)
					{
					case BOTTOMLEFT:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW1);
						break;
					case BOTTOM:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW2);
						break;
					case BOTTOMRIGHT:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW3);
						break;
					case LEFT:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW4);
						break;
					case RIGHT:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW6);
						break;
					case TOPLEFT:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW7);
						break;
					case TOP:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW8);
						break;
					case TOPRIGHT:
						gtk_label_set_text(GTK_LABEL(tempWidget3), ARROW9);
						break;
					default:
						break;
					}
				/*Insert it in editableWidgets*/
				editableWidgets->insertElement((void*)tempWidget3);
				/*Insert it in the table*/
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget3, 1, 2, 1, 2);

				/*Create the buttons and insert them in the table*/
				tempWidget=gtk_button_new_with_label(ARROW1);
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 0, 1, 2, 3);

				tempWidget=gtk_button_new_with_label(ARROW2);
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 1, 2, 2, 3);

				tempWidget=gtk_button_new_with_label(ARROW3);
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 2, 3, 2, 3);

				tempWidget=gtk_button_new_with_label(ARROW4);
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 0, 1, 1, 2);

				tempWidget=gtk_button_new_with_label(ARROW6);
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 2, 3, 1, 2);

				tempWidget=gtk_button_new_with_label(ARROW7);
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 0, 1, 0, 1);

				tempWidget=gtk_button_new_with_label(ARROW8);
				
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 1, 2, 0, 1);

				tempWidget=gtk_button_new_with_label(ARROW9);
				
				g_signal_connect(GTK_OBJECT(tempWidget), "clicked", G_CALLBACK(S_AE_edgeButton), tempWidget3);
				gtk_table_attach_defaults(GTK_TABLE(tempWidget2), tempWidget, 2, 3, 0, 1);

				break;
				
			case STARTUPNOTIFY:
			/*If parameter is a StartupNotify:*/
				/*Create a container for save the subParameters*/
				st_Widgets = new Container();
				/*Insert it in editableWidets*/
				editableWidgets->insertElement((void*)st_Widgets);
				/*Cast thisParameter to StartupNotify*/
				thisStartupNotify = (StartupNotify*) thisParameter;

				/*Checkbox for enable/disabe the notification*/
				tempWidget=gtk_check_button_new_with_label("Enable startup notification");
				st_Widgets->insertElement((void*)tempWidget);
				if(thisStartupNotify->st_enabled == ENABLED)
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tempWidget), TRUE);
				gtk_box_pack_start(GTK_BOX(settingsBox), GTK_WIDGET(tempWidget), FALSE, FALSE, 3);

				/*Decorative frame*/
				tempWidget=gtk_frame_new("Startup Notification");
				gtk_box_pack_start(GTK_BOX(settingsBox), GTK_WIDGET(tempWidget), FALSE, FALSE, 3);

				/*Vbox for put the subparameters*/
				tempWidget2=gtk_vbox_new(FALSE, 3);
				gtk_container_add(GTK_CONTAINER(tempWidget), GTK_WIDGET(tempWidget2));

				/*Hbox for put an icon image*/
				tempWidget=gtk_hbox_new(FALSE, 5);
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), FALSE, FALSE, 3);
				/*Icon label*/
				tempWidget3=gtk_label_new("Icon: ");
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget3), TRUE, FALSE, 0);
				/*Icon filechooser button*/
				tempWidget3=gtk_file_chooser_button_new("Select icon file", GTK_FILE_CHOOSER_ACTION_OPEN);
				st_Widgets->insertElement((void*)tempWidget3);
				if( (thisStartupNotify->st_icon != NULL) && (strlen(thisStartupNotify->st_icon) > 0))
					gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(tempWidget3), thisStartupNotify->st_icon);
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget3), TRUE, TRUE, 3);
				/*Icon image*/
				tempWidget4=gtk_image_new_from_stock(GTK_STOCK_FILE, GTK_ICON_SIZE_LARGE_TOOLBAR);
				if( (thisStartupNotify->st_icon != NULL) && (strlen(thisStartupNotify->st_icon) > 0) )
					gtk_image_set_from_file(GTK_IMAGE(tempWidget4), thisStartupNotify->st_icon);
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget4), FALSE, FALSE, 3);
				/*Connect the signal to update the icon*/
				g_signal_connect(GTK_OBJECT(tempWidget3), "file-set", G_CALLBACK(S_AE_st_icon), tempWidget4);

				/*Hbox for put a name entry*/
				tempWidget=gtk_hbox_new(FALSE, 5);
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), FALSE, FALSE, 0);
				/*Name label*/
				tempWidget3=gtk_label_new("Name (show in task bar): ");
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget3), TRUE, FALSE, 0);
				/*Name entry*/
				tempWidget3=gtk_entry_new();
				st_Widgets->insertElement((void*)tempWidget3);
				if( (thisStartupNotify->st_name != NULL) && (strlen(thisStartupNotify->st_name) > 0 ))
					gtk_entry_set_text(GTK_ENTRY(tempWidget3), thisStartupNotify->st_name);
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget3), FALSE, FALSE, 0);

				/*Hbox for put a WM_CLASS ENTRY*/
				tempWidget=gtk_hbox_new(FALSE, 5);
				gtk_box_pack_start(GTK_BOX(tempWidget2), GTK_WIDGET(tempWidget), FALSE, FALSE, 0);
				/*Label*/
				tempWidget3=gtk_label_new("WM_CLASS: ");
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget3), TRUE, FALSE, 0);
				/*Entry*/
				tempWidget3=gtk_combo_new();
				st_Widgets->insertElement( (void*)((GTK_COMBO(tempWidget3))->entry) );
				if( (thisStartupNotify->st_wmclass != NULL) && (strlen(thisStartupNotify->st_wmclass)>0) )
					gtk_entry_set_text(GTK_ENTRY( (GTK_COMBO (tempWidget3)->entry) ), thisStartupNotify->st_wmclass);
				gtk_box_pack_start(GTK_BOX(tempWidget), GTK_WIDGET(tempWidget3), FALSE, FALSE, 0);
				
				break;

			default:
				break;
			}
		}

	/*If the action has final actions list, draw it*/
	if(this->action->finalActionsList != NULL)
		{
		finalActionsListFrame = gtk_frame_new("Final actions");
		finalActionsArea = gtk_vbox_new(FALSE, 0);
		finalActionsListAddButton = gtk_button_new_from_stock(GTK_STOCK_ADD);

		gtk_box_pack_start(GTK_BOX(settingsBox), finalActionsListFrame, FALSE, FALSE, 0);
		gtk_container_add(GTK_CONTAINER(finalActionsListFrame), finalActionsArea);
		gtk_box_pack_end(GTK_BOX(finalActionsArea), finalActionsListAddButton, FALSE, FALSE, 0);
		g_signal_connect(GTK_OBJECT(finalActionsListAddButton), "clicked", G_CALLBACK(S_AE_addActionButton), this );

		/*Insert the children actions*/
		count=0;
		NOE=action->finalActionsList->getNumberOfElements();
		while (count < NOE)
			{
			count++;
			if(action->finalActionsList->getDataType(count) == ACTION)
				this->insertActionDrawing(new GUI_ActionDrawing((Action*)action->finalActionsList->getElement(count)));
			}

		}

	/*Show the editor window*/
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_widget_show_all(window);
	}

GUI_ActionEditor::~GUI_ActionEditor()
	{
	printf("[DEBUG] Delete GUI_ActionEditor %p\n", this);
	int NOE = this->parameterList->getNumberOfElements();
	int count=0;
	char *tmpString;
	Parameter *thisParameter;

	/*Update the Parameters for the Action*/
 	while( count < NOE )
 		{
 		count++;
 		thisParameter = (Parameter*) this->parameterList->getElement(count);
 		switch(thisParameter->type)
 			{
 			case STRING:
 				tmpString = (char*) gtk_entry_get_text( GTK_ENTRY( this->editableWidgets->getElement(count) ) );
 				free(thisParameter->value.asString); //Delete the previous value
 				thisParameter->value.asString = (char*)malloc(1+strlen(tmpString)); //Allocate memory to save the new value
 				strcpy(thisParameter->value.asString, tmpString); //Set the value
 				break;
 			case NUMBER:
 				thisParameter->value.asInt=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(this->editableWidgets->getElement(count))); //Set the value
 				break;
 			case BOOLEAN:
				/*Set the value*/
 				if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(this->editableWidgets->getElement(count))) == TRUE )
 					thisParameter->value.asBoolean=ENABLED;
 				else
 					thisParameter->value.asBoolean=DISABLED;
 				break;
 			case EDGE:
				/*Set the value*/
 				if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW1 )) )
					thisParameter->value.asEdge=BOTTOMLEFT;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW2 )) )
					thisParameter->value.asEdge=BOTTOM;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW3 )) )
					thisParameter->value.asEdge=BOTTOMRIGHT;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW4 )) )
					thisParameter->value.asEdge=LEFT;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW6 )) )
					thisParameter->value.asEdge=RIGHT;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW7 )) )
					thisParameter->value.asEdge=TOPLEFT;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW8 )) )
					thisParameter->value.asEdge=TOP;
 				else if( (!strcmp( gtk_label_get_text(GTK_LABEL(this->editableWidgets->getElement(count))), ARROW9 )) )
					thisParameter->value.asEdge=TOPRIGHT;
 				break;
 			case STARTUPNOTIFY:
				StartupNotify *thisSN = (StartupNotify *)thisParameter; //Casting for handle the parameter as a StartupNotify

				/*Set the <enable> value*/
				if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(this->st_Widgets->getElement(1)) ) == TRUE  )
					thisSN->st_enabled=ENABLED;
				else
					thisSN->st_enabled=DISABLED;

				/*Set the <icon> value*/
				free(thisSN->st_icon); //Delete the previous value
				tmpString=(char*)gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(this->st_Widgets->getElement(2)));
				if(tmpString != NULL)
					{
					thisSN->st_icon = (char*)malloc(1+strlen(tmpString)); //Allocate memory for the new value
					strcpy(thisSN->st_icon, tmpString); //Set the new value
					}
				else
					{
					/*If the entry is empty, set st_icon to NULL*/
					thisSN->st_icon = NULL;
					}

				/*Set the <name> value*/
				free(thisSN->st_name); //Delete the previous value
				tmpString=(char*)gtk_entry_get_text(GTK_ENTRY(this->st_Widgets->getElement(3)));
				if( strlen(tmpString) > 0 )
					{
					thisSN->st_name=(char*)malloc(1+strlen(tmpString)); //Allocate memory for the new value
					strcpy(thisSN->st_name, tmpString); //Set the new value
					}
				else
					{
					/*If the entry is empty, set st_name to NULL*/
					thisSN->st_name=NULL;
					}

				/*Set the <wmclass> value*/
				free(thisSN->st_wmclass); //Delete the previous value
 				tmpString=(char*)gtk_entry_get_text(GTK_ENTRY(this->st_Widgets->getElement(4)));
				if(strlen(tmpString) > 0)
					{
					thisSN->st_wmclass=(char*)malloc(1+strlen(tmpString)); //Allocate memory for the new value
					strcpy(thisSN->st_wmclass, tmpString); //Set the new value
					}
				else
					{
					/*If the entry is empty, set st_wmclass to NULL*/
					thisSN->st_wmclass=NULL;
					}
				break;
			defaut:
				break;
 			}
 		}

	/*Delete the Containers used for store the editable Parameters and Widgets*/
	if(this->st_Widgets != NULL)
		delete this->st_Widgets;
	delete this->editableWidgets;
	delete this->parameterList;

	/*Delete the children FinalActions*/
	NOE=subActionDrawings->getNumberOfElements();
	while(NOE>0)
		{
		delete (GUI_ActionDrawing*) subActionDrawings->getElement(NOE);
		NOE--;
		}
	delete subActionDrawings;

	/*Unset editor for the caller GUI_ActionDrawing*/
	this->callerDrawing->unsetEditor(this);

	/*Destroy the window widget*/
	gtk_widget_destroy(this->window);
	}

void GUI_ActionEditor::insertActionDrawing(GUI_ActionDrawing *drawing) //Insert a child GUI_ActionDrawing
	{
	this->subActionDrawings->insertElement(drawing);
	drawing->setParentDrawing(this);
	gtk_box_pack_start(GTK_BOX(finalActionsArea), drawing->frame, FALSE, FALSE, 0 );
	}

void GUI_ActionEditor::removeActionDrawing(GUI_ActionDrawing *drawing) //Remove a child GUI_ActionDrawing. This doesn't destroy it.
	{
	this->subActionDrawings->removeElement(drawing);
	}

void GUI_ActionEditor::showActionSelectorMenu() //Show a menu to select an action to add
	{
	new GUI_ActionSelectorMenu(this);
	}

void GUI_ActionEditor::disconnectDestroyHandler() //Disconnect the window "destroy" singal
	{
	g_signal_handler_disconnect(GTK_OBJECT(this->window), this->destroyHandler);
	}





/* ---METHODS FOR GUI_KeyBindMenu--- */

GUI_KeyBindMenu::GUI_KeyBindMenu(GUI_KeyBindDrawing *drawing)
	{
	printf("[DEBUG] Create GUI_KeyBindMenu %p. drawing: %p\n", this, drawing);
	GtkWidget *itemEdit, *itemAddKeyBind, *itemDelete;

	/*Set variable values*/
	this->keybind=drawing->keybind;
	this->callerDrawing=drawing;
	this->itemAddAction=NULL;

	/*Create the menu*/	
	menu=gtk_menu_new();
	itemEdit=gtk_menu_item_new_with_label("Edit hotkeys");
	g_signal_connect(GTK_OBJECT(itemEdit), "activate", G_CALLBACK(S_KM_editKeysItem), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (menu), itemEdit);

	/*If the KeyBind is empty, or there is a KeyBind inside it, create the "Add keychain" item*/
	/*NOTE: This is for avoid insert an Action and a KeyChain inside the same KeyBind*/
	if(keybind->getNumberOfElements() == 0 || keybind->getDataType(1) == KEYBIND)
		{
		itemAddKeyBind=gtk_menu_item_new_with_label("Add keychain");
		g_signal_connect(GTK_OBJECT(itemAddKeyBind), "activate", G_CALLBACK(S_KM_addKeyBindItem), this);
		gtk_menu_shell_append(GTK_MENU_SHELL (menu), itemAddKeyBind);
		}

	/*If the KeyBind is empty, or there is an Action inside it, create the "Add action" item*/
	/*NOTE: This is for avoid insert an Action and a KeyChain inside the same KeyBind*/
 	if(keybind->getNumberOfElements() == 0 || keybind->getDataType(1) == ACTION)
 		{
		this->itemAddAction=gtk_menu_item_new_with_label("Add action");
		gtk_menu_shell_append(GTK_MENU_SHELL (menu), itemAddAction);
		new GUI_ActionSelectorMenu(drawing, this);
 		}

	/*Create the delete item*/
	itemDelete=gtk_menu_item_new_with_label("Delete this keybind");
	g_signal_connect(GTK_OBJECT(itemDelete), "activate", G_CALLBACK(S_KM_deleteItem), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (menu), itemDelete);

 	//g_signal_connect(GTK_OBJECT(menu), "deactivate", G_CALLBACK(S_KM_destroy), this);
	/*FIXME: The previous line is for delete the menu when it is hide (For free unused memory). But if the menu is destroyed, it doesn't call the signal_handler for the selected item. This mean that when you click on "Add action", the menu is destroyed _BEFORE_ add an Action. Please GTK guru, help me with this */

	/*Show the menu widget*/
	gtk_widget_show_all(this->menu);
	gtk_menu_popup(GTK_MENU(this->menu), NULL, NULL, NULL, NULL, NULL, NULL);

	}

GUI_KeyBindMenu::~GUI_KeyBindMenu()
	{
	printf("[DEBUG] Delete GUI_KeyBindMenu %p\n", this);
	/*Destroy the menu widget*/
	gtk_widget_destroy(this->menu);
	}

void GUI_KeyBindMenu::addKeyBind() //This method is called when the item "Add Keychain" is selected
	{
	/*Create a new KeyBind*/
	KeyBind *keybind = new KeyBind(this->callerDrawing->keybind);

	/*Insert it in the parent KeyBind*/
	this->callerDrawing->keybind->insertElement(KEYBIND, (void*)keybind);

	/*Create its GUI_KeyBindDrawing*/
	GUI_KeyBindDrawing *drawing = new GUI_KeyBindDrawing(keybind);

	/*Insert it in its parnt GUI_KeyBindDrawing*/
	this->callerDrawing->insertKeyBindDrawing(drawing);

	/*Show an GUI_KeyBindEditor window*/
	drawing->showEditor();
	}

void GUI_KeyBindMenu::deleteCaller() //This method is called when the item "Delete this keybind" is selected
	{
	/*Delete KeyBind and its GUI_KeyBindDrawing*/
	delete this->callerDrawing->keybind;
	delete this->callerDrawing;
	}



/* ---METHODS FOR GUI_ActionMenu--- */

GUI_ActionMenu::GUI_ActionMenu(GUI_ActionDrawing *actionDrawing)
	{
	printf("[DEBUG] Create GUI_ActionMenu %p. actionDrawing: %p\n", this, actionDrawing);
	GtkWidget *itemSettings, *itemDelete;
	Action *action;

	/*Set class variable values*/
	this->callerDrawing=actionDrawing;
	
	/*Create the menu widget*/
	this->menu=gtk_menu_new();

	action=callerDrawing->action;
	/*If action has Parameters or FinalActionsList, create "Edit settings" item*/
	if( action->getNumberOfElements() > 0 || action->finalActionsList != NULL || actionModel[action->type][MODEL_PARAMETERS] != NULL || actionModel[action->type][MODEL_FINAL_ACTIONS] != NULL)
		{
		itemSettings=gtk_menu_item_new_with_label("Edit settings");
		gtk_menu_shell_append(GTK_MENU_SHELL (this->menu), itemSettings);
		g_signal_connect(GTK_OBJECT(itemSettings), "activate", G_CALLBACK(S_AM_editSettingsItem), this );
		gtk_widget_show(itemSettings);
		}

	/*Create delete item*/
	itemDelete=gtk_menu_item_new_with_label("Delete this action");
	g_signal_connect(GTK_OBJECT(itemDelete), "activate", G_CALLBACK(S_AM_deleteItem), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (this->menu), itemDelete);
	//g_signal_connect(GTK_OBJECT(menu), "deactivate", G_CALLBACK(S_AM_destroy), this );
	/*FIXME: Look in GUI_KeyBindMenu::GUI_KeyBindMenu(GUI_KeyBindDrawing *drawing) for an explanation*/

	/*Show the menu widget*/
	gtk_widget_show(itemDelete);
	gtk_menu_popup(GTK_MENU(this->menu), NULL, NULL, NULL, NULL, NULL, NULL);

	}

GUI_ActionMenu::~GUI_ActionMenu()
	{
	printf("[DEBUG] Delete GUI_ActionMenu %p\n", this);
	gtk_widget_destroy(this->menu);
	}

void GUI_ActionMenu::editSettings() //This method is called when the item "Edit settings" is selected
	{
	this->callerDrawing->action->modelate();
	this->callerDrawing->showEditor();
	}

void GUI_ActionMenu::deleteCaller() //This method is called when the item "Delete this action" is selected
	{
	GUI_ActionDrawing *drawing = this->callerDrawing;
	delete drawing->action;
	delete drawing;
	}




/* ---METHODS FOR GUI_ActionSelectorMenu--- */

GUI_ActionSelectorMenu::GUI_ActionSelectorMenu(GUI_KeyBindDrawing *drawing, GUI_KeyBindMenu *keybindMenu)
	{
	printf("[DEBUG] Create GUI_ActionSelectorMenu %p. drawing: %p. keybindMenu: %p\n", this, drawing, keybindMenu);
	/*Set class variable values*/
	this->callerDrawing=(AdaptedContainer*)drawing;
	this->callerType=KEYBIND;

	/*Second step of constructor*/
	create();

	/*Insert this menu in the GUI_KeyBindMenu*/
	if(keybindMenu->itemAddAction != NULL)
		gtk_menu_item_set_submenu( GTK_MENU_ITEM(keybindMenu->itemAddAction) , this->menu);
	}

GUI_ActionSelectorMenu::GUI_ActionSelectorMenu(GUI_ActionEditor *editor)
	{
	printf("[DEBUG] Create GUI_ActionSelectorMenu %p. editor: %p\n", this, editor);
	/*Set class variable values*/
	this->callerDrawing=(AdaptedContainer*)editor;
	this->callerType=FINALACTIONSLIST;

	/*Second step of constructor*/
	create();

	/*Show this menu*/
	gtk_menu_popup(GTK_MENU(this->menu), NULL, NULL, NULL, NULL, NULL, NULL);
	}

GUI_ActionSelectorMenu::~GUI_ActionSelectorMenu()
	{
	printf("[DEBUG] Delete GUI_ActionSelectorMenu %p\n", this);

	/*Delete the freeOnDelete Container, and its contents */
	int NOE=this->freeOnDelete->getNumberOfElements();
	int count=0;
	while(count<NOE)
		{
		count++;
		free(this->freeOnDelete->getElement(count));
		}
	delete this->freeOnDelete;
	}

void GUI_ActionSelectorMenu::create() //Second step for the constructor
	{
 	GtkWidget *submenu1, *submenu2, *submenu3, *tmpItem;
	void** args; //This will be a temporal array for store two arguments
	this->freeOnDelete = new Container(); //Create the freeOnDelete Container

	/*Macro for add submenu (second layer) */
	#define ADD_SUBMENU2(LABEL) \
	tmpItem=gtk_menu_item_new_with_label(LABEL);\
	gtk_menu_shell_append(GTK_MENU_SHELL (submenu1), tmpItem);\
	submenu2=gtk_menu_new();\
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(tmpItem), submenu2);

	/*Macro for add a submenu (third layer)*/
	#define ADD_SUBMENU3(LABEL) \
	tmpItem=gtk_menu_item_new_with_label(LABEL);\
	gtk_menu_shell_append(GTK_MENU_SHELL (submenu2), tmpItem);\
	submenu3=gtk_menu_new();\
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(tmpItem), submenu3);

	/*Macro for add an item with callback */
	#define ADD_ITEM(LABEL, SUBMENU, USER_DATA) \
	tmpItem=gtk_menu_item_new_with_label(LABEL);\
	gtk_menu_shell_append(GTK_MENU_SHELL (SUBMENU), tmpItem);\
	args=(void**)malloc(3*sizeof(void*)); \
	this->freeOnDelete->insertElement(args);\
	args[0]=(void*)this; \
	args[1]=(void*)USER_DATA; \
	g_signal_connect(GTK_OBJECT(tmpItem), "activate", G_CALLBACK(S_AS_addActionItem), args );

	/*Create the menu*/
	submenu1=gtk_menu_new();
	this->menu=submenu1;

	ADD_ITEM("Execute command", submenu1, "Execute");
	ADD_ITEM("Show a menu", submenu1, "ShowMenu");

	ADD_SUBMENU2("Basic window operations");
	ADD_ITEM("Close", submenu2, "Close");
	ADD_ITEM("Minimize (iconify)", submenu2, "Iconify");
	ADD_ITEM("Toggle Maximize", submenu2, "ToggleMaximizeFull");
	ADD_ITEM("Move", submenu2, "Move");
	ADD_ITEM("Resize", submenu2, "Resize");
	ADD_ITEM("Show in all desktops", submenu2, "ToggleOmnipresent");
	ADD_SUBMENU3("Shading")
	ADD_ITEM("Toggle shade", submenu3, "ToggleShade");
	ADD_ITEM("Shade", submenu3, "Shade");
	ADD_ITEM("Unshade", submenu3, "Unshade");
	ADD_SUBMENU3("Decorations")
	ADD_ITEM("Toggle decorations", submenu3, "ToggleDecorations");
	ADD_ITEM("Decorations on", submenu3, "Decorate");
	ADD_ITEM("Decorations off", submenu3, "Undecorate");
	ADD_SUBMENU3("Layer")
	ADD_ITEM("Always on top", submenu3, "ToggleAlwaysOnTop");
	ADD_ITEM("Always on bottom", submenu3, "ToggleAlwaysOnBottom");
	
	ADD_SUBMENU2("Desktops actions");
	ADD_ITEM("Show desktop (hide all windows)", submenu2, "ToggleShowDesktop");
	ADD_SUBMENU3("Switch to desktop");
	ADD_ITEM("Select", submenu3, "Desktop");
	ADD_ITEM("Next", submenu3, "DesktopNext");
	ADD_ITEM("Previous", submenu3, "DesktopPrevious");
	ADD_ITEM("Left", submenu3, "DesktopLeft");
	ADD_ITEM("Right", submenu3, "DesktopRight");
	ADD_ITEM("Up", submenu3, "DesktopUp");
	ADD_ITEM("Down", submenu3, "DesktopDown");
	ADD_ITEM("Last", submenu3, "DesktopLast");
	ADD_SUBMENU3("Add new desktop");
	ADD_ITEM("After all", submenu3, "AddDesktopLast");
	ADD_ITEM("After current", submenu3, "AddDesktopCurrent");
	ADD_SUBMENU3("Remove desktop");
	ADD_ITEM("Last", submenu3, "RemoveDesktopLast");
	ADD_ITEM("Current", submenu3, "RemoveDesktopCurrent");
	ADD_ITEM("Hide the dock", submenu2, "ToggleDockAutoHide");

	ADD_SUBMENU2("Window switching");
	ADD_ITEM("Next Window", submenu2, "NextWindow");
	ADD_ITEM("Previous Window", submenu2, "PreviousWindow");
	ADD_SUBMENU3("Directional Focus");
	ADD_ITEM("North", submenu3, "DirectionalFocusNorth");
	ADD_ITEM("East", submenu3, "DirectionalFocusEast");
	ADD_ITEM("West", submenu3, "DirectionalFocusWest");
	ADD_ITEM("South", submenu3, "DirectionalFocusSouth");
	ADD_ITEM("Nort-West", submenu3, "DirectionalFocusNorthWest");
	ADD_ITEM("Nort-East", submenu3, "DirectionalFocusNorthEast");
	ADD_ITEM("South-West", submenu3, "DirectionalFocusSouthWest");
	ADD_ITEM("South-East", submenu3, "DirectionalFocusSouthEast");
	ADD_SUBMENU3("Directional Target");
	ADD_ITEM("North", submenu3, "DirectionalTargetNorth");
	ADD_ITEM("East", submenu3, "DirectionalTargetEast");
	ADD_ITEM("West", submenu3, "DirectionalTargetWest");
	ADD_ITEM("South", submenu3, "DirectionalTargetSouth");
	ADD_ITEM("Nort-West", submenu3, "DirectionalTargetNorthWest");
	ADD_ITEM("Nort-East", submenu3, "DirectionalTargetNorthEast");
	ADD_ITEM("South-West", submenu3, "DirectionalTargetSouthWest");
	ADD_ITEM("South-East", submenu3, "DirectionalTargetSouthEast");

	ADD_SUBMENU2("Send window to Desktop");
	ADD_ITEM("Select", submenu2, "SendToDesktop");
	ADD_ITEM("Next", submenu2, "SendToDesktopNext");
	ADD_ITEM("Previous", submenu2, "SendToDesktopPrevious");
	ADD_ITEM("Left", submenu2, "SendToDesktopLeft");
	ADD_ITEM("Right", submenu2, "SendToDesktopRight");
	ADD_ITEM("Up", submenu2, "SendToDesktopUp");
	ADD_ITEM("Down", submenu2, "SendToDesktopDown");
	ADD_ITEM("Last", submenu2, "SendToDesktopLast");

	ADD_SUBMENU2("Window manager");
	ADD_ITEM("Reload configuration", submenu2, "Reconfigure");
	ADD_ITEM("Restart the Window Manager", submenu2, "Restart");
	ADD_ITEM("Exit / Logout", submenu2, "Exit");
	ADD_ITEM("Print debug message", submenu2, "Debug");
	
	ADD_SUBMENU2("LXDE commands")
	ADD_ITEM("Show LXDE menu", submenu2, ":lxpanelctl menu");
	ADD_ITEM("Show run dialog", submenu2, ":lxpanelctl run");
	ADD_ITEM("Log out LXDE", submenu2, ":lxsession-logout");

	ADD_SUBMENU2("Window moving");
	ADD_ITEM("Move", submenu2, "Move");
	ADD_ITEM("Move to center", submenu2, "MoveToCenter");
	ADD_ITEM("Move / Resize to...", submenu2, "MoveResizeTo");
	ADD_ITEM("Move relative", submenu2, "MoveRelative");
	ADD_SUBMENU3("Move to edge")
	ADD_ITEM("North", submenu3, "MoveToEdgeNorth");
	ADD_ITEM("South", submenu3, "MoveToEdgeSouth");
	ADD_ITEM("West", submenu3, "MoveToEdgeWest");
	ADD_ITEM("East", submenu3, "MoveToEdgeEast");

	ADD_SUBMENU2("Window resizing");
	ADD_ITEM("Resize", submenu2, "Resize");
	ADD_ITEM("Resize relative", submenu2, "ResizeRelative");
	ADD_ITEM("Move / Resize to...", submenu2, "MoveResizeTo");
	ADD_ITEM("Fullscreen", submenu2, "ToggleFullscreen");
	ADD_ITEM("Maximize", submenu2, "MaximizeFull");
	ADD_ITEM("UnMaximize", submenu2, "UnmaximizeFull");
	ADD_ITEM("Toggle Maximize", submenu2, "ToggleMaximizeFull");
	ADD_SUBMENU3("Horizontally");
	ADD_ITEM("Maximize", submenu3, "MaximizeHorz");
	ADD_ITEM("UnMaximize", submenu3, "UnMaximizeHorz");
	ADD_ITEM("Toggle Maximize", submenu3, "ToggleMaximizeHorz");
	ADD_ITEM("Grow to edge west", submenu3, "GrowToEdgeWest");
	ADD_ITEM("Grow to edge east", submenu3, "GrowToEdgeEast");
	ADD_SUBMENU3("Vertically");
	ADD_ITEM("Maximize", submenu3, "MaximizeVert");
	ADD_ITEM("UnMaximize", submenu3, "UnMaximizeVert");
	ADD_ITEM("Toggle Maximize", submenu3, "ToggleMaximizeVert");
	ADD_ITEM("Grow to edge north", submenu3, "GrowToEdgeNorth");
	ADD_ITEM("Grow to edge south", submenu3, "GrowToEdgeSouth");

	ADD_SUBMENU2("Window focus");
	ADD_ITEM("Focus", submenu2, "Focus");
	ADD_ITEM("Unfocus", submenu2, "Unfocus");
	ADD_ITEM("Focus to bottom", submenu2, "FocusToBottom");
	ADD_ITEM("Raise", submenu2, "Raise");
	ADD_ITEM("Lower", submenu2, "Lower");
	ADD_ITEM("Raise / Lower", submenu2, "RaiseLower");
	ADD_ITEM("Toggle omnipresent", submenu2, "ToggleOmnipresent");
	ADD_ITEM("Shade and lower", submenu2, "ShadeLower");
	ADD_ITEM("Unshade and raise", submenu2, "UnshadeRaise");
	ADD_ITEM("Toggle always on top", submenu2, "ToggleAlwaysOnTop");
	ADD_ITEM("Toggle always on bottom", submenu2, "ToggleAlwaysOnBottom");
	ADD_ITEM("Send to top layer", submenu2, "SendToTopLayer");
	ADD_ITEM("Send to bottom layer", submenu2, "SendToBottomLayer");
	ADD_ITEM("Send to Normal layer", submenu2, "SendToNormalLayer");

	/*Show the menu*/
	gtk_widget_show_all(submenu1);
	}

void GUI_ActionSelectorMenu::addAction(GUI_ActionSelectorMenu *callerMenu, char *actionType) //Add the selected action to the KeyBind
	{
	Action *action;
	char *tmpString;

	if(actionType[0] == ':')
		{
		/*If the second arguments starts with ':', create an Execute, and use the rest for the command*/
		tmpString=(char*)malloc(1+strlen(actionType));
		strcpy(tmpString, actionType+1);
		action = new Action((char*)"Execute", ((GUI_ActionEditor*)(callerMenu->callerDrawing))->action->finalActionsList);
		action->insertElement(PARAMETER, new Parameter((char*)"command", tmpString, action));
		}
	else
		{
		/*Else, create an Action */
		action = new Action(actionType, ((GUI_ActionEditor*)(callerMenu->callerDrawing))->action->finalActionsList);
		}

	/*Modelate the Action*/
	action->modelate();

	/*Insert the Action and the GUI_ActionDrawing in its parents*/
	if(callerMenu->callerType == KEYBIND )
		{
		GUI_KeyBindDrawing *drawing = ((GUI_KeyBindDrawing*)(callerMenu->callerDrawing));
		KeyBind *keybind = drawing->keybind;
		keybind->insertElement(ACTION, action);
		drawing->insertActionDrawing(new GUI_ActionDrawing(action));
		}
	else if(callerMenu->callerType == FINALACTIONSLIST )
		{
		GUI_ActionEditor *editor = ((GUI_ActionEditor*)(callerMenu->callerDrawing));
		FinalActionsList *finalActionsList = editor->action->finalActionsList;
		finalActionsList->insertElement(ACTION, action);
		editor->insertActionDrawing(new GUI_ActionDrawing(action));
		}
	delete callerMenu;
	}