#include <gtk/gtk.h>

//arrows for edge buttons
#define ARROW1 "⬋"
#define ARROW2 "⬇"
#define ARROW3 "⬊"
#define ARROW4 "⬅"
#define ARROW6 "➡"
#define ARROW7 "⬉"
#define ARROW8 "⬆"
#define ARROW9 "⬈"

/*CLASS DECLARATIONS*/
class GUI_KeyboardDrawing;
class GUI_KeyBindDrawing;
class GUI_ActionDrawing;
class GUI_KeyBindEditor;
class GUI_ActionEditor;
class GUI_KeyBindMenu;
class GUI_ActionMenu;
class GUI_ActionSelectorMenu;


/*CLASS DEFINITIONS*/

class GUI_KeyboardDrawing //Class for draw a Keyboard
	{
	GtkWidget *mainVbox; //Here inside will be the KeyBind drawings
	GtkWidget *scrolledVbox; //KeyBinds list
	GtkWidget *keybindsArea; //The scroll
	Keyboard *keyboard; //The Keyboard to draw
	Container *subKeyBindDrawings; //The children keybinds

	public:
	 GUI_KeyboardDrawing(Keyboard *keyboard_, GtkWidget *embedIn);
	 ~GUI_KeyboardDrawing();

	 void insertKeyBindDrawing(GUI_KeyBindDrawing *drawing); //Insert a child GUI_KeyBindDrawing
	 void removeKeyBindDrawing(GUI_KeyBindDrawing *drawing); //Remove a child GUI_KeyBindDrawing. This doesn't destroy it.
	 void newKeyBind(); //Create a child GUI_KeyBindDrawing
	 void clear(); //Delete all children keybinds
	};

class GUI_KeyBindDrawing //Class for draw a KeyBind
	{
	GtkWidget *keybindVbox;
	GtkWidget *labelHbox; //Here inside will be the header buttons
	GtkWidget *alignedBox; //Here inside will be the action and keychain drawings
	Container *subKeyBindDrawings; //The children keybinds
	Container *subActionDrawings; //The children actions
	GUI_KeyBindEditor *editor; //The editor for this KeyBind
	void *parentDrawing; //The parent drawing.
	ContainerDataType parentDrawingType; //The parent drawing type. May be a GUI_KeyBindDrawing or a GUI_KeyboardDrawing

	public:
	 GtkWidget *frame; //Main frame
	 KeyBind *keybind; //Keybind to draw

	 GUI_KeyBindDrawing(KeyBind *keybind);
	 ~GUI_KeyBindDrawing();

	 void drawHeader(); //Draw or redraw the key combination buttons (eg: ctrl+alt+4)
	 void showEditor(); //Show a GUI_KeyBindEditor for editing the KeyBind
	 void showMenu(); //Show an options menu
	 void insertKeyBindDrawing(GUI_KeyBindDrawing *drawing); //Insert a child GUI_KeyBindDrawing
	 void removeKeyBindDrawing(GUI_KeyBindDrawing *drawing); //Remove a child GUI_KeyBindDrawing. This doesn't destroy it.
	 void insertActionDrawing(GUI_ActionDrawing *drawing); //Insert a child GUI_ActionDrawing
	 void removeActionDrawing(GUI_ActionDrawing *drawing); //Remove a child GUI_ActionDrawing. This doesn't destroy it.
	 void unsetEditor(GUI_KeyBindEditor *_editor); //Set the editor pointer to NULL. (Call this when destroy the editor)
	 void setParentDrawing(GUI_KeyboardDrawing *keybinder); //Set the parent GUI_KeyboardDrawing
	 void setParentDrawing(GUI_KeyBindDrawing *keybind); //Set the parent GUI_KeyBindDrawing
	};

class GUI_ActionDrawing //Class for draw an Action
	{
	GUI_ActionEditor *editor; //The editor for this key combination
	void *parentDrawing; //The parent drawing.
	ContainerDataType parentDrawingType; //The parent drawing type. May be a GUI_KeyBindDrawing or a GUI_ActionEditor

	public:
	 GtkWidget *frame; //Main frame
	 Action *action; //Action to draw

	 GUI_ActionDrawing(Action *_action);
	 ~GUI_ActionDrawing();

	 void showMenu(); //Show an options menu
	 void showEditor(); //Show a GUI_KeyBindEditor for editing the KeyBind
	 void unsetEditor(GUI_ActionEditor *_editor); //Set the editor pointer to NULL. (Call this when destroy the editor)
	 void setParentDrawing(GUI_ActionEditor *editor); //Set the parent GUI_ActionEditor (If the Action is inside a FinalActionsList)
	 void setParentDrawing(GUI_KeyBindDrawing *keybind); //Set the parent GUI_KeyBindDrawing
	};

class GUI_KeyBindEditor //Class for editing a KeyBind (its key combination)
	{
	GtkWidget *window, *ctrl, *shift, *alt, *super, *meta, *combo; //The GTK widgets for draw the window
	unsigned long destroyHandler; //This is used to disconnect the signal handler for the window "destroy" signal *
	GUI_KeyBindDrawing *callerDrawing; //The drawing that has created this object

	public:
	 KeyBind *keybind; //The KeyBind to edit

	 GUI_KeyBindEditor(GUI_KeyBindDrawing *drawing_);
	 ~GUI_KeyBindEditor();
	 void disconnectDestroyHandler(); //Disconnect the window "destroy" singal
	/*
	* Why disconnect de the window "destroy" signal?
	When the editor window is destroyed, it calls the GUI_KeyBindEditor destructor.
	When the GUI_KeyBindEditor is destroyed, it calls gtk_widget_destroy(this->window).
	If the signal  is not disconnected, this will cause a fail.
	*/
	};

class GUI_ActionEditor //Class for editing an Action (its parameters and final actions)
	{
	GUI_ActionDrawing *callerDrawing; //The GUI_ActionDrawing that has created this object
	GtkWidget *finalActionsArea; //Here inside will be the final actions drawings
	GtkWidget *window; //The main window widget
	unsigned long destroyHandler; //This is used to disconnect the signal handler for the window "destroy" signal (See explanation in GUI_KeyBindEditor)
	Container *subActionDrawings; //List of children GUI_ActionDrawing
	/*NOTE: When the object is destroyed, it reads the data in the next 3 Containers to update the Action settings*/
	Container *st_Widgets; // list of GTK widgets to edit a StartupNotify
	Container *editableWidgets; //list of GTK widgets to edit the parameters
	Container *parameterList; //list of parameters to edit

	public:
	 Action *action; //The action to edit

	 GUI_ActionEditor(GUI_ActionDrawing *drawing);
	 ~GUI_ActionEditor();
	 void insertActionDrawing(GUI_ActionDrawing *drawing); //Insert a child GUI_ActionDrawing
	 void removeActionDrawing(GUI_ActionDrawing *drawing); //Remove a child GUI_ActionDrawing. This doesn't destroy it.
	 void showActionSelectorMenu(); //Show a menu to select an action to add
	 void disconnectDestroyHandler(); //Disconnect the window "destroy" singal
	};


class GUI_KeyBindMenu // Class for draw a KeyBind's option menu
	{
	KeyBind *keybind; //KeyBind
	GtkWidget *menu; //Main widget

	public:
	 GUI_KeyBindDrawing *callerDrawing; //The GUI_KeyBindDrawing that has created this object
	 GtkWidget *itemAddAction; //Here will be an GUI_ActionSelectorMenu as submenu

	 GUI_KeyBindMenu(GUI_KeyBindDrawing *drawing);
	 ~GUI_KeyBindMenu();
	 void addKeyBind(); //This method is called when the item "Add Keychain" is selected
	 void deleteCaller(); //This method is called when the item "Delete this keybind" is selected
	};

class GUI_ActionMenu //Class for draw an Action's options menu
	{
	GtkWidget *menu; //Main widget
	GUI_ActionDrawing *callerDrawing; //The GUI_ActionDrawing that created this menu

	public:
	 GUI_ActionMenu(GUI_ActionDrawing *actionDrawing);
	 ~GUI_ActionMenu();

	 void editSettings(); //This method is called when the item "Edit settings" is selected
	 void deleteCaller(); //This method is called when the item "Delete this action" is selected
	
	};


class GUI_ActionSelectorMenu //Class for draw an action selector menu
	{
	Container *freeOnDelete; //This Container is for store data that must be freed when the object is deleted
	AdaptedContainer *callerDrawing; //The GUI_KeyBindDrawing, or GUI_ActionEditor (final actions list) that created this menu
	ContainerDataType callerType; //Class for callerDrawing
	GtkWidget *menu; //Main widget

	void create(); //Second step for the constructor

	public:
	 GUI_ActionSelectorMenu(GUI_KeyBindDrawing *drawing, GUI_KeyBindMenu *keybindMenu);
	 GUI_ActionSelectorMenu(GUI_ActionEditor *editor);
	 ~GUI_ActionSelectorMenu();

	void addAction(GUI_ActionSelectorMenu *callerMenu, char *actionType); //Add the selected action to the KeyBind
	};