/*Action Models:

*/


#define MODEL_NAME 0
#define MODEL_DESCRIPTION 1
#define MODEL_PARAMETERS 2
#define MODEL_PARAMETERS_DESCRIPTIONS 3
#define MODEL_FINAL_ACTIONS 4

#define NEXT_WINDOW_PARAMETERS "B dialog T| B bar T| B raise F| B allDesktops F| B panels F| B desktop F| B linear F"
#define NEXT_WINDOW_DESCRIPTIONS "dialog: Show dialog| bar: Show focus indicator| raise: Raise the window to the front| allDesktops: Cycle windows on all desktops| panels: Include panels in cycle| desktop: Include desktop in cycle| linear: Cycle in linear ordering"
#define DIRECTIONAL_FOCUS_PARAMETERS "B dialog T| B bar T| B raise false"
#define DIRECTIONAL_FOCUS_DESCRIPTIONS "dialog: Show dialog| bar: Show focus indicator| raise: Raise the window to the front "
#define DESKTOP_CHANGE_PARAMETERS "B wrap T| B dialog F"
#define DESKTOP_CHANGE_DESCRIPTIONS "wrap: Wrap around| dialog: Show dialog"
#define SEND_TO_DESKTOP_PARAMETERS "B follow T| B wrap T| B dialog F"
#define SEND_TO_DESKTOP_DESCRIPTIONS "follow: Change to that desktop| wrap: Wrap around| dialog: Show dialog"
#define DEFAULT_FINAL_ACTIONS "Focus| Raise| Unshade"
//NOTE: DESKTOP_CHANGE_PARAMETERS & SEND_TO_DESKTOP_PARAMETERS: the dialog parameter is not specified in the manual, but the default config file has it

const char *actionModel[95][5]={
{"UNDEFINED", "undefined action", NULL, NULL, NULL},
{"Execute", "Execute a command", "S command| S prompt| R startupnotify", "command: Command to execute| prompt: Ask confirmation (Optional)| startupnotify: Startup notify", NULL},
{"ShowMenu", "Show a menu", "S menu client-menu", "menu: Menu to be shown", NULL},
{"NextWindow", "Focus the next window (loop)", NEXT_WINDOW_PARAMETERS, NEXT_WINDOW_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"PreviousWindow", "Focus the previous window (loop)", NEXT_WINDOW_PARAMETERS, NEXT_WINDOW_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusNorth", "Focus the window north (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusSouth", "Focus the window south (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusEast", "Focus the window east (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusWest", "Focus the window west (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusNorthWest", "Focus the window north-west (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusNorthEast", "Focus the window north-east (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusSouthWest", "Focus the window south-west (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalFocusSouthEast", "Focus the window south-east (loop)", DIRECTIONAL_FOCUS_PARAMETERS, DIRECTIONAL_FOCUS_DESCRIPTIONS, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetNorth", "Move focus to the window north (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetSouth", "Move focus to the window south (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetEast", "Move focus to the window east (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetWest", "Move focus to the window west (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetNorthWest", "Move focus to the window north-west (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetNorthEast", "Move focus to the window north-east (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetSouthWest", "Move focus to the window south-west (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"DirectionalTargetSouthEast", "Move focus to the window south-east (linear)", NULL, NULL, DEFAULT_FINAL_ACTIONS},
{"Desktop", "Switch the desktop", "N desktop 1", "desktop: Switch to desktop number", NULL},
{"DesktopNext", "Switch to the next desktop",  DESKTOP_CHANGE_PARAMETERS, DESKTOP_CHANGE_DESCRIPTIONS, NULL},
{"DesktopPrevious", "Switch to the previous desktop",  DESKTOP_CHANGE_PARAMETERS, DESKTOP_CHANGE_DESCRIPTIONS, NULL},
{"DesktopLeft", "Switch to desktop to the left of the current",  DESKTOP_CHANGE_PARAMETERS, DESKTOP_CHANGE_DESCRIPTIONS, NULL},
{"DesktopRight", "Switch to desktop to the right of the current",  DESKTOP_CHANGE_PARAMETERS, DESKTOP_CHANGE_DESCRIPTIONS, NULL},
{"DesktopUp", "Switch to desktop above the current",  DESKTOP_CHANGE_PARAMETERS, DESKTOP_CHANGE_DESCRIPTIONS, NULL},
{"DesktopDown", "Switch to desktop below the current",  DESKTOP_CHANGE_PARAMETERS, DESKTOP_CHANGE_DESCRIPTIONS, NULL},
{"DesktopLast", "Switch last visible desktop", NULL, NULL, NULL},
{"AddDesktopLast", "Create a new desktop after all", NULL, NULL, NULL},
{"RemoveDesktopLast", "Remove the last desktop", NULL, NULL, NULL},
{"AddDesktopCurrent", "Create a new desktop after current", NULL, NULL, NULL},
{"RemoveDesktopCurrent", "Remove the current desktop", NULL, NULL, NULL},
{"ToggleShowDesktop", "Hide all windows", NULL, NULL, NULL},
{"ToggleDockAutohide", "Toggle the autohide setting on the dock temporarily", NULL, NULL, NULL},
{"Reconfigure", "Reload window manager settings", NULL, NULL, NULL},
{"Restart", "Restart window manager", "S command ", "command: sNew window manager", NULL},
{"Exit", "Exit window manager", "B prompt T", "prompt: Ask confirmation", NULL},
{"SessionLogout", "Exit window manager", "B prompt T", "prompt: Ask confirmation", NULL},
{"Debug", "Print out a debug string", "S string ", "string: String to print", NULL},
{"Focus", "Focus the window", NULL, NULL, NULL},
{"Raise", "Raise the window", NULL, NULL, NULL},
{"Lower", "Lower the window", NULL, NULL, NULL},
{"RaiseLower", "Raise / Lower the window", NULL, NULL, NULL},
{"Unfocus", "Move focus off of the window", NULL, NULL, NULL},
{"FocusToBottom", "Move the window to the bottom", NULL, NULL, NULL},
{"Iconify", "Iconify (minimize) the window", NULL, NULL, NULL},
{"Close", "Close the window", NULL, NULL, NULL},
{"ToggleShade", "Toggle shade / unshade the window", NULL, NULL, NULL},
{"Shade", "Shade (Roll up) the window", NULL, NULL, NULL},
{"Unshade", "Unshade (Roll down) the window", NULL, NULL, NULL},
{"ToggleOmnipresent", "Make the window visible on all desktops", NULL, NULL, NULL},
{"ToggleMaximizeFull", "Maximize / Unmaximize the window", NULL, NULL, NULL},
{"MaximizeFull", "Maximize the window", NULL, NULL, NULL},
{"UnmaximizeFull", "Return the window to its pre-maximized dimensions", NULL, NULL, NULL},
{"ToggleMaximizeVert", "Toggle Maximize the window vertically", NULL, NULL, NULL},
{"MaximizeVert", "Maximize the window vertically", NULL, NULL, NULL},
{"UnmaximizeVert", "Unmaximize vertically", NULL, NULL, NULL},
{"ToggleMaximizeHorz", "Toggle Maximize the window horizontally", NULL, NULL, NULL},
{"MaximizeHorz", "Maximize the window horizontally", NULL, NULL, NULL},
{"UnmaximizeHorz", "Unmaximize horizontally", NULL, NULL, NULL},
{"ToggleFullscreen", "Make the window fullscreen", NULL, NULL, NULL},
{"ToggleDecorations", "Give / Remove the window's decorations", NULL, NULL, NULL},
{"Decorate", "Decorate the window", NULL, NULL, NULL},
{"Undecorate", "Remove decorations from the window", NULL, NULL, NULL},
{"SendToDesktop", "Send the window to another desktop", "N desktop 1| B follow T", "desktop: Desktop number| follow: Change to desktop", NULL},
{"SendToDesktopNext", "Send the window to the next desktop", SEND_TO_DESKTOP_PARAMETERS, SEND_TO_DESKTOP_DESCRIPTIONS, NULL},
{"SendToDesktopPrevious", "Send the window to the previous desktop", SEND_TO_DESKTOP_PARAMETERS, SEND_TO_DESKTOP_DESCRIPTIONS, NULL},
{"SendToDesktopLeft", "Send the window to the left desktop", SEND_TO_DESKTOP_PARAMETERS, SEND_TO_DESKTOP_DESCRIPTIONS, NULL},
{"SendToDesktopRight", "Send the window to the right desktop", SEND_TO_DESKTOP_PARAMETERS, SEND_TO_DESKTOP_DESCRIPTIONS, NULL},
{"SendToDesktopUp", "Send the window to the above desktop", SEND_TO_DESKTOP_PARAMETERS, SEND_TO_DESKTOP_DESCRIPTIONS, NULL},
{"SendToDesktopDown", "Send the window to the below desktop", SEND_TO_DESKTOP_PARAMETERS, SEND_TO_DESKTOP_DESCRIPTIONS, NULL},
{"SendToDesktopLast", "Send the window to the last used desktop", "B follow T", "follow: Change to that desktop", NULL},
{"Move", "Move the window", NULL, NULL, NULL},
{"Resize", "Resize the window", "E edge", "edge: Resize the corner/edge", NULL},
{"MoveToCenter", "Move the window to the center of the screen", NULL, NULL, NULL},
{"MoveResizeTo", "Move and/or resize a window", "N x| N y| N width| N height| N monitor ", "x: Horizontal position| y: Vertical position| width: Width| height: Height| monitor: Monitor", NULL},
{"MoveRelative", "Move the window by an incremental amount, relative to its current position", "N x 0| N y 0", "x: Horizontal position| y: Vertical position", NULL},
{"ResizeRelative", "Resize the window by an incremental amount", "N left 0| N right 0| N top 0| N bottom 0", "left: Grow to left| right: Grow to right| top: Grow to top| bottom: Grow to bottom", NULL},
{"MoveToEdgeNorth", "Move the window to the nearest edge north of it", NULL, NULL, NULL},
{"MoveToEdgeSouth", "Move the window to the nearest edge south of it", NULL, NULL, NULL},
{"MoveToEdgeWest", "Move the window to the nearest edge west of it", NULL, NULL, NULL},
{"MoveToEdgeEast", "Move the window to the nearest edge east of it", NULL, NULL, NULL},
{"GrowToEdgeNorth", "Resize the window until it touches the nearest edge north of it", NULL, NULL, NULL},
{"GrowToEdgeSouth", "Resize the window until it touches the nearest edge south of it", NULL, NULL, NULL},
{"GrowToEdgeWest", "Resize the window until it touches the nearest edge west of it", NULL, NULL, NULL},
{"GrowToEdgeEast", "Resize the window until it touches the nearest edge east of it", NULL, NULL, NULL},
{"ShadeLower", "Shade / Lower", NULL, NULL, NULL},
{"UnshadeRaise", "Unshade / Raise", NULL, NULL, NULL},
{"ToggleAlwaysOnTop", "Toggle always on top", NULL, NULL, NULL},
{"ToggleAlwaysOnBottom", "Toggle always on bottom", NULL, NULL, NULL},
{"SendToTopLayer", "Make the window always above other windows", NULL, NULL, NULL},
{"SendToBottomLayer", "Make the window always below other windows", NULL, NULL, NULL},
{"SendToNormalLayer", "Put the window in the stacking order with other normal windows", NULL, NULL, NULL},
{NULL, NULL, NULL, NULL, NULL}
};
