#include "Container.cpp"
#include "keybinder_core.h"
#include "keybinder_actionModel.h"

/* ---METHODS FOR CLASS Parameter--- */

Parameter::Parameter()
	{
	printf("[DEBUG] Create Parameter %p\n", this);

	} //For StartupNotify constructor

Parameter::Parameter(Container *parent_)
	{
	printf("[DEBUG] Create Parameter %p. parent: %p\n", this, parent_);

	/*Set the parent*/
	this->parent=parent_;
	}

Parameter::Parameter(char *name_, char *value_, Container *parent_)
	{
	printf("[DEBUG] Create Parameter %p. name: %s. value: (string)%s. parent: %p\n", this, name_, value_, parent_);

	/*Set the parameter type*/
	this->type=STRING;

	/*Set the parameter name*/
	this->name = (char*) malloc(1+strlen(name_));
	strcpy(this->name, name_);

	/*Set the parameter value*/
	this->value.asString = (char*) malloc(1+strlen((char*)value_));
	strcpy(this->value.asString, (char*)value_);

	/*Set the parent*/
	this->parent=parent_;
	}

Parameter::Parameter(char *name_, int value_, Container *parent_)
	{
	printf("[DEBUG] Create Parameter %p. name: %s. value: (numeric)%d. parent: %p \n", this, name_, value_, parent_);

	/*Set the parameter type*/
	this->type=NUMBER;

	/*Set the parameter name*/
	this->name = (char*) malloc(1+strlen(name_));
	strcpy(this->name, name_);

	/*Set the parameter value*/
	this->value.asInt=value_;

	/*Set the parent*/
	this->parent=parent_;
	}

Parameter::Parameter(char *name_, EdgeType value_, Container *parent_)
	{
	printf("[DEBUG] Create Parameter %p. name: %s. value: (edge)%d. parent: %p \n", this, name_, value_, parent_);

	/*Set the parameter type*/
	this->type=EDGE;

	/*Set the parameter name*/
	this->name = (char*) malloc(1+strlen(name_));
	strcpy(this->name, name_);

	/*Set the parameter value*/
	this->value.asEdge=value_;

	/*Set the parent*/
	this->parent=parent_;
	}

Parameter::Parameter(char *name_, Boolean value_, Container *parent_)
	{
	printf("[DEBUG] Create Parameter %p. name: %s. value: (boolean)%d. parent: %p \n", this, name_, value_, parent_);

	/*Set the parameter type*/
	this->type=BOOLEAN;

	/*Set the parameter name*/
	this->name = (char*) malloc(1+strlen(name_));
	strcpy(this->name, name_);

	/*Set the parameter value*/
	this->value.asBoolean=value_;

	/*Set the parent*/
	this->parent=parent_;
	}

Parameter::Parameter(xmlDocPtr doc, xmlNodePtr node, Container *parent_)
	{
	printf("[DEBUG] Create Parameter %p. doc: %p. node: %p. parent: %p \n", this, doc, node, parent_);

	char* tn = (char*)(char*)node->name; //temporal name
	char* tv = (char*)xmlNodeListGetString(doc, node->xmlChildrenNode, 1); //temporal value

	/*Set the parameter name*/
	this->name=(char*) malloc(1+strlen(tn));
	strcpy(this->name, tn);

	/*Set the parent*/
	this->parent=parent_;

	/*Guess the type and set the value*/
	if( tv == NULL)
		{
		this->value.asString=(char*)malloc(sizeof(char));
		this->value.asString[0]='\0';
		this->type=STRING;
		}
	/*Look if is a boolean*/
	else if( (! strcmp(tv, "yes")) || (! strcmp(tv, "true")) || (! strcmp(tv, "on"))  )
		{
		this->value.asBoolean=ENABLED;
		this->type=BOOLEAN; 
		}
	else if( (! strcmp(tv, "false")) || (! strcmp(tv, "off")) || (! strcmp(tv, "no")) )
		{
		this->value.asBoolean=DISABLED;
		this->type=BOOLEAN;
		}
	/*Look if is a startup notify*/
	else if ( (! strcmp(tn, "startupnotify") ) )
		{
		this->type=STARTUPNOTIFY;
		}
	/*Look if is an edge*/
	else if( (! strcmp(tn, "edge") ) )
		{
		this->type=EDGE;
			if((! strcmp(tn, "bottomleft") ))
				this->value.asEdge=BOTTOMLEFT;
			if((! strcmp(tn, "bottom") ))
				this->value.asEdge=BOTTOM;
			if((! strcmp(tn, "bottomright") ))
				this->value.asEdge=BOTTOMRIGHT;
			if((! strcmp(tn, "left") ))
				this->value.asEdge=LEFT;
			if((! strcmp(tn, "right") ))
				this->value.asEdge=RIGHT;
			if((! strcmp(tn, "topleft") ))
				this->value.asEdge=TOPLEFT;
			if((! strcmp(tn, "top") ))
				this->value.asEdge=TOP;
			if((! strcmp(tn, "topright") ))
				this->value.asEdge=TOPRIGHT;
			else
				this->value.asEdge=BOTTOMRIGHT;
		}
	/*Look if is a number*/
	else
		{
		Boolean nonNumeric;
		int count=0;
		int characters=strlen(tv);
		char thisChar;
		while (count<characters)
			{
			thisChar=tv[count];
			if ( (thisChar=='0') || (thisChar=='1') || (thisChar=='2') || (thisChar=='3') || (thisChar=='4') || (thisChar=='5') || (thisChar=='6') || (thisChar=='7') || (thisChar=='8') || (thisChar=='9') || (thisChar=='-') )
				nonNumeric=DISABLED;
			else
				nonNumeric=ENABLED;
			count++;
			}
		if(nonNumeric==DISABLED)
			{
			this->type=NUMBER;
			this->value.asInt=atoi(tv);
			}
		else
			{
			this->type=STRING;
			this->value.asString=(char*)malloc(1+strlen(tv));
			strcpy(this->value.asString, tv);
			}
		}

	/*If the parameter name is "execute", then change it to "command". This parmeter name was changed in openbox*/
	if (type==STRING && (!strcmp( "execute", this->name ) ))
		strcpy(this->name, "command"); //I don't use memalloc because "command" and "execute" have the same length
	xmlFree(tv);
	}

Parameter::~Parameter()
	{
	printf("[DEBUG] Delete Parameter %p\n", this);

	/*If the parameter is a startupnotify, it name is a const char[], so it can't be freed. Otherwise, free it*/
	if(this->type != STARTUPNOTIFY)
 		free(name);

	/*If type is string, free it*/
	if(type==STRING)
		free(this->value.asString);

	/*Remove itself from its parent*/
	if(this->parent != NULL)
		this->parent->removeElement(this);
	}
	
void Parameter::writeXML(FILE *_file, int identLevel) //Write the XML output
	{
	char tmpval[100]; //temp variable, for convert a number into a string
	int identLeft; //temp variable, for count the times that INSERT_IDENTATION() is called

	/*Prevent write empty strings values*/
	if(this->type==STRING && this->value.asString[0]=='\0') return;

	/*Insert ident characters*/
	INSERT_IDENTATION();

	/*Write the open tag*/
	fprintf(_file, "<%s>", this->name);

	/*Write the value*/
	switch(type)
		{
		case BOOLEAN:
			if( this->value.asBoolean == DISABLED )
				fprintf(_file, "false");
			else
				fprintf(_file, "true");
			break;
	
		case NUMBER:
			sprintf(tmpval, "%d", this->value.asInt );
			fprintf(_file, (char*) tmpval );
			break;
	
		case STRING:
			fprintf( _file, (char*) this->value.asString );
			break;

		case STARTUPNOTIFY:
			((StartupNotify*)this)->writeXML(_file, identLevel+1);
			break;
			
		
		case EDGE:
			switch(this->value.asEdge)
				{
				case BOTTOMLEFT:
					fprintf( _file, "bottomleft" );
					break;
				case BOTTOM:
					fprintf( _file, "bottom" );
					break;
				case BOTTOMRIGHT:
					fprintf( _file, "bottomright" );
					break;
				case LEFT:
					fprintf( _file, "left" );
					break;
				case RIGHT:
					fprintf( _file, "right" );
					break;
				case TOPLEFT:
					fprintf( _file, "topleft" );
					break;
				case TOP:
					fprintf( _file, "top" );
					break;
				case TOPRIGHT:
					fprintf( _file, "topright" );
					break;
				default:
					break;
				}
			break;
		default:
			break;
			
		}

	/*Write the close tag*/
	fprintf(_file, "</%s>\n", this->name);
	}



/* ---METHODS FOR CLASS StartupNotify--- */ 

StartupNotify::StartupNotify(Container *parent_)
	{
	printf("[DEBUG] Create StartupNotify %p. parent: %p\n", this, parent_);

	/*Initialize class variables*/
	this->name=(char*)"startupnotify"; 
	this->type=STARTUPNOTIFY; 
	this->st_enabled=DISABLED;
	this->st_wmclass=NULL;
	this->st_name=NULL;
	this->st_icon=NULL;

	/*Set the parent*/
	this->parent=parent_;
	}

StartupNotify::StartupNotify(xmlDocPtr doc, xmlNodePtr node, Container *parent_)
	{
	printf("[DEBUG] Create StartupNotify %p. doc: %p. node: %p. parent: %p\n", this, doc, node, parent_);

	/*Initialize class variables*/
	this->name=(char*)"startupnotify";
	this->type=STARTUPNOTIFY;
	this->st_wmclass=NULL;
	this->st_name=NULL;
	this->st_icon=NULL;

	/*Set the parent*/
	this->parent=parent_;

	char *thisValue; //temp variable for storing the value string

	/*Lower a level in the XML doc*/
	node=node->children;

	/*Read the nodes and set the variables*/
	while(node != NULL)
		{
		thisValue = (char*) xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
		if(thisValue != NULL)
			{
			if( (! strcmp((char*)node->name, "enabled")) )
				{
				if( (! strcmp(thisValue, "yes")) || (! strcmp(thisValue, "on")) || (! strcmp(thisValue, "true")) )
					this->st_enabled=ENABLED;
				else
					this->st_enabled=DISABLED;
				}
			else if ( (! strcmp((char*)node->name, "wmclass")) )
				{
				this->st_wmclass = (char*) malloc(1+strlen(thisValue));
				strcpy(this->st_wmclass, thisValue);
				}
			else if ( (! strcmp((char*)node->name, "name")) )
				{
				this->st_name = (char*) malloc(1+strlen(thisValue));
				strcpy(this->st_name, thisValue);
				}
			else if ( (! strcmp((char*)node->name, "icon")) )
				{
				this->st_icon = (char*) malloc(1+strlen(thisValue));
				strcpy(this->st_icon, thisValue);
				}
			}
		node=node->next;
		xmlFree(thisValue);
		}
	}

StartupNotify::~StartupNotify()
	{
	printf("[DEBUG] Delete StartupNotify %p\n", this);

	/*If any subparameter is setted, free its memory*/
	if(this->st_name != NULL) free(this->st_name);
	if(this->st_wmclass != NULL) free(this->st_wmclass);
	if(this->st_icon != NULL) free(this->st_icon);

	/*remove itself from its parent*/
	if(this->parent != NULL) parent->removeElement(this);
	}

void StartupNotify::writeXML(FILE *_file, int identLevel) //Write the XML output
	{
	int identLeft; //temp variable, for count the times that INSERT_IDENTATION() is called

	/*Write the open tag*/
	INSERT_IDENTATION();
	fprintf(_file, "<startupnotify>\n");

	/*Write the st_enabled subparameter*/
	INSERT_IDENTATION();
	fprintf(_file, "%s<enabled>", STRING_IDENT);
	if(this->st_enabled == ENABLED)
		fprintf(_file, "true");
	else
		fprintf(_file, "false");
	fprintf(_file, "</enabled>\n");

	/*Write the st_wmclass subparameter*/
	if(this->st_wmclass != NULL)
		{
		INSERT_IDENTATION();
		fprintf(_file, "%s<wmclass>%s</wmclass>\n", STRING_IDENT, this->st_wmclass);
		}

	/*Write the st_name subparameter*/
	if(this->st_name != NULL)
		{
		INSERT_IDENTATION();
		fprintf(_file, "%s<name>%s</name>\n", STRING_IDENT, this->st_name);
		}

	/*Write the st_icon subparameter*/
	if(this->st_icon != NULL)
		{
		INSERT_IDENTATION();
		fprintf(_file, "%s<icon>%s</icon>\n", STRING_IDENT, this->st_icon);
		}

	/*Write the close tag*/
	INSERT_IDENTATION();
	fprintf(_file, "</startupnotify>\n");
	}



/*---METHODS FOR CLASS AdaptedContainer--- */

void AdaptedContainer::writeXML(FILE *_file, int identLevel) //dummy method
	{
	}



/*---METHODS FOR CLASS FinalActionList--- */

FinalActionsList::FinalActionsList()
	{
	printf("[DEBUG] Create FinalActionsList %p\n", this);
	}

FinalActionsList::FinalActionsList(xmlDocPtr doc, xmlNodePtr node)
	{
	printf("[DEBUG] Create FinalActionsList %p. doc: %p. node: %p\n", this, doc, node);
	/*Lower a level in the XML doc*/
	node=node->children;

	/*Look for <action> tags and create the Action objects*/
	while(node != NULL)
		{
		if( (! strcmp( (char*)node->name,  "action" )) )
			{
			Action *action = new Action(doc, node, this);
			this->insertElement(ACTION, (void*) action );
			}
		node = node->next;
		}
	}

FinalActionsList::~FinalActionsList()
	{
	printf("[DEBUG] Delete FinalActionsList %p\n", this);

	/*Delete the children actions*/
	int NOE=this->getNumberOfElements();
	while(NOE>0)
		{
		delete (Action*) this->getElement(NOE);
		NOE--;
		}
	}

void FinalActionsList::writeXML(FILE *_file, int identLevel) //Write the XML output
	{
	int count=1; //for get the elements throught a loop
	int identLeft; //temp variable, for count the times that INSERT_IDENTATION() is called
	int elements = this->getNumberOfElements(); //This is for call the method just one time
	AdaptedContainer *thisEl; //temporal element. For get the elements throught a loop

	/*write the open tag*/
	INSERT_IDENTATION();
	fprintf(_file, "<finalactions>\n");

	/*call writeXML() for the children*/
	while(count <= elements)
		{
		thisEl = (AdaptedContainer *) this->getElement(count);
		thisEl->writeXML(_file, identLevel+1);
		count++;
		}

	/*write the close tag*/
	INSERT_IDENTATION();
	fprintf(_file, "</finalactions>\n");
	}

Action *FinalActionsList::getAction(char *_name) //Look for a child action with the specified name and return its pointer
	{
	/*Look for an element with the name specified in _name*/
	int count=0;
	int NOE=this->getNumberOfElements();
	while( count < NOE )
		{
		count++;
		if( !strcmp( (char*)(((Action*)(this->getElement(count)))->getName()),  _name ) )
			return (Action*)(this->getElement(count));
		}
	return NULL;
	}



/*---METHODS FOR CLASS Action--- */

Action::Action(char *type_, Container *parent_)
	{
	printf("[DEBUG] Create Action %p. type: %s. parent: %p\n", this, type_, parent_);

	/*Initialize variables*/
	this->finalActionsList=NULL;
	this->type=0;

	/*Set the parent*/
	this->parent=parent_;

	/*Look in actionModel[] for a action type with the name specified in type_*/
	int count=0; //temp count
	while(actionModel[count][MODEL_NAME] != NULL)
		{
		if( (!strcmp( type_, actionModel[count][MODEL_NAME] ) ) )
			{
			/*If found, set its index number to type*/
			this->type = count;
			break;
			}
		count++;
		}

	/*set the Action name*/
	this->setName((void*)type_);
	}


Action::Action(xmlDocPtr doc, xmlNodePtr node, Container *parent_)
	{
	printf("[DEBUG] Create Action %p. doc: %p. node: %p. parent: %p\n", this, doc, node, parent_);
	/*Initialize variables*/
	this->finalActionsList=NULL;

	/*Set the Action name*/
	this->setName( (void*) xmlGetProp( node,  (xmlChar*)"name" ) );

	/*Set the parent*/
	this->parent=parent_;

	/*Lower a level in XML tree*/
	node=node->children;

	/*Process the children*/
	while(node != NULL)
		{
		/*If child is a final actions list, create a FinalActionsList */
		if( (! strcmp( (char*)node->name,  "finalactions" )) )
			this->finalActionsList = new FinalActionsList(doc, node);
		/*If child is a startupnotify, create a StartupNotify */
		else if( (! strcmp( (char*)node->name,  "startupnotify" )) )
			this->insertElement(PARAMETER, (void*) new StartupNotify(doc, node, this) );
		/*If child is a string, do nothing */
		else if( (! strcmp( (char*)node->name,  "text" )) )
			{
			}
		/*If child is a comment, do nothing */
		else if( (! strcmp( (char*)node->name,  "comment" )) )
			{
			}
		/*Otherwise, create a Parameter */
		else 
			this->insertElement(PARAMETER, (void*) new Parameter(doc, node, this));

		/*Go to next child*/
		node = node->next;
		}
	/*Look in actionModel[] for a action type with this Action name*/
	int count=0;
	type=0;
	while(actionModel[count][MODEL_NAME] != NULL)
		{
		if( (!strcmp( (char*)this->getName(), actionModel[count][MODEL_NAME] ) ) )
			{
			/*If found, set its index number to type*/
			this->type = count;
			break;
			}
		count++;
		}
	}

Action::~Action()
	{
	printf("[DEBUG] Delete Action %p\n", this);

	/*Delete its children*/
	int NOE=this->getNumberOfElements();
	while(NOE>0)
		{
		switch( ((Parameter*)(this->getElement(NOE)))->type )
			{
			case STARTUPNOTIFY:
				delete (StartupNotify*) this->getElement(NOE);
				break;
			default:
				delete (Parameter*) this->getElement(NOE);
				break;
			}
		NOE--;
		}

	/*Delete it final actions list*/
	if(this->finalActionsList != NULL)
		{
		delete this->finalActionsList;
		}

	/*Remove itself from its parent*/
	if(this->parent != NULL)
		this->parent->removeElement(this);
	}

void Action::modelate() //adjust the parameters and finalactions to the model in actionModel[]
	{
	/*NOTE: This method is ugly*/
	int countIn;
	int countOut;
 	Boolean tmpBoolean;
 	int tmpNumber;
 	EdgeType tmpEdge;
 	StartupNotify *tmpStartupNotify;
	char *tmpString;
	char *tmpName;
	char *tmpValue;
	Parameter *tmpParameter;
	ParameterType paramType;

	/*If the parameters are specified in actionModel[], set them*/
	if(actionModel[type][MODEL_PARAMETERS] != NULL)
		{
		countIn=0;
		tmpString=(char*)malloc(1+strlen(actionModel[type][MODEL_PARAMETERS]));
		while((unsigned int)countIn < strlen(actionModel[type][MODEL_PARAMETERS]))
			{
			//Look for the parameter type (in model). Save it in paramType
			switch(actionModel[type][MODEL_PARAMETERS][countIn])
				{
				case 'B': paramType=BOOLEAN; break;
				case 'N': paramType=NUMBER; break;
				case 'E': paramType=EDGE; break;
				case 'S': paramType=STRING; break;
				case 'R': paramType=STARTUPNOTIFY; break;
				default: paramType=PARAMETER_TYPE_UNDEFINED;
				}

			//If find a valid type				
			if(paramType != PARAMETER_TYPE_UNDEFINED)
				{
				//Check if it is not the last char and skip the space
				if(actionModel[type][MODEL_PARAMETERS][countIn+1] != '\0' && actionModel[type][MODEL_PARAMETERS][countIn+1] != '|' );
					countIn=countIn+2;

				//get the parameter name (in model). Save it in tmpName
				countOut=0; 
				while(actionModel[type][MODEL_PARAMETERS][countIn] != ' ' && actionModel[type][MODEL_PARAMETERS][countIn] != '|' && actionModel[type][MODEL_PARAMETERS][countIn] != '\0')
					{
					tmpString[countOut]=actionModel[type][MODEL_PARAMETERS][countIn];
					countIn++;
					countOut++;
					}
				tmpString[countOut]='\0';
				tmpName=(char*)malloc(1+strlen(tmpString));
				strcpy(tmpName, tmpString);
	
				//Look if there is a parameter in action with the found Name.
				tmpParameter=getParameter(tmpString);

				//Check if it is not the last char and skip the space
				if(actionModel[type][MODEL_PARAMETERS][countIn] != '\0' && actionModel[type][MODEL_PARAMETERS][countIn] != '|')
					countIn++;

				//get the parameter value (in model). Save it in tmpValue
				countOut=0;
				while(actionModel[type][MODEL_PARAMETERS][countIn] != '|' && actionModel[type][MODEL_PARAMETERS][countIn] != '\0')
					{
					tmpString[countOut]=actionModel[type][MODEL_PARAMETERS][countIn];
					countIn++;
					countOut++;
					}
				tmpString[countOut]='\0';
				tmpValue=(char*)malloc(1+strlen(tmpString));
				strcpy(tmpValue, tmpString);

				//set the value
				switch(paramType)
					{
					case BOOLEAN:
						//read the value
						if(tmpValue[0]=='T')
							tmpBoolean=ENABLED;
						else
							tmpBoolean=DISABLED;
						free(tmpValue);
						//If there isn't a parameter in action with the model's name, create it
						if(tmpParameter == NULL)
							{
							tmpParameter=new Parameter(tmpName, tmpBoolean, this);
							this->insertElement(PARAMETER, tmpParameter);
							}
						//If type is incorrect, fix it
						else if(tmpParameter->type != BOOLEAN)
							{
							tmpParameter->type = BOOLEAN;
							tmpParameter->value.asBoolean=tmpBoolean;
							}
						break;
					case NUMBER:
						//read the value
						tmpNumber=atoi(tmpValue);
						free(tmpValue);
						//If there isn't a parameter in action with the model's name, create it
						if(tmpParameter == NULL)
							{
							tmpParameter=new Parameter(tmpName, tmpNumber, this);
							this->insertElement(PARAMETER, tmpParameter);
							}
						//If type is incorrect, fix it
						else if(tmpParameter->type != NUMBER)
							{
							tmpParameter->type = NUMBER;
							tmpParameter->value.asInt=tmpNumber;
							}
						break;
					case EDGE:
						//read the value
						if( (! strcmp(tmpValue, "bottomleft") ) )
							tmpEdge=BOTTOMLEFT;
						else if( (! strcmp(tmpValue, "bottom") ) )
							tmpEdge=BOTTOM;
						else if( (! strcmp(tmpValue, "bottomright") ) )
							tmpEdge=BOTTOMRIGHT;
						else if( (! strcmp(tmpValue, "left") ) )
							tmpEdge=LEFT;
						else if( (! strcmp(tmpValue, "right") ) )
							tmpEdge=RIGHT;
						else if( (! strcmp(tmpValue, "topleft") ) )
							tmpEdge=TOPLEFT;
						else if( (! strcmp(tmpValue, "top") ) )
							tmpEdge=TOP;
						else if( (! strcmp(tmpValue, "topright") ) )
							tmpEdge=TOPRIGHT;
						else
							tmpEdge=BOTTOMRIGHT;
						free(tmpValue);
						//If there isn't a parameter in action with the model's name, create it
						if(tmpParameter == NULL)
							{
							tmpParameter=new Parameter(tmpName, tmpEdge, this);
							this->insertElement(PARAMETER, tmpParameter);
							}
						//If type is incorrect, fix it
						else if(tmpParameter->type != EDGE)
							{
							tmpParameter->type = EDGE;
							tmpParameter->value.asEdge=tmpEdge;
							}
						break;
					case STRING:
						//If there isn't a parameter in action with the model's name, create it
						if(tmpParameter == NULL)
							{
							tmpParameter=new Parameter(tmpName, tmpValue, this);
							this->insertElement(PARAMETER, tmpParameter);
							}
						//If type is incorrect, fix it
						else if(tmpParameter->type != STRING)
							{
							tmpParameter->type = STRING;
							tmpParameter->value.asString=tmpValue;
							}
						break;
					case STARTUPNOTIFY:
						//If there isn't a parameter in action with the model's name, create it
						if(tmpParameter == NULL)
							{
							tmpStartupNotify=new StartupNotify(this);
							this->insertElement(PARAMETER, (void*)tmpStartupNotify);
							}
						break;

					default:
						break;
					}

				}
			else
				{
				countIn++;
				}
			}
		free(tmpString);
		}

	/*If the final actions are specified in actionModel[], set them*/
	if(actionModel[type][MODEL_FINAL_ACTIONS] != NULL && this->finalActionsList == NULL)
		{
		this->finalActionsList = new FinalActionsList();
		countIn=0;
		countOut=0;
		tmpString=(char*)malloc(1+strlen(actionModel[type][MODEL_FINAL_ACTIONS]));
		while((unsigned int)countIn < 1+strlen(actionModel[type][MODEL_FINAL_ACTIONS]))
			{
			if(actionModel[type][MODEL_FINAL_ACTIONS][countIn] == '\0' || actionModel[type][MODEL_FINAL_ACTIONS][countIn] == '|' )
				{
				tmpString[countOut]='\0';
				countIn++;
				countOut=0;
				tmpName=(char*)malloc(1+strlen(tmpString));
				strcpy(tmpName, tmpString);
				if(this->finalActionsList->getAction(tmpName) == NULL)
					{
					Action *action = new Action(tmpName, this->finalActionsList);
					this->finalActionsList->insertElement(ACTION, action);
					}
				}
			else
				{
				tmpString[countOut]=actionModel[type][MODEL_FINAL_ACTIONS][countIn];
				countOut++;
				}
			countIn++;
			}
		free(tmpString);
		}
	}

Parameter *Action::getParameter(char *parameterName) //Look for a child parameter with the specified name and return its pointer
	{
	/*Look for a child parameter with the name specified in parameterName*/
	int noe=this->getNumberOfElements(); //this is for call the method just one time
	int count=0; //temp count
	Parameter *thisParam; //temp parameter
	while(count<noe)
		{
		count++;
		/*If found, return it*/
		thisParam=(Parameter*)this->getElement(count);
		if( (!strcmp( parameterName,  thisParam->name  )) )
			{
			return thisParam;	
			break;
			}
		}

	/*If nothing found, return NULL*/
	if(count == noe)
		{
		return NULL;
		}
	}

char *Action::getParameterDescription(char *parameterName) //get the description for a parameter (search in actionModel[])
	{
	int count=0; //temp count for readed characters
	int countOut=0; //temp count for writed characters
	char *tmpString; //temp string
	char *tmpDescription; //temp value for store a description
	char *model=(char*)actionModel[type][MODEL_PARAMETERS_DESCRIPTIONS]; //The parameters descriptions string in actionModel[]

	/*If type is not defined, return the parameter name as its own description*/
	if(type==0)
		return parameterName;


	/*Continue searching untill the end of the string*/
	while(model[count] != '\0')
		{
		/*skip the separators*/
		if(model[count] == '|' || model[count] == ' ')
			count++;
		else
			{
			tmpString=(char*)malloc(1+strlen(model));
			countOut=0;
			/*Look for the parameter name specified in actionModel[] and save it to tmpString*/
			while(model[count] != ':')
				{
				/*If string ends before ':', the description string in actionModel[] is wrong.*/
				if(model[count] == '\0' || model[count] == '|' )
					return parameterName;
				/*copy the current character to tmpString*/
				tmpString[countOut]=model[count];
				count++;
				countOut++;
				}
			tmpString[countOut]='\0';

			/*If string ends before without specify a value, the description string in actionModel[] is wrong.*/
			if(model[count+1]=='\0')
				{
				free(tmpString);
				return parameterName;
				}
			/*Skip the separators*/
			count+=2;

			/*Compare the Parameter name got in previous step with the Parameter name specified as argument*/
			if(!strcmp( parameterName, tmpString ))
			/*If those are equal*/
				{
				/*Copy the value specified in actionModel[] to tempString*/
				countOut=0;
				while(model[count] != '\0' && model[count] != '|')
					{
					tmpString[countOut]=model[count];
					count++;
					countOut++;
					}
				tmpString[countOut]='\0';

				/*Copy the description (in tempString) to tempValue, and return it*/
				tmpDescription=(char*)malloc(1+strlen(tmpString));
				strcpy(tmpDescription, tmpString);
				free(tmpString);
				return(tmpDescription);
				}
			else
			/*If those are diferent*/
				{
				/*Free tmpString*/
				free(tmpString);

				/*Continue untill next parameter declaration in actionModel[], or untill the end of declarations*/
				while(model[count] != '\0' && model[count] != '|')
					count++;
				}
			}
		}
		/*If nothing found, return the parameter name as its own description*/
		return parameterName;
	
	}
	
void Action::writeXML(FILE *_file, int identLevel) //Write the XML output
	{
	int elements = this->getNumberOfElements(); //element count
	int identLeft; //temp variable, for count the times that INSERT_IDENTATION() is called

	/*Write the open tag*/
	INSERT_IDENTATION();
	fprintf(_file, "<action name=\"%s\"", (char*)this->getName());


	if(elements == 0 && this->finalActionsList == NULL)
	/*if is empty, write the autoclosed /> */
		fprintf(_file, " />\n");
	else
	/*if is not empty*/
		{
		/*print the end of the open tag*/
		fprintf(_file, ">\n");

		/*call writeXML() for the children Parameters*/
		Parameter *thisParameter; //temp variable for store a Parameter
		StartupNotify *thisStartupNotify; //temp variable for store a StartupNotify
		int count=1;
		while(count <= elements)
			{
			thisParameter = (Parameter*) this->getElement(count);
			if(thisParameter->type == STARTUPNOTIFY)
				{
				thisStartupNotify = (StartupNotify*) thisParameter;
				thisStartupNotify->writeXML(_file, identLevel+1);
				}
			else
				thisParameter->writeXML(_file, identLevel+1);
			count++;
			}

		/*call writeXML() for the final actions list (if any)*/
		if (this->finalActionsList != NULL)
			this->finalActionsList->writeXML(_file, identLevel+1);

		/*Write the close tag*/
		INSERT_IDENTATION();
		fprintf(_file, "</action>\n");
		}
	}



/*---METHODS FOR CLASS KeyBind--- */

KeyBind::KeyBind(Container *parent_)
	{
	printf("[DEBUG] Create KeyBind %p. parent: %p\n", this, parent_);

	/*Initialize class variables*/
	char *tmpString;
	tmpString = (char*)malloc(2);
	tmpString[0]='\0';
	this->setName(tmpString);
	
	/*set the parent*/
	this->parent=parent_;
	}

KeyBind::KeyBind(char *keys, Container *parent_)
	{
	printf("[DEBUG] Create KeyBind %p. keys: %s. parent: %p\n", this, keys, parent_);

	/*Set the parent*/
	this->parent=parent_;

	/*set key combination*/
	this->setName( (void*) keys );
	}

KeyBind::KeyBind(xmlDocPtr doc, xmlNodePtr node, Container *parent_)
	{
	printf("[DEBUG] Create KeyBind %p. doc: %p. node: %p. parent: %p\n", this, doc, node, parent_);

	/*Set the parent*/
	this->parent=parent_;

	/*set key combination*/
	this->setName( (void*) xmlGetProp( node,  (xmlChar*)"key" ) );



	/*Create the children Actions and KeyBinds*/
	KeyBind *tmpkb; //temp variable for store a KeyBind
	node=node->children; //Lower a level in XML tree
	while(node != NULL)
	/*For every node inside do:*/
		{
		/*If child is a keybind, create it*/
		if( (! strcmp( (char*)node->name,  "keybind" )) )
			{
			tmpkb=new KeyBind(doc, node, this);
			this->insertElement(KEYBIND, (void*) tmpkb );
			}
		/*If child is an action, create it*/
		else if( (! strcmp( (char*)node->name,  "action" )) )
			{
			Action *action = new Action(doc, node, this);
			this->insertElement(ACTION, (void*) action );
			}
		/*Jump to next node*/
		node = node->next;
		}
	}

KeyBind::~KeyBind()
	{
	printf("[DEBUG] Delete KeyBind %p\n", this);

	/*Delete all children*/
	int NOE=this->getNumberOfElements(); //This is for call the method just one time
	while(NOE>0)
		{
		switch(this->getDataType(NOE))
			{
			case ACTION:
				delete (Action*) this->getElement(NOE);
				break;
			case KEYBIND:
				delete (KeyBind*) this->getElement(NOE);
				break;
			default:
				break;
			}
		NOE--;
		}

	/*Remove itself from its parent */
 	if(this->parent != NULL) this->parent->removeElement(this);
	}
	
void KeyBind::writeXML(FILE *_file, int identLevel) //Write the XML output
	{
	/*write the open tag*/
	int identLeft; //temp variable, for count the times that INSERT_IDENTATION() is called
	INSERT_IDENTATION();
	fprintf(_file, "<keybind key=\"%s\">\n", (char*)this->getName());

	/*call the writeXML() method for the children*/
	int NOE = this->getNumberOfElements(); //elements count. This is for call the method just one time
	int count; //temp count
	AdaptedContainer *thisEl; //temporal element for store an AdaptedContainer
	count=1;
	while(count <= NOE)
		{
		thisEl = (AdaptedContainer *) this->getElement(count);
		thisEl->writeXML(_file, identLevel+1);
		count++;
		}

	/*write the close tag*/
	INSERT_IDENTATION();
	fprintf(_file, "</keybind>\n");
	}



/*---METHODS FOR CLASS Keyboard--- */

Keyboard::Keyboard(char* _file)
	{
	printf("[DEBUG] Create Keyboard %p. file: %s\n", this, _file);

	/*Set the xmlFile variable*/
	this->xmlFile=_file;

	xmlDocPtr doc;
	xmlNodePtr node;
	KeyBind *tmpkb; //temp variable for store a KeyBind

	/*Parse the XML config file*/
	doc = xmlParseFile(_file);

	/*If were errors during parse file, or the file is empty, exit*/
	if(doc == NULL || xmlDocGetRootElement(doc) == NULL ) return;

	/*Lower a level in XML tree*/
	node = xmlDocGetRootElement(doc)->children;

	/*Search for a <keyboard> tag*/
	while(node != NULL)
		{
		if( (! strcmp( (char*)node->name,  "keyboard" )) )
			break;
		node = node->next;
		}

	/*Enter to the <keyboard> node*/
	node=node->children;

	/*Create the KeyBinds*/
	while(node != NULL)
		{
		if( (! strcmp( (char*)node->name,  "keybind" )) )
			{
			tmpkb=new KeyBind(doc, node, this);
			this->insertElement(KEYBIND, (void*) tmpkb );
			}
		node = node->next;
		}

	/*Free the memory used by the XML parser*/
	xmlFreeDoc(doc);
	xmlFreeNode(node);
	}

Keyboard::~Keyboard()
	{
	printf("[DEBUG] Delete Keyboard %p,\n", this);

	/*Delete the children KeyBinds*/
	int NOE=this->getNumberOfElements(); //Elements count.
	while(NOE>0)
		{
		delete (KeyBind*)this->getElement(NOE);
		NOE--;
		}
	}

void Keyboard::writeXML(int identLevel) //Write the XML output
	{
	int elements=this->getNumberOfElements(); //Elements count
	int count; //temp count
	int identLeft; //temp variable, for count the times that INSERT_IDENTATION() is called
	int fileLength; //temp variable for store the file length. Know this value is needed for allocate enought memory.
	char* fileContent; //Here will be dumped the file data
	xmlDocPtr doc;
	xmlNodePtr node;

	/*Initialize variables*/
	fileLength=0;
	count=0;

	/*STEP 1: Save the file content in fileContent*/
	FILE *outXML=fopen(xmlFile, "r"); //Open the file in read mode
	while(fgetc(outXML) != EOF) fileLength++; //get the file length
	fileContent=(char*)malloc(1+fileLength); //allocate enought memory to dump the file
	fseek(outXML, SEEK_SET,0); //back to the start of the file
	while(count<fileLength) //copy the file to the memory
		{
		fileContent[count]=fgetc(outXML);
		count++;
		}
	fileContent[fileLength]='\0'; //Write the end character
	fclose(outXML); //close the file

	/*STEP 2: write everything before the keyboard*/
	outXML=fopen(xmlFile, "w"); //open the file in write mode
	fprintf(outXML, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"); //write the xml version tag //FIXME: write the real line. The encoding may not be UTF-8
	fprintf(outXML, "<openbox_config>"); //write the <openbox_config> open tag
	doc = xmlParseMemory(fileContent, strlen(fileContent) ); //Parse the file content (dumped in memory)
	if(doc == NULL || xmlDocGetRootElement(doc) == NULL ) return; //if were errors in parsing, or XML is empty, exit
	node = xmlDocGetRootElement(doc)->children; //Lower a level in XML tree
	while(node != NULL)//Look for a <keyboard> tag
		{
		if( (! strcmp( (char*)node->name,  "keyboard" )) )
			{
			node=node->next;
			break;
			}
		else
			{
			/*If this is not <keyboard>, save its content to the file*/
			xmlElemDump(outXML, doc, node);
			node = node->next;
			}
		}

	/*STEP 3: write the keyboard*/
	FILE *_file=outXML; //This is for the INSERT_IDENTATION() MACRO
	KeyBind *thisEl; //temporal value for store a KeyBind
	fprintf(outXML, "<keyboard>\n"); //Write the open tag
	count=1;
	while(count <= elements)//call the writeXML() method for the children
		{
		thisEl = (KeyBind *) this->getElement(count);
 		thisEl->writeXML(outXML, identLevel+1);
		count++;
		}
	INSERT_IDENTATION();
	fprintf(outXML, "</keyboard>"); //Write the close tag

	/*STEP 4: write everything after the keyboard*/
	while(node != NULL)
		{
		xmlElemDump(outXML, doc, node);
		node = node->next;
		}
	fprintf(outXML, "</openbox_config>\n");//Write the <openbox_config> close tag
	xmlFreeDoc(doc); //Free the memory used by XML parser
	xmlFreeNode(node); //Free the memory used by XML parser
	free(fileContent); //Free the memory used to dump the file content
	fclose(outXML); //Close the config file
	}

void Keyboard::clear() //Delete children KeyBinds
	{
	/*Delete the children KeyBinds*/
	int NOE=this->getNumberOfElements(); //Elements count.
	while(NOE>0)
		{
		delete (KeyBind*)this->getElement(NOE);
		this->removeElement(NOE);
		NOE--;
		}
	}
