#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

#define ERROR -1

#define STRING_IDENT "  "
#define INSERT_IDENTATION() for(identLeft=identLevel;identLeft>0;identLeft--) fprintf(_file, STRING_IDENT);

typedef enum
	{
	DISABLED=0,
	ENABLED=1
	}Boolean;

/*Data types for Containers:*/
typedef enum
	{
	CONTAINER_DATA_TYPE_UNDEFINED=0,
	KEYBOARD,
	KEYBIND,
	ACTION,
	PARAMETER,
	FINALACTIONSLIST
	}ContainerDataType;

/*Parameter types:*/
typedef enum
	{
	PARAMETER_TYPE_UNDEFINED=0,
	BOOLEAN,
	NUMBER,
	STRING,
	EDGE,
	STARTUPNOTIFY,
	}ParameterType;

/*edges/corners:*/
typedef enum
	{
	NONE=0,
	BOTTOMLEFT,
	BOTTOM,
	BOTTOMRIGHT,
	LEFT,
	RIGHT,
	TOPLEFT,
	TOP,
	TOPRIGHT
	}EdgeType;


/*CLASS DEFINITIONS:*/

class AdaptedContainer : public Container //This is only for add the writeXML() virtual method
	{
	public:
	 virtual void writeXML(FILE *_file, int identLevel);
	};

class Parameter // Parameter, e.g: <desktop>5</desktop>
	{
	protected:
	 Container *parent;
	public:
	 ParameterType type; //Data type, e.g:  BOOLEAN, NUMBER, STRING
	 char *name; //Parameter name, e.g: wrap
	 union
		{
		char *asString;
		int asInt;
		EdgeType asEdge;
		Boolean asBoolean;
		}value; //The value of the parameter, e.g: ENABLED(asBoolean), 34(asInt), gnome-screenshot(asString)

	/*Constructors and destructor*/
	 Parameter();
	 Parameter(Container *parent_);
	 Parameter(char *name_, char *value_, Container *parent_);
	 Parameter(char *name_, int value_, Container *parent_);
	 Parameter(char *name_, EdgeType value_, Container *parent_);
	 Parameter(char *name_, Boolean value_, Container *parent_);
	 Parameter(xmlDocPtr doc, xmlNodePtr node, Container *parent_);
	 ~Parameter(); //Destructor

	 /*Methods*/
	 void writeXML(FILE *_file, int identLevel); //Write the XML output
	};

class StartupNotify : public Parameter //<startupnotify> is a special parameter, so it has its own class
	{
	public:
	 char *st_name; //<name>
	 Boolean st_enabled; //<enabled>
	 char *st_wmclass; // <wmclass> FIXME: SegFault if wmclass is a long string
	 char *st_icon; //<icon>

	 /*Constructors and destructor*/
	 StartupNotify(Container *parent_);
	 StartupNotify(xmlDocPtr doc, xmlNodePtr node, Container *parent);
	 ~StartupNotify(); //Destructor

	 /*Methods*/
	 void writeXML(FILE *_file, int identLevel); //Write the XML output
	};

class Action; //This is just a declaration. The class is defined later

class FinalActionsList : public AdaptedContainer // <finalactions> stores action that will be executed after the parent action
	{
	public:
	 /*Constructors and destructor*/
	 FinalActionsList();
	 FinalActionsList(xmlDocPtr doc, xmlNodePtr node);
	 ~FinalActionsList(); //Destructor

	 /*Methods*/
	 void writeXML(FILE *_file, int identLevel); //Write the XML output
	 Action *getAction(char* _name); //Look for a child action with the specified name and return its pointer
	};

class Action : public AdaptedContainer //Action stores an action, e.g: <action name="Maximize" />
	{
	Container *parent; //The parent KeyBind/FinalActionsList

	public:
	 int type; //This is for search in actionModel[]
	 FinalActionsList *finalActionsList; // <finalactions>

	 /*Constructors and destructor*/
	 Action(char *type_, Container *parent_);
	 Action(xmlDocPtr doc, xmlNodePtr node, Container *parent_);
	 ~Action(); //Destructor

	 /*Methods*/
	 void writeXML(FILE *_file, int identLevel); //Write the XML output
	 void modelate(); //adjust the parameters and finalactions to the model in actionModel[]
	 Parameter* getParameter(char *parameterName); //Look for a child parameter with the specified name and return its pointer
	 char* getParameterDescription(char *parameterName); //get the description for a parameter (search in actionModel[])
	};

class KeyBind : public AdaptedContainer //Keybind, e.g: <keybind keys="C-a"> (...) </keybind>
	{
	public:
	 Container *parent; //The parent KeyBind/Keyboard

	 /*Constructors and destructor*/
	 KeyBind(Container *parent_);
	 KeyBind(char *keys, Container *parent_);
	 KeyBind(xmlDocPtr doc, xmlNodePtr node, Container *parent_);
	 ~KeyBind(); //Destructor

	 /*Methods*/
	 void writeXML(FILE *_file, int identLevel); //Write the XML output
	};

class Keyboard : public AdaptedContainer //Keyboard section in openbox's rc file e.g: <keyboard> (...)</keyboard
	{
	public:
	 char *xmlFile; //Config file path

	 /*Constructors and destructor*/
	 Keyboard(char* _file); //_file: the XML config file
	 ~Keyboard(); //Destructor 

	 /*Methods*/
	 void writeXML(int identLevel); //Write the XML output
	 void clear(); //Delete children KeyBinds
	};
