#include "keybinder_signal_handlers.h"

//GUI_KeyboardDrawing prefix: S_KB_
void S_KB_addButton(GtkWidget *widget, void *keyboardDrawing)
	{
	((GUI_KeyboardDrawing*)keyboardDrawing)->newKeyBind();
	}

void S_KB_applyButton(GtkWidget *widget, void *keyboard_)
	{
	Keyboard *keyboard = (Keyboard*) keyboard_;
	keyboard->writeXML(1); //TODO: write in the real ident level
	system("openbox --reconfigure");
	}

void S_KB_clearButton(GtkWidget *widget, void *keyboardDrawing)
	{
	((GUI_KeyboardDrawing*)keyboardDrawing)->clear();
	}

//GUI_KeyBindDrawing prefix: S_KD_
void S_KD_menuKeyBindButton(GtkWidget *widget, void *keybindDrawing)
	{
	((GUI_KeyBindDrawing*)keybindDrawing)->showMenu();
	}

//GUI_ActionDrawing prefix: S_AD_
void S_AD_menuActionButton(GtkWidget *widget, void *actionDrawing)
	{
	((GUI_ActionDrawing*)actionDrawing)->showMenu();
	}

//GUI_KeyBindEditor prefix: S_KE_
void S_KE_okButton(GtkWidget *widget, void *keybindEditor)
	{
	delete (GUI_KeyBindEditor*)keybindEditor;
	}

//GUI_ActionEditor prefix: S_AE_
void S_AE_okButton(GtkWidget *widget, void *actionEditor)
	{
	delete (GUI_ActionEditor*)actionEditor;
	}

void S_AE_edgeButton(GtkWidget *widget, void *label)
	{
	gtk_label_set_text(GTK_LABEL(label), gtk_button_get_label(GTK_BUTTON(widget)));
	}

void S_AE_st_icon(GtkWidget *widget, void *image)
	{
	if( gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget)) != NULL )
		gtk_image_set_from_file(GTK_IMAGE(image), gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget)));
	else
		gtk_image_set_from_stock(GTK_IMAGE(image), GTK_STOCK_FILE, GTK_ICON_SIZE_LARGE_TOOLBAR);
		
	}

void S_AE_addActionButton(GtkWidget *widget, void *actionEditor)
	{
	((GUI_ActionEditor*)actionEditor)->showActionSelectorMenu();
	}

//GUI_KeyBindMenu prefix: S_KM_
void S_KM_editKeysItem(GtkWidget *widget, void *menu_)
	{
	GUI_KeyBindMenu *menu = (GUI_KeyBindMenu*)menu_;
	menu->callerDrawing->showEditor();
	delete menu;
	}

void S_KM_addKeyBindItem(GtkWidget *widget, void *menu_)
	{
	GUI_KeyBindMenu *menu = (GUI_KeyBindMenu*)menu_;
	menu->addKeyBind();
	delete menu;
	}

void S_KM_deleteItem(GtkWidget *widget, void *menu_)
	{
	GUI_KeyBindMenu *menu = (GUI_KeyBindMenu*)menu_;
	menu->deleteCaller();
 	delete menu;
	}

void S_KM_destroy(GtkWidget *widget, void *menu_)
	{
	delete (GUI_KeyBindMenu*)menu_;
	}


//GUI_ActionMenu prefix: S_AM_
void S_AM_editSettingsItem(GtkWidget *widget, void *menu_)
	{
	GUI_ActionMenu *menu = (GUI_ActionMenu*)menu_;
	menu->editSettings();
	delete menu;
	}


void S_AM_deleteItem(GtkWidget *widget, void *menu_)
	{
	GUI_ActionMenu *menu = (GUI_ActionMenu*)menu_;
	menu->deleteCaller();
	delete menu;
	}

void S_AM_destroy(GtkWidget *widget, void *menu_)
	{
	
	delete (GUI_ActionMenu*)menu_;
	}

//GUI_ActionSelectorMenu prefix: S_AS_
void S_AS_addActionItem(GtkWidget *widget, void *arguments)
	{
	void ** args = (void**)arguments;
	GUI_ActionSelectorMenu *menu = (GUI_ActionSelectorMenu*)args[0];
	char* actionType = (char*)args[1];
	menu->addAction(menu, actionType);

	}
